/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.smile;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Set;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonEncoding;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonFactory;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonGenerator;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.JsonParser;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.StreamReadConstraints;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.StreamReadFeature;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.core.StreamWriteFeature;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.graylog.shaded.opensearch2.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.smile.SmileXContentGenerator;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.smile.SmileXContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentGenerator;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class SmileXContent
implements XContent {
    public static final int DEFAULT_MAX_STRING_LEN = Integer.parseInt(System.getProperty("opensearch.xcontent.string.length.max", Integer.toString(Integer.MAX_VALUE)));
    public static final boolean USE_FAST_DOUBLE_WRITER = Boolean.getBoolean("opensearch.xcontent.use_fast_double_writer");
    static final SmileFactory smileFactory = new SmileFactory();
    public static final SmileXContent smileXContent;

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder(smileXContent);
    }

    private SmileXContent() {
    }

    @Override
    public MediaType mediaType() {
        return XContentType.SMILE;
    }

    @Override
    public byte streamSeparator() {
        return -1;
    }

    @Override
    public XContentGenerator createGenerator(OutputStream os, Set<String> includes, Set<String> excludes) throws IOException {
        return new SmileXContentGenerator(smileFactory.createGenerator(os, JsonEncoding.UTF8), os, includes, excludes);
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, String content) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, smileFactory.createParser(content));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, InputStream is) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, smileFactory.createParser(is));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, smileFactory.createParser(data));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, byte[] data, int offset, int length) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, smileFactory.createParser(data, offset, length));
    }

    @Override
    public XContentParser createParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler, Reader reader) throws IOException {
        return new SmileXContentParser(xContentRegistry, deprecationHandler, smileFactory.createParser(reader));
    }

    static {
        smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, false);
        smileFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        smileFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        smileFactory.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
        smileFactory.setStreamReadConstraints(StreamReadConstraints.builder().maxStringLength(DEFAULT_MAX_STRING_LEN).build());
        smileFactory.configure(StreamReadFeature.USE_FAST_DOUBLE_PARSER.mappedFeature(), true);
        smileFactory.configure(StreamWriteFeature.USE_FAST_DOUBLE_WRITER.mappedFeature(), USE_FAST_DOUBLE_WRITER);
        smileXContent = new SmileXContent();
    }
}

