/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.core.xcontent;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;

public class MediaTypeParser<T extends MediaType> {
    private final Map<String, T> formatToMediaType;
    private final Map<String, T> typeWithSubtypeToMediaType;

    public MediaTypeParser(T[] acceptedMediaTypes) {
        this((MediaType[])acceptedMediaTypes, Map.of());
    }

    public MediaTypeParser(T[] acceptedMediaTypes, Map<String, T> additionalMediaTypes) {
        int size = acceptedMediaTypes.length + additionalMediaTypes.size();
        HashMap<String, Object> formatMap = new HashMap<String, Object>(size);
        HashMap<String, Object> typeMap = new HashMap<String, Object>(size);
        for (Object mediaType : acceptedMediaTypes) {
            typeMap.put(mediaType.typeWithSubtype(), mediaType);
            formatMap.put(mediaType.format(), mediaType);
        }
        for (Map.Entry entry : additionalMediaTypes.entrySet()) {
            Object mediaType;
            String typeWithSubtype = (String)entry.getKey();
            mediaType = (MediaType)entry.getValue();
            typeMap.put(typeWithSubtype.toLowerCase(Locale.ROOT), mediaType);
            formatMap.put(mediaType.format(), mediaType);
        }
        this.formatToMediaType = Map.copyOf(formatMap);
        this.typeWithSubtypeToMediaType = Map.copyOf(typeMap);
    }

    public T fromMediaType(String mediaType) {
        ParsedMediaType parsedMediaType = this.parseMediaType(mediaType);
        return parsedMediaType != null ? (T)parsedMediaType.getMediaType() : null;
    }

    public T fromFormat(String format) {
        if (format == null) {
            return null;
        }
        return (T)((MediaType)this.formatToMediaType.get(format.toLowerCase(Locale.ROOT)));
    }

    public ParsedMediaType parseMediaType(String headerValue) {
        String subtype;
        String type;
        MediaType xContentType;
        String[] split;
        String[] typeSubtype;
        if (headerValue != null && (typeSubtype = (split = headerValue.toLowerCase(Locale.ROOT).split(";"))[0].trim().split("/")).length == 2 && (xContentType = (MediaType)this.typeWithSubtypeToMediaType.get((type = typeSubtype[0]) + "/" + (subtype = typeSubtype[1]))) != null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (int i = 1; i < split.length; ++i) {
                String[] keyValueParam = split[i].trim().split("=");
                if (keyValueParam.length != 2 || this.hasSpaces(keyValueParam[0]) || this.hasSpaces(keyValueParam[1])) {
                    return null;
                }
                parameters.put(keyValueParam[0], keyValueParam[1]);
            }
            return new ParsedMediaType(this, xContentType, parameters);
        }
        return null;
    }

    private boolean hasSpaces(String s) {
        return !s.trim().equals(s);
    }

    public static class ParsedMediaType {
        private final Map<String, String> parameters;
        private final T mediaType;
        final /* synthetic */ MediaTypeParser this$0;

        public ParsedMediaType(T mediaType, Map<String, String> parameters) {
            this.this$0 = this$0;
            this.parameters = parameters;
            this.mediaType = mediaType;
        }

        public T getMediaType() {
            return this.mediaType;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

