/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.env;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graylog.shaded.opensearch2.joptsimple.OptionParser;
import org.graylog.shaded.opensearch2.joptsimple.OptionSet;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.OpenSearchNodeCommand;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.set.Sets;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.env.NodeEnvironment;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.MetadataStateFormat;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.PersistedClusterStateService;

public class NodeRepurposeCommand
extends OpenSearchNodeCommand {
    static final String ABORTED_BY_USER_MSG = "aborted by user";
    static final String FAILED_TO_OBTAIN_NODE_LOCK_MSG = "failed to lock node's directory, is OpenSearch still running?";
    static final String NO_CLEANUP = "Node has node.data=true and node.search=true -> no clean up necessary";
    static final String NO_DATA_TO_CLEAN_UP_FOUND = "No data to clean-up found";
    static final String NO_SHARD_DATA_TO_CLEAN_UP_FOUND = "No shard data to clean-up found";
    static final String NO_FILE_CACHE_DATA_TO_CLEAN_UP_FOUND = "No file cache to clean-up found";
    private static final int FILE_CACHE_NODE_PATH_LOCATION = 0;

    public NodeRepurposeCommand() {
        super("Repurpose this node to another cluster-manager/data/search role, cleaning up any excess persisted data");
    }

    void testExecute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        this.execute(terminal, options, env);
    }

    @Override
    protected boolean validateBeforeLock(Terminal terminal, Environment env) {
        Settings settings = env.settings();
        if (DiscoveryNode.isDataNode(settings) && DiscoveryNode.isSearchNode(settings)) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_CLEANUP);
            return false;
        }
        return true;
    }

    @Override
    protected void processNodePaths(Terminal terminal, Path[] dataPaths, int nodeLockId, OptionSet options, Environment env) throws IOException {
        boolean repurposeSearch;
        assert (!DiscoveryNode.isDataNode(env.settings()) || !DiscoveryNode.isSearchNode(env.settings()));
        boolean repurposeData = !DiscoveryNode.isDataNode(env.settings());
        boolean bl = repurposeSearch = !DiscoveryNode.isSearchNode(env.settings());
        if (!DiscoveryNode.isClusterManagerNode(env.settings())) {
            this.processNoClusterManagerRepurposeNode(terminal, dataPaths, env, repurposeData, repurposeSearch);
        } else {
            this.processClusterManagerRepurposeNode(terminal, dataPaths, env, repurposeData, repurposeSearch);
        }
    }

    private void processNoClusterManagerRepurposeNode(Terminal terminal, Path[] dataPaths, Environment env, boolean repurposeData, boolean repurposeSearch) throws IOException {
        NodeEnvironment.NodePath[] nodePaths = this.toNodePaths(dataPaths);
        NodeEnvironment.NodePath fileCacheNodePath = this.toNodePaths(dataPaths)[0];
        PersistedClusterStateService persistedClusterStateService = NodeRepurposeCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Metadata metadata = this.loadClusterState(terminal, env, persistedClusterStateService).metadata();
        Set<Path> indexPaths = Set.of();
        List<Object> shardDataPaths = List.of();
        Set<Path> fileCachePaths = Set.of();
        List<Object> fileCacheDataPaths = List.of();
        terminal.println(Terminal.Verbosity.VERBOSE, "Collecting index metadata paths");
        List<Path> indexMetadataPaths = NodeEnvironment.collectIndexMetadataPaths(nodePaths);
        if (repurposeData) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting shard data paths");
            shardDataPaths = NodeEnvironment.collectShardDataPaths(nodePaths);
            indexPaths = this.uniqueParentPaths(shardDataPaths, indexMetadataPaths);
        }
        if (repurposeSearch) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting file cache data paths");
            fileCacheDataPaths = NodeEnvironment.collectFileCacheDataPath(fileCacheNodePath);
            fileCachePaths = this.uniqueParentPaths(fileCacheDataPaths, indexMetadataPaths);
        }
        if (repurposeData && repurposeSearch && fileCacheDataPaths.isEmpty() && indexPaths.isEmpty() && metadata.indices().isEmpty()) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (repurposeData && !repurposeSearch && indexPaths.isEmpty() && metadata.indices().isEmpty()) {
            terminal.println(Terminal.Verbosity.NORMAL, NO_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (!repurposeData && repurposeSearch && fileCacheDataPaths.isEmpty() && metadata.indices().isEmpty()) {
            terminal.println(NO_FILE_CACHE_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        Set<String> indexUUIDs = Sets.union(this.indexUUIDsFor(fileCachePaths), Sets.union(this.indexUUIDsFor(indexPaths), StreamSupport.stream(metadata.indices().values().spliterator(), false).map(imd -> imd.getIndexUUID()).collect(Collectors.toSet())));
        ArrayList<Path> cleanUpPaths = new ArrayList<Path>(shardDataPaths);
        cleanUpPaths.addAll(fileCacheDataPaths);
        this.outputVerboseInformation(terminal, cleanUpPaths, indexUUIDs, metadata);
        terminal.println(NodeRepurposeCommand.noClusterManagerMessage(indexUUIDs.size(), cleanUpPaths.size(), indexMetadataPaths.size()));
        this.outputHowToSeeVerboseInformation(terminal);
        if (repurposeData && repurposeSearch) {
            terminal.println("Node is being re-purposed as no-cluster-manager, no-data and no-search. Clean-up of index data and file cache will be performed.");
        } else if (repurposeData) {
            terminal.println("Node is being re-purposed as no-cluster-manager and no-data. Clean-up of index data will be performed.");
        } else if (repurposeSearch) {
            terminal.println("Node is being re-purposed as no-cluster-manager and no-search. Clean-up of file cache and corresponding index metadata will be performed.");
        }
        this.confirm(terminal, "Do you want to proceed?");
        MetadataStateFormat.deleteMetaState(dataPaths);
        if (repurposeData) {
            this.removePaths(terminal, indexPaths);
            IOUtils.rm((Path[])Stream.of(dataPaths).map(path -> path.resolve("indices")).toArray(Path[]::new));
        }
        if (repurposeSearch) {
            this.removePaths(terminal, fileCachePaths);
            IOUtils.rm(dataPaths[0].resolve("cache"));
        }
        if (repurposeData && repurposeSearch) {
            terminal.println("Node successfully repurposed to no-cluster-manager, no-data and no-search.");
        } else if (repurposeData) {
            terminal.println("Node successfully repurposed to no-cluster-manager and no-data.");
        } else if (repurposeSearch) {
            terminal.println("Node successfully repurposed to no-cluster-manager and no-search.");
        }
    }

    private void processClusterManagerRepurposeNode(Terminal terminal, Path[] dataPaths, Environment env, boolean repurposeData, boolean repurposeSearch) throws IOException {
        NodeEnvironment.NodePath[] nodePaths = this.toNodePaths(dataPaths);
        NodeEnvironment.NodePath fileCacheNodePath = this.toNodePaths(dataPaths)[0];
        PersistedClusterStateService persistedClusterStateService = NodeRepurposeCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        Metadata metadata = this.loadClusterState(terminal, env, persistedClusterStateService).metadata();
        Set<Path> indexPaths = Set.of();
        List<Object> shardDataPaths = List.of();
        Set<Path> fileCachePaths = Set.of();
        List<Object> fileCacheDataPaths = List.of();
        if (repurposeData) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting shard data paths");
            shardDataPaths = NodeEnvironment.collectShardDataPaths(nodePaths);
            indexPaths = this.uniqueParentPaths(shardDataPaths);
        }
        if (repurposeSearch) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Collecting file cache data paths");
            fileCacheDataPaths = NodeEnvironment.collectFileCacheDataPath(fileCacheNodePath);
            fileCachePaths = this.uniqueParentPaths(fileCacheDataPaths);
        }
        if (repurposeData && repurposeSearch && shardDataPaths.isEmpty() && fileCacheDataPaths.isEmpty()) {
            terminal.println(NO_SHARD_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (repurposeData && !repurposeSearch && shardDataPaths.isEmpty()) {
            terminal.println(NO_SHARD_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        if (!repurposeData && repurposeSearch && fileCacheDataPaths.isEmpty()) {
            terminal.println(NO_FILE_CACHE_DATA_TO_CLEAN_UP_FOUND);
            return;
        }
        Set<String> indexUUIDs = Sets.union(this.indexUUIDsFor(indexPaths), this.indexUUIDsFor(fileCachePaths));
        ArrayList<Object> cleanUpPaths = new ArrayList<Object>(shardDataPaths);
        cleanUpPaths.addAll(fileCacheDataPaths);
        this.outputVerboseInformation(terminal, cleanUpPaths, indexUUIDs, metadata);
        terminal.println(NodeRepurposeCommand.shardMessage(cleanUpPaths.size(), indexUUIDs.size()));
        this.outputHowToSeeVerboseInformation(terminal);
        if (repurposeData && repurposeSearch) {
            terminal.println("Node is being re-purposed as cluster-manager, no-data and no-search. Clean-up of shard data and file cache data will be performed.");
        } else if (repurposeData) {
            terminal.println("Node is being re-purposed as cluster-manager and no-data. Clean-up of shard data will be performed.");
        } else if (repurposeSearch) {
            terminal.println("Node is being re-purposed as cluster-manager and no-search. Clean-up of file cache data will be performed.");
        }
        this.confirm(terminal, "Do you want to proceed?");
        if (repurposeData) {
            this.removePaths(terminal, shardDataPaths);
        }
        if (repurposeSearch) {
            this.removePaths(terminal, fileCacheDataPaths);
        }
        if (repurposeData && repurposeSearch) {
            terminal.println("Node successfully repurposed to cluster-manager, no-data and no-search.");
        } else if (repurposeData) {
            terminal.println("Node successfully repurposed to cluster-manager and no-data.");
        } else if (repurposeSearch) {
            terminal.println("Node successfully repurposed to cluster-manager and no-search.");
        }
    }

    private ClusterState loadClusterState(Terminal terminal, Environment env, PersistedClusterStateService psf) throws IOException {
        terminal.println(Terminal.Verbosity.VERBOSE, "Loading cluster state");
        return NodeRepurposeCommand.clusterState(env, psf.loadBestOnDiskState());
    }

    private void outputVerboseInformation(Terminal terminal, Collection<Path> pathsToCleanup, Set<String> indexUUIDs, Metadata metadata) {
        if (terminal.isPrintable(Terminal.Verbosity.VERBOSE)) {
            terminal.println(Terminal.Verbosity.VERBOSE, "Paths to clean up:");
            pathsToCleanup.forEach(p -> terminal.println(Terminal.Verbosity.VERBOSE, "  " + p.toString()));
            terminal.println(Terminal.Verbosity.VERBOSE, "Indices affected:");
            indexUUIDs.forEach(uuid -> terminal.println(Terminal.Verbosity.VERBOSE, "  " + this.toIndexName((String)uuid, metadata)));
        }
    }

    private void outputHowToSeeVerboseInformation(Terminal terminal) {
        if (!terminal.isPrintable(Terminal.Verbosity.VERBOSE)) {
            terminal.println("Use -v to see list of paths and indices affected");
        }
    }

    private String toIndexName(String uuid, Metadata metadata) {
        if (metadata != null) {
            for (IndexMetadata indexMetadata : metadata.indices().values()) {
                if (!indexMetadata.getIndexUUID().equals(uuid)) continue;
                return indexMetadata.getIndex().getName();
            }
        }
        return "no name for uuid: " + uuid;
    }

    private Set<String> indexUUIDsFor(Set<Path> indexPaths) {
        return indexPaths.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
    }

    static String noClusterManagerMessage(int indexes, int shards, int indexMetadata) {
        return "Found " + indexes + " indices (" + shards + " shards/file cache folders and " + indexMetadata + " index meta data) to clean up";
    }

    static String shardMessage(int shards, int indices) {
        return "Found " + shards + " shards/file cache folders in " + indices + " indices to clean up";
    }

    private void removePaths(Terminal terminal, Collection<Path> paths) {
        terminal.println(Terminal.Verbosity.VERBOSE, "Removing data");
        paths.forEach(this::removePath);
    }

    private void removePath(Path path) {
        try {
            IOUtils.rm(path);
        }
        catch (IOException e) {
            throw new OpenSearchException("Unable to clean up path: " + path + ": " + e.getMessage(), new Object[0]);
        }
    }

    @SafeVarargs
    private final Set<Path> uniqueParentPaths(Collection<Path> ... paths) {
        return Arrays.stream(paths).flatMap(Collection::stream).map(Path::getParent).collect(Collectors.toSet());
    }

    OptionParser getParser() {
        return this.parser;
    }
}

