/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.extensions;

import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionModule;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterSettingsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.SettingsModule;
import org.graylog.shaded.opensearch2.org.opensearch.common.transport.TransportAddress;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.discovery.InitializeExtensionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.discovery.InitializeExtensionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.env.EnvironmentSettingsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.AddSettingsUpdateConsumerRequest;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.AddSettingsUpdateConsumerRequestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.DiscoveryExtensionNode;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.ExtensionDependency;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.ExtensionDependencyResponse;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.ExtensionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.ExtensionsSettings;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.action.ExtensionActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.action.ExtensionActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.action.ExtensionTransportActionsHandler;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.action.RegisterTransportActionsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.action.RemoteExtensionActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.action.TransportActionRequestFromExtension;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.rest.RegisterRestActionsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.rest.RestActionsRequestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.settings.CustomSettingsRequestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.settings.RegisterCustomSettingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ConnectTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class ExtensionsManager {
    public static final String REQUEST_EXTENSION_ACTION_NAME = "internal:discovery/extensions";
    public static final String REQUEST_EXTENSION_CLUSTER_STATE = "internal:discovery/clusterstate";
    public static final String REQUEST_EXTENSION_CLUSTER_SETTINGS = "internal:discovery/clustersettings";
    public static final String REQUEST_EXTENSION_ENVIRONMENT_SETTINGS = "internal:discovery/enviornmentsettings";
    public static final String REQUEST_EXTENSION_ADD_SETTINGS_UPDATE_CONSUMER = "internal:discovery/addsettingsupdateconsumer";
    public static final String REQUEST_EXTENSION_UPDATE_SETTINGS = "internal:discovery/updatesettings";
    public static final String REQUEST_EXTENSION_DEPENDENCY_INFORMATION = "internal:discovery/dependencyinformation";
    public static final String REQUEST_EXTENSION_REGISTER_CUSTOM_SETTINGS = "internal:discovery/registercustomsettings";
    public static final String REQUEST_EXTENSION_REGISTER_REST_ACTIONS = "internal:discovery/registerrestactions";
    public static final String REQUEST_EXTENSION_REGISTER_TRANSPORT_ACTIONS = "internal:discovery/registertransportactions";
    public static final String REQUEST_REST_EXECUTE_ON_EXTENSION_ACTION = "internal:extensions/restexecuteonextensiontaction";
    public static final String REQUEST_EXTENSION_HANDLE_TRANSPORT_ACTION = "internal:extensions/handle-transportaction";
    public static final String REQUEST_EXTENSION_HANDLE_REMOTE_TRANSPORT_ACTION = "internal:extensions/handle-remote-transportaction";
    public static final String TRANSPORT_ACTION_REQUEST_FROM_EXTENSION = "internal:extensions/request-transportaction-from-extension";
    public static final int EXTENSION_REQUEST_WAIT_TIMEOUT = 10;
    private static final Logger logger = LogManager.getLogger(ExtensionsManager.class);
    private ExtensionTransportActionsHandler extensionTransportActionsHandler;
    private Map<String, ExtensionsSettings.Extension> extensionSettingsMap;
    private Map<String, DiscoveryExtensionNode> initializedExtensions;
    private Map<String, DiscoveryExtensionNode> extensionIdMap;
    private RestActionsRequestHandler restActionsRequestHandler;
    private CustomSettingsRequestHandler customSettingsRequestHandler;
    private TransportService transportService;
    private ClusterService clusterService;
    private final Set<Setting<?>> additionalSettings;
    private Settings environmentSettings;
    private AddSettingsUpdateConsumerRequestHandler addSettingsUpdateConsumerRequestHandler;
    private NodeClient client;

    public ExtensionsManager(Set<Setting<?>> additionalSettings) throws IOException {
        logger.info("ExtensionsManager initialized");
        this.initializedExtensions = new HashMap<String, DiscoveryExtensionNode>();
        this.extensionIdMap = new HashMap<String, DiscoveryExtensionNode>();
        this.extensionSettingsMap = new HashMap<String, ExtensionsSettings.Extension>();
        this.transportService = null;
        this.clusterService = null;
        this.additionalSettings = new HashSet();
        if (additionalSettings != null) {
            this.additionalSettings.addAll(additionalSettings);
        }
        this.client = null;
        this.extensionTransportActionsHandler = null;
    }

    public void initializeServicesAndRestHandler(ActionModule actionModule, SettingsModule settingsModule, TransportService transportService, ClusterService clusterService, Settings initialEnvironmentSettings, NodeClient client) {
        this.restActionsRequestHandler = new RestActionsRequestHandler(actionModule.getRestController(), this.extensionIdMap, transportService);
        this.customSettingsRequestHandler = new CustomSettingsRequestHandler(settingsModule);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.environmentSettings = initialEnvironmentSettings;
        this.addSettingsUpdateConsumerRequestHandler = new AddSettingsUpdateConsumerRequestHandler(clusterService, transportService, REQUEST_EXTENSION_UPDATE_SETTINGS);
        this.client = client;
        this.extensionTransportActionsHandler = new ExtensionTransportActionsHandler(this.extensionIdMap, transportService, client, actionModule, this);
        this.registerRequestHandler(actionModule.getDynamicActionRegistry());
    }

    public Optional<DiscoveryExtensionNode> lookupInitializedExtensionById(String extensionId) {
        return Optional.ofNullable(this.initializedExtensions.get(extensionId));
    }

    public Optional<ExtensionsSettings.Extension> lookupExtensionSettingsById(String extensionId) {
        return Optional.ofNullable(this.extensionSettingsMap.get(extensionId));
    }

    public RemoteExtensionActionResponse handleRemoteTransportRequest(ExtensionActionRequest request) throws Exception {
        return this.extensionTransportActionsHandler.sendRemoteTransportRequestToExtension(request);
    }

    public ExtensionActionResponse handleTransportRequest(ExtensionActionRequest request) throws Exception {
        return this.extensionTransportActionsHandler.sendTransportRequestToExtension(request);
    }

    private void registerRequestHandler(ActionModule.DynamicActionRegistry dynamicActionRegistry) {
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_REST_ACTIONS, "generic", false, false, RegisterRestActionsRequest::new, (request, channel, task) -> channel.sendResponse(this.restActionsRequestHandler.handleRegisterRestActionsRequest((RegisterRestActionsRequest)request, dynamicActionRegistry)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_CUSTOM_SETTINGS, "generic", false, false, RegisterCustomSettingsRequest::new, (request, channel, task) -> channel.sendResponse(this.customSettingsRequestHandler.handleRegisterCustomSettingsRequest((RegisterCustomSettingsRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_CLUSTER_STATE, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_CLUSTER_SETTINGS, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_ENVIRONMENT_SETTINGS, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_DEPENDENCY_INFORMATION, "generic", false, false, ExtensionRequest::new, (request, channel, task) -> channel.sendResponse(this.handleExtensionRequest((ExtensionRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_ADD_SETTINGS_UPDATE_CONSUMER, "generic", false, false, AddSettingsUpdateConsumerRequest::new, (request, channel, task) -> channel.sendResponse(this.addSettingsUpdateConsumerRequestHandler.handleAddSettingsUpdateConsumerRequest((AddSettingsUpdateConsumerRequest)request)));
        this.transportService.registerRequestHandler(REQUEST_EXTENSION_REGISTER_TRANSPORT_ACTIONS, "generic", false, false, RegisterTransportActionsRequest::new, (request, channel, task) -> channel.sendResponse(this.extensionTransportActionsHandler.handleRegisterTransportActionsRequest((RegisterTransportActionsRequest)request)));
        this.transportService.registerRequestHandler(TRANSPORT_ACTION_REQUEST_FROM_EXTENSION, "generic", false, false, TransportActionRequestFromExtension::new, (request, channel, task) -> channel.sendResponse(this.extensionTransportActionsHandler.handleTransportActionRequestFromExtension((TransportActionRequestFromExtension)request)));
    }

    public void loadExtension(ExtensionsSettings.Extension extension) throws IOException {
        this.validateExtension(extension);
        DiscoveryExtensionNode discoveryExtensionNode = new DiscoveryExtensionNode(extension.getName(), extension.getUniqueId(), new TransportAddress(InetAddress.getByName(extension.getHostAddress()), Integer.parseInt(extension.getPort())), new HashMap<String, String>(), Version.fromString(extension.getOpensearchVersion()), Version.fromString(extension.getMinimumCompatibleVersion()), extension.getDependencies());
        this.extensionIdMap.put(extension.getUniqueId(), discoveryExtensionNode);
        this.extensionSettingsMap.put(extension.getUniqueId(), extension);
        logger.info("Loaded extension with uniqueId " + extension.getUniqueId() + ": " + extension);
    }

    private void validateField(String fieldName, String value) throws IOException {
        if (Strings.isNullOrEmpty(value)) {
            throw new IOException("Required field [" + fieldName + "] is missing in the request");
        }
    }

    private void validateExtension(ExtensionsSettings.Extension extension) throws IOException {
        this.validateField("extension name", extension.getName());
        this.validateField("extension uniqueId", extension.getUniqueId());
        this.validateField("extension host address", extension.getHostAddress());
        this.validateField("extension port", extension.getPort());
        this.validateField("extension version", extension.getVersion());
        this.validateField("opensearch version", extension.getOpensearchVersion());
        this.validateField("minimum opensearch version", extension.getMinimumCompatibleVersion());
        if (this.extensionIdMap.containsKey(extension.getUniqueId())) {
            throw new IOException("Duplicate uniqueId [" + extension.getUniqueId() + "]. Did not load extension: " + extension);
        }
    }

    public void initialize() {
        for (DiscoveryExtensionNode extension : this.extensionIdMap.values()) {
            this.initializeExtension(extension);
        }
    }

    private void initializeExtension(final DiscoveryExtensionNode extension) {
        final CompletableFuture inProgressFuture = new CompletableFuture();
        final TransportResponseHandler<InitializeExtensionResponse> initializeExtensionResponseHandler = new TransportResponseHandler<InitializeExtensionResponse>(){

            @Override
            public InitializeExtensionResponse read(StreamInput in) throws IOException {
                return new InitializeExtensionResponse(in);
            }

            @Override
            public void handleResponse(InitializeExtensionResponse response) {
                for (DiscoveryExtensionNode extension : ExtensionsManager.this.extensionIdMap.values()) {
                    if (!extension.getName().equals(response.getName())) continue;
                    extension.setImplementedInterfaces(response.getImplementedInterfaces());
                    ExtensionsManager.this.initializedExtensions.put(extension.getId(), extension);
                    logger.info("Initialized extension: " + extension.getName());
                    break;
                }
                inProgressFuture.complete(response);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.error((Message)new ParameterizedMessage("Extension initialization failed", new Object[0]), (Throwable)exp);
                inProgressFuture.completeExceptionally(exp);
            }

            @Override
            public String executor() {
                return "generic";
            }
        };
        logger.info("Sending extension request type: internal:discovery/extensions");
        this.transportService.getThreadPool().generic().execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                ExtensionsManager.this.extensionIdMap.remove(extension.getId());
                if (e.getCause() instanceof ConnectTransportException) {
                    logger.info("No response from extension to request.", (Throwable)e);
                    throw (ConnectTransportException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }

            @Override
            protected void doRun() throws Exception {
                ExtensionsManager.this.transportService.connectToExtensionNode(extension);
                ExtensionsManager.this.transportService.sendRequest(extension, ExtensionsManager.REQUEST_EXTENSION_ACTION_NAME, new InitializeExtensionRequest(ExtensionsManager.this.transportService.getLocalNode(), extension), initializeExtensionResponseHandler);
            }
        });
    }

    TransportResponse handleExtensionRequest(ExtensionRequest extensionRequest) throws Exception {
        switch (extensionRequest.getRequestType()) {
            case REQUEST_EXTENSION_CLUSTER_STATE: {
                return new ClusterStateResponse(this.clusterService.getClusterName(), this.clusterService.state(), false);
            }
            case REQUEST_EXTENSION_CLUSTER_SETTINGS: {
                return new ClusterSettingsResponse(this.clusterService);
            }
            case REQUEST_EXTENSION_ENVIRONMENT_SETTINGS: {
                return new EnvironmentSettingsResponse(this.environmentSettings);
            }
            case REQUEST_EXTENSION_DEPENDENCY_INFORMATION: {
                String uniqueId = extensionRequest.getUniqueId();
                if (uniqueId == null) {
                    return new ExtensionDependencyResponse(this.initializedExtensions.entrySet().stream().map(e -> (DiscoveryExtensionNode)e.getValue()).collect(Collectors.toList()));
                }
                ExtensionDependency matchingId = new ExtensionDependency(uniqueId, Version.CURRENT);
                return new ExtensionDependencyResponse(this.initializedExtensions.entrySet().stream().map(e -> (DiscoveryExtensionNode)e.getValue()).filter(e -> e.dependenciesContain(matchingId)).collect(Collectors.toList()));
            }
        }
        throw new IllegalArgumentException("Handler not present for the provided request");
    }

    static String getRequestExtensionActionName() {
        return REQUEST_EXTENSION_ACTION_NAME;
    }

    static String getRequestExtensionClusterState() {
        return REQUEST_EXTENSION_CLUSTER_STATE;
    }

    static String getRequestExtensionClusterSettings() {
        return REQUEST_EXTENSION_CLUSTER_SETTINGS;
    }

    static Logger getLogger() {
        return logger;
    }

    TransportService getTransportService() {
        return this.transportService;
    }

    ClusterService getClusterService() {
        return this.clusterService;
    }

    Map<String, DiscoveryExtensionNode> getExtensionIdMap() {
        return this.extensionIdMap;
    }

    RestActionsRequestHandler getRestActionsRequestHandler() {
        return this.restActionsRequestHandler;
    }

    void setExtensionIdMap(Map<String, DiscoveryExtensionNode> extensionIdMap) {
        this.extensionIdMap = extensionIdMap;
    }

    void setRestActionsRequestHandler(RestActionsRequestHandler restActionsRequestHandler) {
        this.restActionsRequestHandler = restActionsRequestHandler;
    }

    void setTransportService(TransportService transportService) {
        this.transportService = transportService;
    }

    void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    CustomSettingsRequestHandler getCustomSettingsRequestHandler() {
        return this.customSettingsRequestHandler;
    }

    void setCustomSettingsRequestHandler(CustomSettingsRequestHandler customSettingsRequestHandler) {
        this.customSettingsRequestHandler = customSettingsRequestHandler;
    }

    AddSettingsUpdateConsumerRequestHandler getAddSettingsUpdateConsumerRequestHandler() {
        return this.addSettingsUpdateConsumerRequestHandler;
    }

    void setAddSettingsUpdateConsumerRequestHandler(AddSettingsUpdateConsumerRequestHandler addSettingsUpdateConsumerRequestHandler) {
        this.addSettingsUpdateConsumerRequestHandler = addSettingsUpdateConsumerRequestHandler;
    }

    Settings getEnvironmentSettings() {
        return this.environmentSettings;
    }

    public Set<Setting<?>> getAdditionalSettings() {
        return this.additionalSettings;
    }

    public static enum OpenSearchRequestType {
        REQUEST_OPENSEARCH_NAMED_WRITEABLE_REGISTRY;

    }
}

