/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.extensions.rest;

import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionModule;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.DiscoveryExtensionNode;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.rest.RegisterRestActionsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.extensions.rest.RestSendToExtensionAction;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestController;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class RestActionsRequestHandler {
    private final RestController restController;
    private final Map<String, DiscoveryExtensionNode> extensionIdMap;
    private final TransportService transportService;

    public RestActionsRequestHandler(RestController restController, Map<String, DiscoveryExtensionNode> extensionIdMap, TransportService transportService) {
        this.restController = restController;
        this.extensionIdMap = extensionIdMap;
        this.transportService = transportService;
    }

    public TransportResponse handleRegisterRestActionsRequest(RegisterRestActionsRequest restActionsRequest, ActionModule.DynamicActionRegistry dynamicActionRegistry) throws Exception {
        DiscoveryExtensionNode discoveryExtensionNode = this.extensionIdMap.get(restActionsRequest.getUniqueId());
        RestSendToExtensionAction handler = new RestSendToExtensionAction(restActionsRequest, discoveryExtensionNode, this.transportService, dynamicActionRegistry);
        this.restController.registerHandler(handler);
        return new AcknowledgedResponse(true);
    }
}

