/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.identity.tokens;

import org.graylog.shaded.opensearch2.org.opensearch.identity.tokens.AuthToken;

public class BearerAuthToken
implements AuthToken {
    public final String DELIMITER = "\\.";
    public static final String TOKEN_IDENTIFIER = "Bearer";
    private String header;
    private String payload;
    private String signature;
    private String completeToken;

    public BearerAuthToken(String token) {
        String[] tokenComponents = token.split("\\.");
        if (tokenComponents.length != 3) {
            throw new IllegalArgumentException("Illegally formed bearer authorization token " + token);
        }
        this.completeToken = token;
        this.header = tokenComponents[0];
        this.payload = tokenComponents[1];
        this.signature = tokenComponents[2];
    }

    public String getHeader() {
        return this.header;
    }

    public String getPayload() {
        return this.payload;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getCompleteToken() {
        return this.completeToken;
    }

    public String getTokenIdentifier() {
        return TOKEN_IDENTIFIER;
    }

    public String toString() {
        return "Bearer auth token with header=" + this.header + ", payload=" + this.payload + ", signature=" + this.signature;
    }
}

