/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationState;

public class SegmentReplicationShardStats
implements Writeable,
ToXContentFragment {
    private final String allocationId;
    private final long checkpointsBehindCount;
    private final long bytesBehindCount;
    private final long currentReplicationTimeMillis;
    private final long lastCompletedReplicationTimeMillis;
    @Nullable
    private SegmentReplicationState currentReplicationState;

    public SegmentReplicationShardStats(String allocationId, long checkpointsBehindCount, long bytesBehindCount, long currentReplicationTimeMillis, long lastCompletedReplicationTime) {
        this.allocationId = allocationId;
        this.checkpointsBehindCount = checkpointsBehindCount;
        this.bytesBehindCount = bytesBehindCount;
        this.currentReplicationTimeMillis = currentReplicationTimeMillis;
        this.lastCompletedReplicationTimeMillis = lastCompletedReplicationTime;
    }

    public SegmentReplicationShardStats(StreamInput in) throws IOException {
        this.allocationId = in.readString();
        this.checkpointsBehindCount = in.readVLong();
        this.bytesBehindCount = in.readVLong();
        this.currentReplicationTimeMillis = in.readVLong();
        this.lastCompletedReplicationTimeMillis = in.readVLong();
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public long getCheckpointsBehindCount() {
        return this.checkpointsBehindCount;
    }

    public long getBytesBehindCount() {
        return this.bytesBehindCount;
    }

    public long getCurrentReplicationTimeMillis() {
        return this.currentReplicationTimeMillis;
    }

    public long getLastCompletedReplicationTimeMillis() {
        return this.lastCompletedReplicationTimeMillis;
    }

    public void setCurrentReplicationState(SegmentReplicationState currentReplicationState) {
        this.currentReplicationState = currentReplicationState;
    }

    @Nullable
    public SegmentReplicationState getCurrentReplicationState() {
        return this.currentReplicationState;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("allocation_id", this.allocationId);
        builder.field("checkpoints_behind", this.checkpointsBehindCount);
        builder.field("bytes_behind", new ByteSizeValue(this.bytesBehindCount).toString());
        builder.field("current_replication_time", new TimeValue(this.currentReplicationTimeMillis));
        builder.field("last_completed_replication_time", new TimeValue(this.lastCompletedReplicationTimeMillis));
        if (this.currentReplicationState != null) {
            builder.startObject();
            this.currentReplicationState.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.allocationId);
        out.writeVLong(this.checkpointsBehindCount);
        out.writeVLong(this.bytesBehindCount);
        out.writeVLong(this.currentReplicationTimeMillis);
        out.writeVLong(this.lastCompletedReplicationTimeMillis);
    }

    public String toString() {
        return "SegmentReplicationShardStats{allocationId=" + this.allocationId + ", checkpointsBehindCount=" + this.checkpointsBehindCount + ", bytesBehindCount=" + this.bytesBehindCount + ", currentReplicationTimeMillis=" + this.currentReplicationTimeMillis + ", lastCompletedReplicationTimeMillis=" + this.lastCompletedReplicationTimeMillis + ", currentReplicationState=" + this.currentReplicationState + "}";
    }
}

