/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.codec;

import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene95.Lucene95Codec;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.MapBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.PerFieldMappingPostingFormatCodec;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.customcodecs.ZstdCodec;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.customcodecs.ZstdNoDictCodec;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;

public class CodecService {
    private final Map<String, Codec> codecs;
    public static final String DEFAULT_CODEC = "default";
    public static final String BEST_COMPRESSION_CODEC = "best_compression";
    public static final String LUCENE_DEFAULT_CODEC = "lucene_default";
    public static final String ZSTD_CODEC = "zstd";
    public static final String ZSTD_NO_DICT_CODEC = "zstd_no_dict";

    public CodecService(@Nullable MapperService mapperService, IndexSettings indexSettings, Logger logger) {
        MapBuilder<String, Codec> codecs = MapBuilder.newMapBuilder();
        assert (null != indexSettings);
        int compressionLevel = indexSettings.getValue(EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING);
        if (mapperService == null) {
            codecs.put(DEFAULT_CODEC, new Lucene95Codec());
            codecs.put(BEST_COMPRESSION_CODEC, new Lucene95Codec(Lucene95Codec.Mode.BEST_COMPRESSION));
            codecs.put(ZSTD_CODEC, new ZstdCodec(compressionLevel));
            codecs.put(ZSTD_NO_DICT_CODEC, new ZstdNoDictCodec(compressionLevel));
        } else {
            codecs.put(DEFAULT_CODEC, new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put(BEST_COMPRESSION_CODEC, new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_COMPRESSION, mapperService, logger));
            codecs.put(ZSTD_CODEC, new ZstdCodec(mapperService, logger, compressionLevel));
            codecs.put(ZSTD_NO_DICT_CODEC, new ZstdNoDictCodec(mapperService, logger, compressionLevel));
        }
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName(codec));
        }
        this.codecs = codecs.immutableMap();
    }

    @Deprecated(since="2.9.0", forRemoval=true)
    public CodecService(@Nullable MapperService mapperService, Logger logger) {
        MapBuilder<String, Codec> codecs = MapBuilder.newMapBuilder();
        if (mapperService == null) {
            codecs.put(DEFAULT_CODEC, new Lucene95Codec());
            codecs.put(BEST_COMPRESSION_CODEC, new Lucene95Codec(Lucene95Codec.Mode.BEST_COMPRESSION));
            codecs.put(ZSTD_CODEC, new ZstdCodec());
            codecs.put(ZSTD_NO_DICT_CODEC, new ZstdNoDictCodec());
        } else {
            IndexSettings indexSettings = mapperService.getIndexSettings();
            int compressionLevel = indexSettings == null ? 3 : indexSettings.getValue(EngineConfig.INDEX_CODEC_COMPRESSION_LEVEL_SETTING);
            codecs.put(DEFAULT_CODEC, new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_SPEED, mapperService, logger));
            codecs.put(BEST_COMPRESSION_CODEC, new PerFieldMappingPostingFormatCodec(Lucene95Codec.Mode.BEST_COMPRESSION, mapperService, logger));
            codecs.put(ZSTD_CODEC, new ZstdCodec(mapperService, logger, compressionLevel));
            codecs.put(ZSTD_NO_DICT_CODEC, new ZstdNoDictCodec(mapperService, logger, compressionLevel));
        }
        codecs.put(LUCENE_DEFAULT_CODEC, Codec.getDefault());
        for (String codec : Codec.availableCodecs()) {
            codecs.put(codec, Codec.forName(codec));
        }
        this.codecs = codecs.immutableMap();
    }

    public Codec codec(String name) {
        Codec codec = this.codecs.get(name);
        if (codec == null) {
            throw new IllegalArgumentException("failed to find codec [" + name + "]");
        }
        return codec;
    }

    public String[] availableCodecs() {
        return this.codecs.keySet().toArray(new String[0]);
    }
}

