/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergePolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryCache;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryCachingPolicy;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ReferenceManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Sort;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.similarities.Similarity;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.MemorySizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.codec.CodecService;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Engine;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParsedDocument;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeases;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.InternalTranslogFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogDeletionPolicyFactory;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogFactory;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndexingMemoryController;
import org.graylog.shaded.opensearch2.org.opensearch.indices.breaker.CircuitBreakerService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public final class EngineConfig {
    private final ShardId shardId;
    private final IndexSettings indexSettings;
    private final ByteSizeValue indexingBufferSize;
    private final TranslogDeletionPolicyFactory translogDeletionPolicyFactory;
    private volatile boolean enableGcDeletes = true;
    private final TimeValue flushMergesAfter;
    private final String codecName;
    private final ThreadPool threadPool;
    private final Engine.Warmer warmer;
    private final Store store;
    private final MergePolicy mergePolicy;
    private final Analyzer analyzer;
    private final Similarity similarity;
    private final CodecService codecService;
    private final Engine.EventListener eventListener;
    private final QueryCache queryCache;
    private final QueryCachingPolicy queryCachingPolicy;
    @Nullable
    private final List<ReferenceManager.RefreshListener> externalRefreshListener;
    @Nullable
    private final List<ReferenceManager.RefreshListener> internalRefreshListener;
    @Nullable
    private final Sort indexSort;
    @Nullable
    private final CircuitBreakerService circuitBreakerService;
    private final LongSupplier globalCheckpointSupplier;
    private final Supplier<RetentionLeases> retentionLeasesSupplier;
    private final boolean isReadOnlyReplica;
    private final BooleanSupplier primaryModeSupplier;
    private final Comparator<LeafReader> leafSorter;
    private final LongSupplier primaryTermSupplier;
    private final TombstoneDocSupplier tombstoneDocSupplier;
    public static final Setting<String> INDEX_CODEC_SETTING = new Setting<String>("index.codec", "default", s -> {
        switch (s) {
            case "default": 
            case "best_compression": 
            case "zstd": 
            case "zstd_no_dict": 
            case "lucene_default": {
                return s;
            }
        }
        if (!Codec.availableCodecs().contains(s)) {
            throw new IllegalArgumentException("unknown value for [index.codec] must be one of [default, best_compression, zstd, zstd_no_dict] but was: " + s);
        }
        return s;
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);
    public static final Setting<Integer> INDEX_CODEC_COMPRESSION_LEVEL_SETTING = Setting.intSetting("index.codec.compression_level", 3, 1, 6, Setting.Property.IndexScope);
    public static final Setting<Boolean> INDEX_OPTIMIZE_AUTO_GENERATED_IDS = Setting.boolSetting("index.optimize_auto_generated_id", true, Setting.Property.IndexScope, Setting.Property.Dynamic);
    private final TranslogConfig translogConfig;
    private final TranslogFactory translogFactory;

    public Supplier<RetentionLeases> retentionLeasesSupplier() {
        return this.retentionLeasesSupplier;
    }

    private EngineConfig(Builder builder) {
        if (builder.isReadOnlyReplica && !builder.indexSettings.isSegRepEnabled()) {
            throw new IllegalArgumentException("Shard can only be wired as a read only replica with Segment Replication enabled");
        }
        this.shardId = builder.shardId;
        this.indexSettings = builder.indexSettings;
        this.threadPool = builder.threadPool;
        this.warmer = builder.warmer == null ? a -> {} : builder.warmer;
        this.store = builder.store;
        this.mergePolicy = builder.mergePolicy;
        this.analyzer = builder.analyzer;
        this.similarity = builder.similarity;
        this.codecService = builder.codecService;
        this.eventListener = builder.eventListener;
        this.codecName = builder.indexSettings.getValue(INDEX_CODEC_SETTING);
        String escapeHatchProperty = "opensearch.index.memory.max_index_buffer_size";
        String maxBufferSize = System.getProperty("opensearch.index.memory.max_index_buffer_size");
        this.indexingBufferSize = maxBufferSize != null ? MemorySizeValue.parseBytesSizeValueOrHeapRatio(maxBufferSize, "opensearch.index.memory.max_index_buffer_size") : IndexingMemoryController.INDEX_BUFFER_SIZE_SETTING.get(builder.indexSettings.getNodeSettings());
        this.queryCache = builder.queryCache;
        this.queryCachingPolicy = builder.queryCachingPolicy;
        this.translogConfig = builder.translogConfig;
        this.translogDeletionPolicyFactory = builder.translogDeletionPolicyFactory;
        this.flushMergesAfter = builder.flushMergesAfter;
        this.externalRefreshListener = builder.externalRefreshListener;
        this.internalRefreshListener = builder.internalRefreshListener;
        this.indexSort = builder.indexSort;
        this.circuitBreakerService = builder.circuitBreakerService;
        this.globalCheckpointSupplier = builder.globalCheckpointSupplier;
        this.retentionLeasesSupplier = Objects.requireNonNull(builder.retentionLeasesSupplier);
        this.primaryTermSupplier = builder.primaryTermSupplier;
        this.tombstoneDocSupplier = builder.tombstoneDocSupplier;
        this.isReadOnlyReplica = builder.isReadOnlyReplica;
        this.primaryModeSupplier = builder.primaryModeSupplier;
        this.translogFactory = builder.translogFactory;
        this.leafSorter = builder.leafSorter;
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecService.codec(this.codecName);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public Engine.Warmer getWarmer() {
        return this.warmer;
    }

    public Store getStore() {
        return this.store;
    }

    public LongSupplier getGlobalCheckpointSupplier() {
        return this.globalCheckpointSupplier;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public Engine.EventListener getEventListener() {
        return this.eventListener;
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    public QueryCachingPolicy getQueryCachingPolicy() {
        return this.queryCachingPolicy;
    }

    public TranslogConfig getTranslogConfig() {
        return this.translogConfig;
    }

    public TimeValue getFlushMergesAfter() {
        return this.flushMergesAfter;
    }

    public List<ReferenceManager.RefreshListener> getExternalRefreshListener() {
        return this.externalRefreshListener;
    }

    public List<ReferenceManager.RefreshListener> getInternalRefreshListener() {
        return this.internalRefreshListener;
    }

    public boolean isAutoGeneratedIDsOptimizationEnabled() {
        return this.indexSettings.getValue(INDEX_OPTIMIZE_AUTO_GENERATED_IDS);
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }

    @Nullable
    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    public LongSupplier getPrimaryTermSupplier() {
        return this.primaryTermSupplier;
    }

    public boolean isReadOnlyReplica() {
        return this.indexSettings.isSegRepEnabled() && this.isReadOnlyReplica;
    }

    public BooleanSupplier getPrimaryModeSupplier() {
        return this.primaryModeSupplier;
    }

    public TranslogFactory getTranslogFactory() {
        return this.translogFactory;
    }

    public TombstoneDocSupplier getTombstoneDocSupplier() {
        return this.tombstoneDocSupplier;
    }

    public TranslogDeletionPolicyFactory getCustomTranslogDeletionPolicyFactory() {
        return this.translogDeletionPolicyFactory;
    }

    public Comparator<LeafReader> getLeafSorter() {
        return this.leafSorter;
    }

    public static class Builder {
        private ShardId shardId;
        private ThreadPool threadPool;
        private IndexSettings indexSettings;
        private Engine.Warmer warmer;
        private Store store;
        private MergePolicy mergePolicy;
        private Analyzer analyzer;
        private Similarity similarity;
        private CodecService codecService;
        private Engine.EventListener eventListener;
        private QueryCache queryCache;
        private QueryCachingPolicy queryCachingPolicy;
        private TranslogConfig translogConfig;
        private TimeValue flushMergesAfter;
        private List<ReferenceManager.RefreshListener> externalRefreshListener;
        private List<ReferenceManager.RefreshListener> internalRefreshListener;
        private Sort indexSort;
        private CircuitBreakerService circuitBreakerService;
        private LongSupplier globalCheckpointSupplier;
        private Supplier<RetentionLeases> retentionLeasesSupplier;
        private LongSupplier primaryTermSupplier;
        private TombstoneDocSupplier tombstoneDocSupplier;
        private TranslogDeletionPolicyFactory translogDeletionPolicyFactory;
        private boolean isReadOnlyReplica;
        private BooleanSupplier primaryModeSupplier;
        private TranslogFactory translogFactory = new InternalTranslogFactory();
        Comparator<LeafReader> leafSorter;

        public Builder shardId(ShardId shardId) {
            this.shardId = shardId;
            return this;
        }

        public Builder threadPool(ThreadPool threadPool) {
            this.threadPool = threadPool;
            return this;
        }

        public Builder indexSettings(IndexSettings indexSettings) {
            this.indexSettings = indexSettings;
            return this;
        }

        public Builder warmer(Engine.Warmer warmer) {
            this.warmer = warmer;
            return this;
        }

        public Builder store(Store store) {
            this.store = store;
            return this;
        }

        public Builder mergePolicy(MergePolicy mergePolicy) {
            this.mergePolicy = mergePolicy;
            return this;
        }

        public Builder analyzer(Analyzer analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public Builder similarity(Similarity similarity) {
            this.similarity = similarity;
            return this;
        }

        public Builder codecService(CodecService codecService) {
            this.codecService = codecService;
            return this;
        }

        public Builder eventListener(Engine.EventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }

        public Builder queryCache(QueryCache queryCache) {
            this.queryCache = queryCache;
            return this;
        }

        public Builder queryCachingPolicy(QueryCachingPolicy queryCachingPolicy) {
            this.queryCachingPolicy = queryCachingPolicy;
            return this;
        }

        public Builder translogConfig(TranslogConfig translogConfig) {
            this.translogConfig = translogConfig;
            return this;
        }

        public Builder flushMergesAfter(TimeValue flushMergesAfter) {
            this.flushMergesAfter = flushMergesAfter;
            return this;
        }

        public Builder externalRefreshListener(List<ReferenceManager.RefreshListener> externalRefreshListener) {
            this.externalRefreshListener = externalRefreshListener;
            return this;
        }

        public Builder internalRefreshListener(List<ReferenceManager.RefreshListener> internalRefreshListener) {
            this.internalRefreshListener = internalRefreshListener;
            return this;
        }

        public Builder indexSort(Sort indexSort) {
            this.indexSort = indexSort;
            return this;
        }

        public Builder circuitBreakerService(CircuitBreakerService circuitBreakerService) {
            this.circuitBreakerService = circuitBreakerService;
            return this;
        }

        public Builder globalCheckpointSupplier(LongSupplier globalCheckpointSupplier) {
            this.globalCheckpointSupplier = globalCheckpointSupplier;
            return this;
        }

        public Builder retentionLeasesSupplier(Supplier<RetentionLeases> retentionLeasesSupplier) {
            this.retentionLeasesSupplier = retentionLeasesSupplier;
            return this;
        }

        public Builder primaryTermSupplier(LongSupplier primaryTermSupplier) {
            this.primaryTermSupplier = primaryTermSupplier;
            return this;
        }

        public Builder tombstoneDocSupplier(TombstoneDocSupplier tombstoneDocSupplier) {
            this.tombstoneDocSupplier = tombstoneDocSupplier;
            return this;
        }

        public Builder translogDeletionPolicyFactory(TranslogDeletionPolicyFactory translogDeletionPolicyFactory) {
            this.translogDeletionPolicyFactory = translogDeletionPolicyFactory;
            return this;
        }

        public Builder readOnlyReplica(boolean isReadOnlyReplica) {
            this.isReadOnlyReplica = isReadOnlyReplica;
            return this;
        }

        public Builder primaryModeSupplier(BooleanSupplier primaryModeSupplier) {
            this.primaryModeSupplier = primaryModeSupplier;
            return this;
        }

        public Builder translogFactory(TranslogFactory translogFactory) {
            this.translogFactory = translogFactory;
            return this;
        }

        public Builder leafSorter(Comparator<LeafReader> leafSorter) {
            this.leafSorter = leafSorter;
            return this;
        }

        public EngineConfig build() {
            return new EngineConfig(this);
        }
    }

    public static interface TombstoneDocSupplier {
        public ParsedDocument newDeleteTombstoneDoc(String var1);

        public ParsedDocument newNoopTombstoneDoc(String var1);
    }
}

