/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexCommit;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ReferenceManager;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.GatedCloseable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ReleasableLock;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.io.IOUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.CompletionStatsCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Engine;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineConfig;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineCreationFailureException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.LifecycleAware;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.NRTReplicationReaderManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.RefreshFailedEngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.SafeCommitInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Segment;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.LocalCheckpointTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.SeqNoStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.SequenceNumbers;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogDeletionPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogException;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.TranslogStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.WriteOnlyTranslogManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.listener.TranslogEventListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.completion.CompletionStats;

public class NRTReplicationEngine
extends Engine
implements LifecycleAware {
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final NRTReplicationReaderManager readerManager;
    private final CompletionStatsCache completionStatsCache;
    private final LocalCheckpointTracker localCheckpointTracker;
    private final WriteOnlyTranslogManager translogManager;
    private volatile long lastReceivedGen = -1L;
    private static final int SI_COUNTER_INCREMENT = 10;

    public NRTReplicationEngine(EngineConfig engineConfig) {
        super(engineConfig);
        this.store.incRef();
        NRTReplicationReaderManager readerManager = null;
        WriteOnlyTranslogManager translogManagerRef = null;
        try {
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            readerManager = this.buildReaderManager();
            SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommittedSegmentInfos.getUserData().entrySet());
            this.localCheckpointTracker = new LocalCheckpointTracker(commitInfo.maxSeqNo, commitInfo.localCheckpoint);
            this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
            this.readerManager = readerManager;
            this.readerManager.addListener(this.completionStatsCache);
            for (ReferenceManager.RefreshListener listener : engineConfig.getExternalRefreshListener()) {
                this.readerManager.addListener(listener);
            }
            for (ReferenceManager.RefreshListener listener : engineConfig.getInternalRefreshListener()) {
                this.readerManager.addListener(listener);
            }
            Map<String, String> userData = this.store.readLastCommittedSegmentsInfo().getUserData();
            String translogUUID = Objects.requireNonNull(userData.get("translog_uuid"));
            this.translogManager = translogManagerRef = new WriteOnlyTranslogManager(engineConfig.getTranslogConfig(), engineConfig.getPrimaryTermSupplier(), engineConfig.getGlobalCheckpointSupplier(), this.getTranslogDeletionPolicy(engineConfig), this.shardId, this.readLock, this::getLocalCheckpointTracker, translogUUID, new TranslogEventListener(){

                @Override
                public void onFailure(String reason, Exception ex) {
                    NRTReplicationEngine.this.failEngine(reason, ex);
                }

                @Override
                public void onAfterTranslogSync() {
                    try {
                        NRTReplicationEngine.this.translogManager.trimUnreferencedReaders();
                    }
                    catch (IOException ex) {
                        throw new TranslogException(NRTReplicationEngine.this.shardId, "failed to trim unreferenced translog readers", ex);
                    }
                }
            }, this, engineConfig.getTranslogFactory(), engineConfig.getPrimaryModeSupplier());
        }
        catch (IOException e) {
            Closeable[] closeableArray = new Closeable[3];
            closeableArray[0] = this.store::decRef;
            closeableArray[1] = readerManager;
            closeableArray[2] = translogManagerRef;
            IOUtils.closeWhileHandlingException(closeableArray);
            throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
        }
    }

    private NRTReplicationReaderManager buildReaderManager() throws IOException {
        return new NRTReplicationReaderManager(OpenSearchDirectoryReader.wrap(this.getDirectoryReader(), this.shardId), this.store::incRefFileDeleter, this.store::decRefFileDeleter);
    }

    public TranslogManager translogManager() {
        return this.translogManager;
    }

    public synchronized void updateSegments(SegmentInfos infos) throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            long maxSeqNo = Long.parseLong(infos.userData.get("max_seq_no"));
            long incomingGeneration = infos.getGeneration();
            this.readerManager.updateSegments(infos);
            if (incomingGeneration != this.lastReceivedGen) {
                this.commitSegmentInfos();
                this.translogManager.getDeletionPolicy().setLocalCheckpointOfSafeCommit(maxSeqNo);
                this.translogManager.rollTranslogGeneration();
            }
            this.lastReceivedGen = incomingGeneration;
            this.localCheckpointTracker.fastForwardProcessedSeqNo(maxSeqNo);
        }
    }

    private void commitSegmentInfos(SegmentInfos infos) throws IOException {
        this.store.commitSegmentInfos(infos, this.localCheckpointTracker.getMaxSeqNo(), this.localCheckpointTracker.getProcessedCheckpoint());
        this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
        this.translogManager.syncTranslog();
    }

    protected void commitSegmentInfos() throws IOException {
        this.commitSegmentInfos(this.getLatestSegmentInfos());
    }

    @Override
    public String getHistoryUUID() {
        return this.loadHistoryUUID(this.lastCommittedSegmentInfos.userData);
    }

    @Override
    public long getWritingBytes() {
        return 0L;
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    @Override
    public boolean isThrottled() {
        return false;
    }

    @Override
    public void trimOperationsFromTranslog(long belowTerm, long aboveSeqNo) throws EngineException {
        this.translogManager.trimOperationsFromTranslog(belowTerm, aboveSeqNo);
    }

    @Override
    public Engine.IndexResult index(Engine.Index index) throws IOException {
        this.ensureOpen();
        Engine.IndexResult indexResult = new Engine.IndexResult(index.version(), index.primaryTerm(), index.seqNo(), false);
        Translog.Location location = this.translogManager.add(new Translog.Index(index, indexResult));
        indexResult.setTranslogLocation(location);
        indexResult.setTook(System.nanoTime() - index.startTime());
        indexResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(index.seqNo());
        return indexResult;
    }

    @Override
    public Engine.DeleteResult delete(Engine.Delete delete) throws IOException {
        this.ensureOpen();
        Engine.DeleteResult deleteResult = new Engine.DeleteResult(delete.version(), delete.primaryTerm(), delete.seqNo(), true);
        Translog.Location location = this.translogManager.add(new Translog.Delete(delete, deleteResult));
        deleteResult.setTranslogLocation(location);
        deleteResult.setTook(System.nanoTime() - delete.startTime());
        deleteResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(delete.seqNo());
        return deleteResult;
    }

    @Override
    public Engine.NoOpResult noOp(Engine.NoOp noOp) throws IOException {
        this.ensureOpen();
        Engine.NoOpResult noOpResult = new Engine.NoOpResult(noOp.primaryTerm(), noOp.seqNo());
        Translog.Location location = this.translogManager.add(new Translog.NoOp(noOp.seqNo(), noOp.primaryTerm(), noOp.reason()));
        noOpResult.setTranslogLocation(location);
        noOpResult.setTook(System.nanoTime() - noOp.startTime());
        noOpResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(noOp.seqNo());
        return noOpResult;
    }

    @Override
    public Engine.GetResult get(Engine.Get get, BiFunction<String, Engine.SearcherScope, Engine.Searcher> searcherFactory) throws EngineException {
        return this.getFromSearcher(get, searcherFactory, Engine.SearcherScope.EXTERNAL);
    }

    @Override
    protected ReferenceManager<OpenSearchDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return this.readerManager;
    }

    @Override
    public boolean refreshNeeded() {
        return false;
    }

    @Override
    public boolean isTranslogSyncNeeded() {
        return this.translogManager.getTranslog().syncNeeded();
    }

    @Override
    public boolean ensureTranslogSynced(Stream<Translog.Location> locations) throws IOException {
        return this.translogManager.ensureTranslogSynced(locations);
    }

    @Override
    public void syncTranslog() throws IOException {
        this.translogManager.syncTranslog();
    }

    @Override
    public Closeable acquireHistoryRetentionLock() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Translog.Snapshot newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accurateCount) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    @Deprecated
    public Translog.Snapshot newChangesSnapshotFromTranslogFile(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        return this.getTranslog().newSnapshot(fromSeqNo, toSeqNo, requiredFullRange);
    }

    @Override
    public int countNumberOfHistoryOperations(String source, long fromSeqNo, long toSeqNumber) throws IOException {
        return 0;
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, long startingSeqNo) {
        return false;
    }

    @Override
    public long getMinRetainedSeqNo() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public TranslogStats getTranslogStats() {
        return this.translogManager.getTranslog().stats();
    }

    @Override
    public Translog.Location getTranslogLastWriteLocation() {
        return this.translogManager.getTranslog().getLastWriteLocation();
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.localCheckpointTracker.getPersistedCheckpoint();
    }

    public long getProcessedLocalCheckpoint() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return this.localCheckpointTracker.getStats(globalCheckpoint);
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.translogManager.getLastSyncedGlobalCheckpoint();
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        return Arrays.asList(this.getSegmentInfo(this.getLatestSegmentInfos(), verbose));
    }

    @Override
    public void refresh(String source) throws EngineException {
        this.maybeRefresh(source);
    }

    @Override
    public boolean maybeRefresh(String source) throws EngineException {
        this.ensureOpen();
        try {
            return this.readerManager.maybeRefresh();
        }
        catch (IOException e) {
            try {
                this.failEngine("refresh failed source[" + source + "]", e);
            }
            catch (Exception inner) {
                e.addSuppressed(inner);
            }
            throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
        }
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    @Override
    public void flush(boolean force, boolean waitIfOngoing) throws EngineException {
    }

    @Override
    public void trimUnreferencedTranslogFiles() throws EngineException {
        this.translogManager.trimUnreferencedTranslogFiles();
    }

    @Override
    public boolean shouldRollTranslogGeneration() {
        return this.translogManager.getTranslog().shouldRollGeneration();
    }

    @Override
    public void rollTranslogGeneration() throws EngineException {
        this.translogManager.rollTranslogGeneration();
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments, String forceMergeUUID) throws EngineException, IOException {
    }

    @Override
    public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        try {
            IndexCommit indexCommit = Lucene.getIndexCommit(this.lastCommittedSegmentInfos, this.store.directory());
            return new GatedCloseable<IndexCommit>(indexCommit, () -> {});
        }
        catch (IOException e) {
            throw new EngineException(this.shardId, "Unable to build latest IndexCommit", e, new Object[0]);
        }
    }

    @Override
    public GatedCloseable<IndexCommit> acquireSafeIndexCommit() throws EngineException {
        return this.acquireLastIndexCommit(false);
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return new SafeCommitInfo(this.localCheckpointTracker.getProcessedCheckpoint(), this.lastCommittedSegmentInfos.totalMaxDoc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                SegmentInfos latestSegmentInfos = this.getLatestSegmentInfos();
                latestSegmentInfos.counter += 10L;
                latestSegmentInfos.changed();
                this.commitSegmentInfos(latestSegmentInfos);
                Closeable[] closeableArray = new Closeable[3];
                closeableArray[0] = this.readerManager;
                closeableArray[1] = this.translogManager;
                closeableArray[2] = this.store::decRef;
                IOUtils.close(closeableArray);
            }
            catch (Exception e) {
                this.logger.warn("failed to close engine", (Throwable)e);
            }
            finally {
                this.logger.debug("engine closed [{}]", (Object)reason);
                closedLatch.countDown();
            }
        }
    }

    @Override
    public void activateThrottling() {
    }

    @Override
    public void deactivateThrottling() {
    }

    @Override
    public int restoreLocalHistoryFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner) throws IOException {
        return 0;
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) throws IOException {
        return 0;
    }

    @Override
    public Engine recoverFromTranslog(Engine.TranslogRecoveryRunner translogRecoveryRunner, long recoverUpToSeqNo) throws IOException {
        throw new UnsupportedOperationException("Read only replicas do not have an IndexWriter and cannot recover from a translog.");
    }

    @Override
    public void skipTranslogRecovery() {
    }

    @Override
    public void maybePruneDeletes() {
    }

    @Override
    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.localCheckpointTracker.getMaxSeqNo();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
    }

    public Translog getTranslog() {
        return this.translogManager.getTranslog();
    }

    @Override
    public void onSettingsChanged(TimeValue translogRetentionAge, ByteSizeValue translogRetentionSize, long softDeletesRetentionOps) {
        TranslogDeletionPolicy translogDeletionPolicy = this.translogManager.getDeletionPolicy();
        translogDeletionPolicy.setRetentionAgeInMillis(translogRetentionAge.millis());
        translogDeletionPolicy.setRetentionSizeInBytes(translogRetentionSize.getBytes());
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected SegmentInfos getLatestSegmentInfos() {
        return this.readerManager.getSegmentInfos();
    }

    protected LocalCheckpointTracker getLocalCheckpointTracker() {
        return this.localCheckpointTracker;
    }

    private DirectoryReader getDirectoryReader() throws IOException {
        return new SoftDeletesDirectoryReaderWrapper(DirectoryReader.open(this.store.directory()), "__soft_deletes");
    }
}

