/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.fielddata;

import java.io.IOException;
import java.util.function.LongUnaryOperator;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortField;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortedNumericSelector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.SortedNumericSortField;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.DateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.AbstractSortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.LeafNumericFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator.IntValuesComparatorSource;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.fieldcomparator.UnsignedLongValuesComparatorSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.MultiValueMode;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.BucketedSort;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;

public abstract class IndexNumericFieldData
implements IndexFieldData<LeafNumericFieldData> {
    public abstract NumericType getNumericType();

    public final SortField sortField(NumericType targetNumericType, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        IndexFieldData.XFieldComparatorSource source = this.comparatorSource(targetNumericType, missingValue, sortMode, nested);
        if (this.sortRequiresCustomComparator() || nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || targetNumericType != this.getNumericType()) {
            return new SortField(this.getFieldName(), source, reverse);
        }
        SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
        SortedNumericSortField sortField = new SortedNumericSortField(this.getFieldName(), this.getNumericType().sortFieldType, reverse, selectorType);
        ((SortField)sortField).setMissingValue(source.missingObject(missingValue, reverse));
        return sortField;
    }

    protected abstract boolean sortRequiresCustomComparator();

    @Override
    public final SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        return this.sortField(this.getNumericType(), missingValue, sortMode, nested, reverse);
    }

    public final BucketedSort newBucketedSort(NumericType targetNumericType, BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.comparatorSource(targetNumericType, missingValue, sortMode, nested).newBucketedSort(bigArrays, sortOrder, format, bucketSize, extra);
    }

    @Override
    public final BucketedSort newBucketedSort(BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.newBucketedSort(this.getNumericType(), bigArrays, missingValue, sortMode, nested, sortOrder, format, bucketSize, extra);
    }

    private IndexFieldData.XFieldComparatorSource comparatorSource(NumericType targetNumericType, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        IndexFieldData.XFieldComparatorSource source;
        switch (targetNumericType) {
            case HALF_FLOAT: 
            case FLOAT: {
                source = new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            case DOUBLE: {
                source = new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            case UNSIGNED_LONG: {
                source = new UnsignedLongValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            case DATE: {
                source = this.dateComparatorSource(missingValue, sortMode, nested);
                break;
            }
            case DATE_NANOSECONDS: {
                source = this.dateNanosComparatorSource(missingValue, sortMode, nested);
                break;
            }
            case LONG: {
                source = new LongValuesComparatorSource(this, missingValue, sortMode, nested);
                break;
            }
            default: {
                assert (!targetNumericType.isFloatingPoint());
                source = new IntValuesComparatorSource(this, missingValue, sortMode, nested);
            }
        }
        if (targetNumericType != this.getNumericType()) {
            source.disableSkipping();
        }
        return source;
    }

    protected IndexFieldData.XFieldComparatorSource dateComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    protected IndexFieldData.XFieldComparatorSource dateNanosComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> IndexNumericFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds));
    }

    protected static SortedNumericDocValues convertNumeric(final SortedNumericDocValues values, final LongUnaryOperator converter) {
        return new AbstractSortedNumericDocValues(){

            @Override
            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            @Override
            public long nextValue() throws IOException {
                return converter.applyAsLong(values.nextValue());
            }

            @Override
            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public int nextDoc() throws IOException {
                return values.nextDoc();
            }
        };
    }

    public static enum NumericType {
        BOOLEAN(false, SortField.Type.INT, CoreValuesSourceType.BOOLEAN),
        BYTE(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        SHORT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        INT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        DATE(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        DATE_NANOSECONDS(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        HALF_FLOAT(true, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        FLOAT(true, SortField.Type.FLOAT, CoreValuesSourceType.NUMERIC),
        DOUBLE(true, SortField.Type.DOUBLE, CoreValuesSourceType.NUMERIC),
        UNSIGNED_LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC);

        private final boolean floatingPoint;
        private final ValuesSourceType valuesSourceType;
        private final SortField.Type sortFieldType;

        private NumericType(boolean floatingPoint, SortField.Type sortFieldType, ValuesSourceType valuesSourceType) {
            this.floatingPoint = floatingPoint;
            this.sortFieldType = sortFieldType;
            this.valuesSourceType = valuesSourceType;
        }

        public final boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public final ValuesSourceType getValuesSourceType() {
            return this.valuesSourceType;
        }
    }
}

