/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.InvertableType;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.StoredField;
import org.graylog.shaded.opensearch2.org.apache.lucene.document.StoredValue;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.BytesStreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.CollectionUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.IndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.fielddata.plain.BytesBinaryIndexFieldData;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.CustomDocValuesField;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.FieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.Mapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParametrizedFieldMapper;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ParseContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.SourceValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ValueFetcher;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.graylog.shaded.opensearch2.org.opensearch.search.lookup.SearchLookup;

public class BinaryFieldMapper
extends ParametrizedFieldMapper {
    public static final String CONTENT_TYPE = "binary";
    public static final ParametrizedFieldMapper.TypeParser PARSER = new ParametrizedFieldMapper.TypeParser((n, c) -> new Builder((String)n));
    private final boolean stored;
    private final boolean hasDocValues;

    private static BinaryFieldMapper toType(FieldMapper in) {
        return (BinaryFieldMapper)in;
    }

    protected BinaryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.stored = builder.stored.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!this.stored && !this.hasDocValues) {
            return;
        }
        byte[] value = context.parseExternalValue(byte[].class);
        if (value == null) {
            if (context.parser().currentToken() == XContentParser.Token.VALUE_NULL) {
                return;
            }
            value = context.parser().binaryValue();
        }
        if (value == null) {
            return;
        }
        if (this.stored) {
            context.doc().add(new StoredField(this.fieldType().name(), value));
        }
        if (this.hasDocValues) {
            CustomBinaryDocValuesField field = (CustomBinaryDocValuesField)context.doc().getByKey(this.fieldType().name());
            if (field == null) {
                field = new CustomBinaryDocValuesField(this.fieldType().name(), value);
                context.doc().addWithKey(this.fieldType().name(), field);
            } else {
                field.add(value);
            }
        } else {
            this.createFieldNamesField(context);
        }
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName()).init(this);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends ParametrizedFieldMapper.Builder {
        private final ParametrizedFieldMapper.Parameter<Boolean> stored = ParametrizedFieldMapper.Parameter.storeParam(m -> BinaryFieldMapper.toType((FieldMapper)m).stored, false);
        private final ParametrizedFieldMapper.Parameter<Boolean> hasDocValues = ParametrizedFieldMapper.Parameter.docValuesParam(m -> BinaryFieldMapper.toType((FieldMapper)m).hasDocValues, false);
        private final ParametrizedFieldMapper.Parameter<Map<String, String>> meta = ParametrizedFieldMapper.Parameter.metaParam();

        public Builder(String name) {
            this(name, false);
        }

        public Builder(String name, boolean hasDocValues) {
            super(name);
            this.hasDocValues.setValue(hasDocValues);
        }

        @Override
        public List<ParametrizedFieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.meta, this.stored, this.hasDocValues);
        }

        @Override
        public BinaryFieldMapper build(Mapper.BuilderContext context) {
            return new BinaryFieldMapper(this.name, new BinaryFieldType(this.buildFullName(context), this.stored.getValue(), this.hasDocValues.getValue(), this.meta.getValue()), this.multiFieldsBuilder.build(this, context), this.copyTo.build(), this);
        }
    }

    public static class CustomBinaryDocValuesField
    extends CustomDocValuesField {
        private final ArrayList<byte[]> bytesList = new ArrayList();

        public CustomBinaryDocValuesField(String name, byte[] bytes) {
            super(name);
            this.add(bytes);
        }

        public void add(byte[] bytes) {
            this.bytesList.add(bytes);
        }

        @Override
        public BytesRef binaryValue() {
            CollectionUtils.sortAndDedup(this.bytesList, Arrays::compareUnsigned);
            int size = this.bytesList.stream().map(b -> ((byte[])b).length).reduce(0, Integer::sum);
            int length = this.bytesList.size();
            BytesStreamOutput out = new BytesStreamOutput(size + (length + 1) * 5);
            try {
                out.writeVInt(length);
                for (byte[] value : this.bytesList) {
                    int valueLength = value.length;
                    out.writeVInt(valueLength);
                    out.writeBytes(value, 0, valueLength);
                }
                BytesRef bytesRef = out.bytes().toBytesRef();
                out.close();
                return bytesRef;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new OpenSearchException("Failed to get binary value", (Throwable)e, new Object[0]);
                }
            }
        }

        @Override
        public StoredValue storedValue() {
            return null;
        }

        @Override
        public InvertableType invertableType() {
            return InvertableType.BINARY;
        }
    }

    public static final class BinaryFieldType
    extends MappedFieldType {
        private BinaryFieldType(String name, boolean isStored, boolean hasDocValues, Map<String, String> meta) {
            super(name, false, isStored, hasDocValues, TextSearchInfo.NONE, meta);
        }

        public BinaryFieldType(String name) {
            this(name, false, true, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return BinaryFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
            return SourceValueFetcher.identity(this.name(), context, format);
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.BINARY;
        }

        @Override
        public BytesReference valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesReference bytes = value instanceof BytesRef ? new BytesArray((BytesRef)value) : (value instanceof BytesReference ? (BytesReference)value : (value instanceof byte[] ? new BytesArray((byte[])value) : new BytesArray(Base64.getDecoder().decode(value.toString()))));
            return bytes;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new BytesBinaryIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Binary fields do not support searching", new Object[0]);
        }
    }
}

