/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;

public abstract class BaseTermQueryBuilder<QB extends BaseTermQueryBuilder<QB>>
extends AbstractQueryBuilder<QB> {
    public static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    protected final String fieldName;
    protected final Object value;

    public BaseTermQueryBuilder(String fieldName, String value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, int value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, long value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, float value) {
        this(fieldName, Float.valueOf(value));
    }

    public BaseTermQueryBuilder(String fieldName, double value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, boolean value) {
        this(fieldName, (Object)value);
    }

    public BaseTermQueryBuilder(String fieldName, Object value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = BaseTermQueryBuilder.maybeConvertToBytesRef(value);
    }

    protected BaseTermQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.value);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return BaseTermQueryBuilder.maybeConvertToString(this.value);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.startObject(this.fieldName);
        builder.field(VALUE_FIELD.getPreferredName(), BaseTermQueryBuilder.maybeConvertToString(this.value));
        this.addExtraXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    protected void addExtraXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value);
    }

    @Override
    protected boolean doEquals(QB other) {
        return Objects.equals(this.fieldName, ((BaseTermQueryBuilder)other).fieldName) && Objects.equals(this.value, ((BaseTermQueryBuilder)other).value);
    }
}

