/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPoint;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.Queries;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;

public class DistanceFeatureQueryBuilder
extends AbstractQueryBuilder<DistanceFeatureQueryBuilder> {
    public static final String NAME = "distance_feature";
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField ORIGIN_FIELD = new ParseField("origin", new String[0]);
    private static final ParseField PIVOT_FIELD = new ParseField("pivot", new String[0]);
    private final String field;
    private final Origin origin;
    private final String pivot;
    private static final ConstructingObjectParser<DistanceFeatureQueryBuilder, Void> PARSER = new ConstructingObjectParser("distance_feature", false, args -> new DistanceFeatureQueryBuilder((String)args[0], (Origin)args[1], (String)args[2]));

    public DistanceFeatureQueryBuilder(String field, Origin origin, String pivot) {
        this.field = Objects.requireNonNull(field);
        this.origin = Objects.requireNonNull(origin);
        this.pivot = Objects.requireNonNull(pivot);
    }

    public static DistanceFeatureQueryBuilder fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(ORIGIN_FIELD.getPreferredName(), this.origin.origin);
        builder.field(PIVOT_FIELD.getPreferredName(), this.pivot);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public DistanceFeatureQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.origin = new Origin(in);
        this.pivot = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        this.origin.writeTo(out);
        out.writeString(this.pivot);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            return Queries.newMatchNoDocsQuery("Can't run [distance_feature] query on unmapped fields!");
        }
        return fieldType.distanceFeatureQuery(this.origin.origin(), this.pivot, 1.0f, context);
    }

    String fieldName() {
        return this.field;
    }

    Origin origin() {
        return this.origin;
    }

    String pivot() {
        return this.pivot;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.field, this.origin, this.pivot);
    }

    @Override
    protected boolean doEquals(DistanceFeatureQueryBuilder other) {
        return this.field.equals(other.field) && Objects.equals(this.origin, other.origin) && this.pivot.equals(other.pivot);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), x$0 -> Origin.originFromXContent(x$0), ORIGIN_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_STRING_OR_NUMBER);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PIVOT_FIELD);
        DistanceFeatureQueryBuilder.declareStandardFields(PARSER);
    }

    public static class Origin {
        private final Object origin;

        public Origin(Long origin) {
            this.origin = Objects.requireNonNull(origin);
        }

        public Origin(String origin) {
            this.origin = Objects.requireNonNull(origin);
        }

        public Origin(GeoPoint origin) {
            this.origin = Objects.requireNonNull(origin);
        }

        private static Origin originFromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                return new Origin(parser.longValue());
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                return new Origin(parser.text());
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                return new Origin(GeoUtils.parseGeoPoint(parser));
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                return new Origin(GeoUtils.parseGeoPoint(parser));
            }
            throw new ParsingException(parser.getTokenLocation(), "Illegal type while parsing [origin]! Must be [number] or [string] for date and date_nanos fields; or [string], [array], [object] for geo_point fields!", new Object[0]);
        }

        private Origin(StreamInput in) throws IOException {
            this.origin = in.readGenericValue();
        }

        private void writeTo(StreamOutput out) throws IOException {
            out.writeGenericValue(this.origin);
        }

        Object origin() {
            return this.origin;
        }

        public final boolean equals(Object other) {
            if (!(other instanceof Origin)) {
                return false;
            }
            Object otherOrigin = ((Origin)other).origin();
            return this.origin().equals(otherOrigin);
        }

        public int hashCode() {
            return Objects.hash(this.origin);
        }

        public String toString() {
            return this.origin.toString();
        }
    }
}

