/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.queries.intervals.IntervalQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.IntervalsSourceProvider;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;

public class IntervalQueryBuilder
extends AbstractQueryBuilder<IntervalQueryBuilder> {
    public static final String NAME = "intervals";
    private final String field;
    private final IntervalsSourceProvider sourceProvider;

    public IntervalQueryBuilder(String field, IntervalsSourceProvider sourceProvider) {
        this.field = field;
        this.sourceProvider = sourceProvider;
    }

    public IntervalQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.field = in.readString();
        this.sourceProvider = in.readNamedWriteable(IntervalsSourceProvider.class);
    }

    public String getField() {
        return this.field;
    }

    public IntervalsSourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.field);
        out.writeNamedWriteable(this.sourceProvider);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(this.field);
        builder.startObject();
        this.sourceProvider.toXContent(builder, params);
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static IntervalQueryBuilder fromXContent(XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + parser.currentToken() + "]", new Object[0]);
        }
        String field = parser.currentName();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [START_OBJECT] but got [" + parser.currentToken() + "]", new Object[0]);
        }
        String name = null;
        float boost = 1.0f;
        IntervalsSourceProvider provider = null;
        String providerName = null;
        block8: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [FIELD_NAME] but got [" + parser.currentToken() + "]", new Object[0]);
            }
            switch (parser.currentName()) {
                case "_name": {
                    parser.nextToken();
                    name = parser.text();
                    continue block8;
                }
                case "boost": {
                    parser.nextToken();
                    boost = parser.floatValue();
                    continue block8;
                }
            }
            if (providerName != null) {
                throw new ParsingException(parser.getTokenLocation(), "Only one interval rule can be specified, found [" + providerName + "] and [" + parser.currentName() + "]", new Object[0]);
            }
            providerName = parser.currentName();
            provider = IntervalsSourceProvider.fromXContent(parser);
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "Expected [END_OBJECT] but got [" + parser.currentToken() + "]", new Object[0]);
        }
        if (provider == null) {
            throw new ParsingException(parser.getTokenLocation(), "Missing intervals from interval query definition", new Object[0]);
        }
        IntervalQueryBuilder builder = new IntervalQueryBuilder(field, provider);
        builder.queryName(name);
        builder.boost(boost);
        return builder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            return new MatchNoDocsQuery();
        }
        HashSet<String> maskedFields = new HashSet<String>();
        this.sourceProvider.extractFields(maskedFields);
        for (String maskedField : maskedFields) {
            MappedFieldType ft = context.fieldMapper(maskedField);
            if (ft != null) continue;
            return new MatchNoDocsQuery();
        }
        return new IntervalQuery(this.field, this.sourceProvider.getSource(context, fieldType));
    }

    @Override
    protected boolean doEquals(IntervalQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.sourceProvider, other.sourceProvider);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.field, this.sourceProvider);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

