/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.Queries;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.Fuzziness;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.Operator;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.support.QueryParsers;
import org.graylog.shaded.opensearch2.org.opensearch.index.search.MatchQuery;

public class MatchBoolPrefixQueryBuilder
extends AbstractQueryBuilder<MatchBoolPrefixQueryBuilder> {
    public static final String NAME = "match_bool_prefix";
    private static final Operator DEFAULT_OPERATOR = Operator.OR;
    private final String fieldName;
    private final Object value;
    private String analyzer;
    private Operator operator = DEFAULT_OPERATOR;
    private String minimumShouldMatch;
    private Fuzziness fuzziness;
    private int prefixLength = 0;
    private int maxExpansions = 50;
    private boolean fuzzyTranspositions = true;
    private String fuzzyRewrite;

    public MatchBoolPrefixQueryBuilder(String fieldName, Object value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("[match_bool_prefix] requires fieldName");
        }
        if (value == null) {
            throw new IllegalArgumentException("[match_bool_prefix] requires query value");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public MatchBoolPrefixQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readGenericValue();
        this.analyzer = in.readOptionalString();
        this.operator = Operator.readFromStream(in);
        this.minimumShouldMatch = in.readOptionalString();
        this.fuzziness = in.readOptionalWriteable(Fuzziness::new);
        this.prefixLength = in.readVInt();
        this.maxExpansions = in.readVInt();
        this.fuzzyTranspositions = in.readBoolean();
        this.fuzzyRewrite = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.value);
        out.writeOptionalString(this.analyzer);
        this.operator.writeTo(out);
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalWriteable(this.fuzziness);
        out.writeVInt(this.prefixLength);
        out.writeVInt(this.maxExpansions);
        out.writeBoolean(this.fuzzyTranspositions);
        out.writeOptionalString(this.fuzzyRewrite);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return this.value;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public MatchBoolPrefixQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public MatchBoolPrefixQueryBuilder operator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("[match_bool_prefix] requires operator to be non-null");
        }
        this.operator = operator;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public MatchBoolPrefixQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Deprecated
    public MatchBoolPrefixQueryBuilder fuzziness(Object fuzziness) {
        this.fuzziness = Fuzziness.build(fuzziness);
        return this;
    }

    public MatchBoolPrefixQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public MatchBoolPrefixQueryBuilder prefixLength(int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("[match_bool_prefix] requires prefix length to be non-negative.");
        }
        this.prefixLength = prefixLength;
        return this;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public MatchBoolPrefixQueryBuilder maxExpansions(int maxExpansions) {
        if (maxExpansions <= 0) {
            throw new IllegalArgumentException("[match_bool_prefix] requires maxExpansions to be positive.");
        }
        this.maxExpansions = maxExpansions;
        return this;
    }

    public int maxExpansions() {
        return this.maxExpansions;
    }

    public MatchBoolPrefixQueryBuilder fuzzyTranspositions(boolean fuzzyTranspositions) {
        this.fuzzyTranspositions = fuzzyTranspositions;
        return this;
    }

    public boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    public MatchBoolPrefixQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(MatchQueryBuilder.QUERY_FIELD.getPreferredName(), this.value);
        if (this.analyzer != null) {
            builder.field(MatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(MatchQueryBuilder.OPERATOR_FIELD.getPreferredName(), this.operator.toString());
        if (this.minimumShouldMatch != null) {
            builder.field(MatchQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.fuzziness != null) {
            this.fuzziness.toXContent(builder, params);
        }
        builder.field(MatchQueryBuilder.PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
        builder.field(MatchQueryBuilder.MAX_EXPANSIONS_FIELD.getPreferredName(), this.maxExpansions);
        builder.field(MatchQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), this.fuzzyTranspositions);
        if (this.fuzzyRewrite != null) {
            builder.field(MatchQueryBuilder.FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static MatchBoolPrefixQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String analyzer = null;
        Operator operator = DEFAULT_OPERATOR;
        String minimumShouldMatch = null;
        Fuzziness fuzziness = null;
        int prefixLength = 0;
        int maxExpansion = 50;
        boolean fuzzyTranspositions = true;
        String fuzzyRewrite = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                MatchBoolPrefixQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (MatchQueryBuilder.QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            value = parser.objectText();
                            continue;
                        }
                        if (MatchQueryBuilder.ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            analyzer = parser.text();
                            continue;
                        }
                        if (MatchQueryBuilder.OPERATOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            operator = Operator.fromString(parser.text());
                            continue;
                        }
                        if (MatchQueryBuilder.MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            minimumShouldMatch = parser.textOrNull();
                            continue;
                        }
                        if (Fuzziness.FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            fuzziness = Fuzziness.parse(parser);
                            continue;
                        }
                        if (MatchQueryBuilder.PREFIX_LENGTH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            prefixLength = parser.intValue();
                            continue;
                        }
                        if (MatchQueryBuilder.MAX_EXPANSIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            maxExpansion = parser.intValue();
                            continue;
                        }
                        if (MatchQueryBuilder.FUZZY_TRANSPOSITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            fuzzyTranspositions = parser.booleanValue();
                            continue;
                        }
                        if (MatchQueryBuilder.FUZZY_REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            fuzzyRewrite = parser.textOrNull();
                            continue;
                        }
                        if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            boost = parser.floatValue();
                            continue;
                        }
                        if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            queryName = parser.text();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[match_bool_prefix] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[match_bool_prefix] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            MatchBoolPrefixQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = parser.objectText();
        }
        MatchBoolPrefixQueryBuilder queryBuilder = ((MatchBoolPrefixQueryBuilder)((MatchBoolPrefixQueryBuilder)new MatchBoolPrefixQueryBuilder(fieldName, value).analyzer(analyzer).operator(operator).minimumShouldMatch(minimumShouldMatch).boost(boost)).queryName(queryName)).fuzziness(fuzziness).prefixLength(prefixLength).maxExpansions(maxExpansion).fuzzyTranspositions(fuzzyTranspositions).fuzzyRewrite(fuzzyRewrite);
        return queryBuilder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.analyzer != null && context.getIndexAnalyzers().get(this.analyzer) == null) {
            throw new QueryShardException(context, "[match_bool_prefix] analyzer [" + this.analyzer + "] not found", new Object[0]);
        }
        MatchQuery matchQuery = new MatchQuery(context);
        if (this.analyzer != null) {
            matchQuery.setAnalyzer(this.analyzer);
        }
        matchQuery.setOccur(this.operator.toBooleanClauseOccur());
        matchQuery.setFuzziness(this.fuzziness);
        matchQuery.setFuzzyPrefixLength(this.prefixLength);
        matchQuery.setMaxExpansions(this.maxExpansions);
        matchQuery.setTranspositions(this.fuzzyTranspositions);
        matchQuery.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(this.fuzzyRewrite, null, LoggingDeprecationHandler.INSTANCE));
        Query query = matchQuery.parse(MatchQuery.Type.BOOLEAN_PREFIX, this.fieldName, this.value);
        return Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch);
    }

    @Override
    protected boolean doEquals(MatchBoolPrefixQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.operator, other.operator) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.maxExpansions, other.maxExpansions) && Objects.equals(this.fuzzyTranspositions, other.fuzzyTranspositions) && Objects.equals(this.fuzzyRewrite, other.fuzzyRewrite);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.analyzer, this.operator, this.minimumShouldMatch, this.fuzziness, this.prefixLength, this.maxExpansions, this.fuzzyTranspositions, this.fuzzyRewrite);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

