/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardException;
import org.graylog.shaded.opensearch2.org.opensearch.index.search.MatchQuery;

public class MatchPhraseQueryBuilder
extends AbstractQueryBuilder<MatchPhraseQueryBuilder> {
    public static final String NAME = "match_phrase";
    public static final ParseField SLOP_FIELD = new ParseField("slop", new String[0]);
    public static final ParseField ZERO_TERMS_QUERY_FIELD = new ParseField("zero_terms_query", new String[0]);
    private final String fieldName;
    private final Object value;
    private String analyzer;
    private int slop = 0;
    private MatchQuery.ZeroTermsQuery zeroTermsQuery = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;

    public MatchPhraseQueryBuilder(String fieldName, Object value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("[match_phrase] requires fieldName");
        }
        if (value == null) {
            throw new IllegalArgumentException("[match_phrase] requires query value");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public MatchPhraseQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readGenericValue();
        this.slop = in.readVInt();
        this.zeroTermsQuery = MatchQuery.ZeroTermsQuery.readFromStream(in);
        this.analyzer = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.value);
        out.writeVInt(this.slop);
        this.zeroTermsQuery.writeTo(out);
        out.writeOptionalString(this.analyzer);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return this.value;
    }

    public MatchPhraseQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public MatchPhraseQueryBuilder slop(int slop) {
        if (slop < 0) {
            throw new IllegalArgumentException("No negative slop allowed.");
        }
        this.slop = slop;
        return this;
    }

    public int slop() {
        return this.slop;
    }

    public MatchPhraseQueryBuilder zeroTermsQuery(MatchQuery.ZeroTermsQuery zeroTermsQuery) {
        if (zeroTermsQuery == null) {
            throw new IllegalArgumentException("[match_phrase] requires zeroTermsQuery to be non-null");
        }
        this.zeroTermsQuery = zeroTermsQuery;
        return this;
    }

    public MatchQuery.ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(MatchQueryBuilder.QUERY_FIELD.getPreferredName(), this.value);
        if (this.analyzer != null) {
            builder.field(MatchQueryBuilder.ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(SLOP_FIELD.getPreferredName(), this.slop);
        builder.field(ZERO_TERMS_QUERY_FIELD.getPreferredName(), this.zeroTermsQuery.toString());
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.analyzer != null && context.getIndexAnalyzers().get(this.analyzer) == null) {
            throw new QueryShardException(context, "[match_phrase] analyzer [" + this.analyzer + "] not found", new Object[0]);
        }
        MatchQuery matchQuery = new MatchQuery(context);
        if (this.analyzer != null) {
            matchQuery.setAnalyzer(this.analyzer);
        }
        matchQuery.setPhraseSlop(this.slop);
        matchQuery.setZeroTermsQuery(this.zeroTermsQuery);
        return matchQuery.parse(MatchQuery.Type.PHRASE, this.fieldName, this.value);
    }

    @Override
    protected boolean doEquals(MatchPhraseQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.slop, other.slop) && Objects.equals(this.zeroTermsQuery, other.zeroTermsQuery);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.analyzer, this.slop);
    }

    public static MatchPhraseQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String analyzer = null;
        int slop = 0;
        MatchQuery.ZeroTermsQuery zeroTermsQuery = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                MatchPhraseQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (MatchQueryBuilder.QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            value = parser.objectText();
                            continue;
                        }
                        if (MatchQueryBuilder.ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            analyzer = parser.text();
                            continue;
                        }
                        if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            boost = parser.floatValue();
                            continue;
                        }
                        if (SLOP_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            slop = parser.intValue();
                            continue;
                        }
                        if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            queryName = parser.text();
                            continue;
                        }
                        if (ZERO_TERMS_QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            String zeroTermsValue = parser.text();
                            if ("none".equalsIgnoreCase(zeroTermsValue)) {
                                zeroTermsQuery = MatchQuery.ZeroTermsQuery.NONE;
                                continue;
                            }
                            if ("all".equalsIgnoreCase(zeroTermsValue)) {
                                zeroTermsQuery = MatchQuery.ZeroTermsQuery.ALL;
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "Unsupported zero_terms_query value [" + zeroTermsValue + "]", new Object[0]);
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[match_phrase] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[match_phrase] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            MatchPhraseQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = parser.objectText();
        }
        MatchPhraseQueryBuilder matchQuery = new MatchPhraseQueryBuilder(fieldName, value);
        matchQuery.analyzer(analyzer);
        matchQuery.slop(slop);
        matchQuery.zeroTermsQuery(zeroTermsQuery);
        matchQuery.queryName(queryName);
        matchQuery.boost(boost);
        return matchQuery;
    }
}

