/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchAllDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MatchNoDocsQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.MultiTermQuery;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.ConstantFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MappedFieldType;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchNoneQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MultiTermQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryRewriteContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryShardContext;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.support.QueryParsers;

public class WildcardQueryBuilder
extends AbstractQueryBuilder<WildcardQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "wildcard";
    private static final ParseField WILDCARD_FIELD = new ParseField("wildcard", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private final String fieldName;
    private final String value;
    private String rewrite;
    public static final boolean DEFAULT_CASE_INSENSITIVITY = false;
    private static final ParseField CASE_INSENSITIVE_FIELD = new ParseField("case_insensitive", new String[0]);
    private boolean caseInsensitive = false;

    public WildcardQueryBuilder(String fieldName, String value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public WildcardQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readString();
        this.rewrite = in.readOptionalString();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_10_0)) {
            this.caseInsensitive = in.readBoolean();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(this.value);
        out.writeOptionalString(this.rewrite);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_10_0)) {
            out.writeBoolean(this.caseInsensitive);
        }
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String value() {
        return this.value;
    }

    public WildcardQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public String rewrite() {
        return this.rewrite;
    }

    public WildcardQueryBuilder caseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(WILDCARD_FIELD.getPreferredName(), this.value);
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        if (this.caseInsensitive) {
            builder.field(CASE_INSENSITIVE_FIELD.getPreferredName(), this.caseInsensitive);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static WildcardQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String rewrite = null;
        String value = null;
        float boost = 1.0f;
        boolean caseInsensitive = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                WildcardQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (WILDCARD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = parser.text();
                        continue;
                    }
                    if (VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        rewrite = parser.textOrNull();
                        continue;
                    }
                    if (CASE_INSENSITIVE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        caseInsensitive = parser.booleanValue();
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[wildcard] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            WildcardQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = parser.text();
        }
        return ((WildcardQueryBuilder)((WildcardQueryBuilder)new WildcardQueryBuilder(fieldName, value).rewrite(rewrite).boost(boost)).queryName(queryName)).caseInsensitive(caseInsensitive);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryShardContext context = queryRewriteContext.convertToShardContext();
        if (context != null) {
            MappedFieldType fieldType = context.fieldMapper(this.fieldName);
            if (fieldType == null) {
                return new MatchNoneQueryBuilder();
            }
            if (fieldType instanceof ConstantFieldType) {
                Query query = fieldType.wildcardQuery(this.value, null, this.caseInsensitive, context);
                if (query instanceof MatchAllDocsQuery) {
                    return new MatchAllQueryBuilder();
                }
                if (query instanceof MatchNoDocsQuery) {
                    return new MatchNoneQueryBuilder();
                }
                assert (false) : "Constant fields must produce match-all or match-none queries, got " + query;
            }
        }
        return super.doRewrite(queryRewriteContext);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType == null) {
            throw new IllegalStateException("Rewrite first");
        }
        MultiTermQuery.RewriteMethod method = QueryParsers.parseRewriteMethod(this.rewrite, null, LoggingDeprecationHandler.INSTANCE);
        return fieldType.wildcardQuery(this.value, method, this.caseInsensitive, context);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.rewrite, this.caseInsensitive);
    }

    @Override
    protected boolean doEquals(WildcardQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.rewrite, other.rewrite) && Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }
}

