/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.function.Functions;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.DecayFunction;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.DecayFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.DecayFunctionParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.ScoreFunctionParser;

public class LinearDecayFunctionBuilder
extends DecayFunctionBuilder<LinearDecayFunctionBuilder> {
    public static final String NAME = "linear";
    public static final ScoreFunctionParser<LinearDecayFunctionBuilder> PARSER = new DecayFunctionParser<LinearDecayFunctionBuilder>(LinearDecayFunctionBuilder::new);
    public static final DecayFunction LINEAR_DECAY_FUNCTION = new LinearDecayScoreFunction();

    public LinearDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset) {
        super(fieldName, origin, scale, offset);
    }

    public LinearDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, @Nullable String functionName) {
        super(fieldName, origin, scale, offset, functionName);
    }

    public LinearDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, double decay) {
        super(fieldName, origin, scale, offset, decay);
    }

    public LinearDecayFunctionBuilder(String fieldName, Object origin, Object scale, Object offset, double decay, @Nullable String functionName) {
        super(fieldName, origin, scale, offset, decay, functionName);
    }

    LinearDecayFunctionBuilder(String fieldName, BytesReference functionBytes) {
        super(fieldName, functionBytes);
    }

    public LinearDecayFunctionBuilder(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DecayFunction getDecayFunction() {
        return LINEAR_DECAY_FUNCTION;
    }

    private static final class LinearDecayScoreFunction
    implements DecayFunction {
        private LinearDecayScoreFunction() {
        }

        @Override
        public double evaluate(double value, double scale) {
            return Math.max(0.0, (scale - value) / scale);
        }

        @Override
        public Explanation explainFunction(String valueExpl, double value, double scale, @Nullable String functionName) {
            return Explanation.match((Number)Float.valueOf((float)this.evaluate(value, scale)), "max(0.0, ((" + scale + " - " + valueExpl + ")/" + scale + Functions.nameOrEmptyArg(functionName) + ")", new Explanation[0]);
        }

        @Override
        public double processScale(double scale, double decay) {
            return scale / (1.0 - decay);
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            if (super.equals(obj)) {
                return true;
            }
            return obj != null && this.getClass() != obj.getClass();
        }
    }
}

