/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.rankeval;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.EvalQueryQuality;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.EvaluationMetric;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.MetricDetail;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.RatedDocument;
import org.graylog.shaded.opensearch2.org.opensearch.index.rankeval.RatedSearchHit;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHit;

public class RecallAtK
implements EvaluationMetric {
    public static final String NAME = "recall";
    private static final int DEFAULT_RELEVANT_RATING_THRESHOLD = 1;
    private static final int DEFAULT_K = 10;
    private static final ParseField RELEVANT_RATING_THRESHOLD_FIELD = new ParseField("relevant_rating_threshold", new String[0]);
    private static final ParseField K_FIELD = new ParseField("k", new String[0]);
    private final int relevantRatingThreshold;
    private final int k;
    private static final ConstructingObjectParser<RecallAtK, Void> PARSER = new ConstructingObjectParser("recall", args -> {
        Integer relevantRatingThreshold = (Integer)args[0];
        Integer k = (Integer)args[1];
        return new RecallAtK(relevantRatingThreshold == null ? 1 : relevantRatingThreshold, k == null ? 10 : k);
    });

    public RecallAtK(int relevantRatingThreshold, int k) {
        if (relevantRatingThreshold < 0) {
            throw new IllegalArgumentException("Relevant rating threshold for precision must be positive integer.");
        }
        if (k <= 0) {
            throw new IllegalArgumentException("Window size k must be positive.");
        }
        this.relevantRatingThreshold = relevantRatingThreshold;
        this.k = k;
    }

    public RecallAtK() {
        this(1, 10);
    }

    RecallAtK(StreamInput in) throws IOException {
        this(in.readVInt(), in.readVInt());
    }

    public static RecallAtK fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.getRelevantRatingThreshold());
        out.writeVInt(this.getK());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(RELEVANT_RATING_THRESHOLD_FIELD.getPreferredName(), this.getRelevantRatingThreshold());
        builder.field(K_FIELD.getPreferredName(), this.getK());
        builder.endObject();
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public int getRelevantRatingThreshold() {
        return this.relevantRatingThreshold;
    }

    public int getK() {
        return this.k;
    }

    @Override
    public OptionalInt forcedSearchSize() {
        return OptionalInt.of(this.getK());
    }

    private boolean isRelevant(int rating) {
        return rating >= this.getRelevantRatingThreshold();
    }

    @Override
    public EvalQueryQuality evaluate(String taskId, SearchHit[] hits, List<RatedDocument> ratedDocs) {
        List<RatedSearchHit> ratedSearchHits = EvaluationMetric.joinHitsWithRatings(hits, ratedDocs);
        int relevantRetrieved = 0;
        for (RatedSearchHit ratedSearchHit : ratedSearchHits) {
            OptionalInt rating = ratedSearchHit.getRating();
            if (!rating.isPresent() || !this.isRelevant(rating.getAsInt())) continue;
            ++relevantRetrieved;
        }
        int relevant = 0;
        for (RatedDocument rd : ratedDocs) {
            if (!this.isRelevant(rd.getRating())) continue;
            ++relevant;
        }
        double d = 0.0;
        if (relevant > 0) {
            d = (double)relevantRetrieved / (double)relevant;
        }
        EvalQueryQuality evalQueryQuality = new EvalQueryQuality(taskId, d);
        evalQueryQuality.setMetricDetails(new Detail(relevantRetrieved, relevant));
        evalQueryQuality.addHitsAndRatings(ratedSearchHits);
        return evalQueryQuality;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RecallAtK other = (RecallAtK)obj;
        return Objects.equals(this.relevantRatingThreshold, other.relevantRatingThreshold) && Objects.equals(this.k, other.k);
    }

    public final int hashCode() {
        return Objects.hash(this.relevantRatingThreshold, this.k);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RELEVANT_RATING_THRESHOLD_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), K_FIELD);
    }

    public static final class Detail
    implements MetricDetail {
        private static final ParseField RELEVANT_DOCS_RETRIEVED_FIELD = new ParseField("relevant_docs_retrieved", new String[0]);
        private static final ParseField RELEVANT_DOCS_FIELD = new ParseField("relevant_docs", new String[0]);
        private long relevantRetrieved;
        private long relevant;
        private static final ConstructingObjectParser<Detail, Void> PARSER = new ConstructingObjectParser("recall", true, args -> new Detail(((Integer)args[0]).intValue(), ((Integer)args[1]).intValue()));

        Detail(long relevantRetrieved, long relevant) {
            this.relevantRetrieved = relevantRetrieved;
            this.relevant = relevant;
        }

        Detail(StreamInput in) throws IOException {
            this.relevantRetrieved = in.readVLong();
            this.relevant = in.readVLong();
        }

        public static Detail fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.relevantRetrieved);
            out.writeVLong(this.relevant);
        }

        @Override
        public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(RELEVANT_DOCS_RETRIEVED_FIELD.getPreferredName(), this.relevantRetrieved);
            builder.field(RELEVANT_DOCS_FIELD.getPreferredName(), this.relevant);
            return builder;
        }

        @Override
        public String getWriteableName() {
            return RecallAtK.NAME;
        }

        public long getRelevantRetrieved() {
            return this.relevantRetrieved;
        }

        public long getRelevant() {
            return this.relevant;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Detail other = (Detail)obj;
            return Objects.equals(this.relevantRetrieved, other.relevantRetrieved) && Objects.equals(this.relevant, other.relevant);
        }

        public int hashCode() {
            return Objects.hash(this.relevantRetrieved, this.relevant);
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), RELEVANT_DOCS_RETRIEVED_FIELD);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), RELEVANT_DOCS_FIELD);
        }
    }
}

