/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.reindex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BackoffPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.ClearScrollRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.ClearScrollResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchScrollRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.ShardSearchFailure;
import org.graylog.shaded.opensearch2.org.opensearch.client.ParentTaskAssigningClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.document.DocumentField;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.CollectionUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.index.reindex.RejectAwareActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.reindex.ScrollableHitSource;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHit;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class ClientScrollableHitSource
extends ScrollableHitSource {
    private final ParentTaskAssigningClient client;
    private final SearchRequest firstSearchRequest;

    public ClientScrollableHitSource(Logger logger, BackoffPolicy backoffPolicy, ThreadPool threadPool, Runnable countSearchRetry, Consumer<ScrollableHitSource.AsyncResponse> onResponse, Consumer<Exception> fail, ParentTaskAssigningClient client, SearchRequest firstSearchRequest) {
        super(logger, backoffPolicy, threadPool, countSearchRetry, onResponse, fail);
        this.client = client;
        this.firstSearchRequest = firstSearchRequest;
        firstSearchRequest.allowPartialSearchResults(false);
    }

    @Override
    public void doStart(RejectAwareActionListener<ScrollableHitSource.Response> searchListener) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("executing initial scroll against {}", (Object)(CollectionUtils.isEmpty(this.firstSearchRequest.indices()) ? "all indices" : this.firstSearchRequest.indices()));
        }
        this.client.search(this.firstSearchRequest, this.wrapListener(searchListener));
    }

    @Override
    protected void doStartNextScroll(String scrollId, TimeValue extraKeepAlive, RejectAwareActionListener<ScrollableHitSource.Response> searchListener) {
        SearchScrollRequest request = new SearchScrollRequest();
        request.scrollId(scrollId).scroll(TimeValue.timeValueNanos(this.firstSearchRequest.scroll().keepAlive().nanos() + extraKeepAlive.nanos()));
        this.client.searchScroll(request, this.wrapListener(searchListener));
    }

    private ActionListener<SearchResponse> wrapListener(final RejectAwareActionListener<ScrollableHitSource.Response> searchListener) {
        return new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse searchResponse) {
                searchListener.onResponse(ClientScrollableHitSource.this.wrapSearchResponse(searchResponse));
            }

            @Override
            public void onFailure(Exception e) {
                if (ExceptionsHelper.unwrap(e, OpenSearchRejectedExecutionException.class) != null) {
                    searchListener.onRejection(e);
                } else {
                    searchListener.onFailure(e);
                }
            }
        };
    }

    @Override
    public void clearScroll(final String scrollId, final Runnable onCompletion) {
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        this.client.unwrap().clearScroll(clearScrollRequest, new ActionListener<ClearScrollResponse>(){

            @Override
            public void onResponse(ClearScrollResponse response) {
                ClientScrollableHitSource.this.logger.debug("Freed [{}] contexts", (Object)response.getNumFreed());
                onCompletion.run();
            }

            @Override
            public void onFailure(Exception e) {
                ClientScrollableHitSource.this.logger.warn(() -> new ParameterizedMessage("Failed to clear scroll [{}]", (Object)scrollId), (Throwable)e);
                onCompletion.run();
            }
        });
    }

    @Override
    protected void cleanup(Runnable onCompletion) {
        onCompletion.run();
    }

    private ScrollableHitSource.Response wrapSearchResponse(SearchResponse response) {
        List hits;
        List<ScrollableHitSource.SearchFailure> failures;
        if (response.getShardFailures() == null) {
            failures = Collections.emptyList();
        } else {
            failures = new ArrayList(response.getShardFailures().length);
            for (ShardSearchFailure failure : response.getShardFailures()) {
                String nodeId = failure.shard() == null ? null : failure.shard().getNodeId();
                failures.add(new ScrollableHitSource.SearchFailure(failure.getCause(), failure.index(), failure.shardId(), nodeId));
            }
        }
        if (response.getHits().getHits() == null || response.getHits().getHits().length == 0) {
            hits = Collections.emptyList();
        } else {
            hits = new ArrayList(response.getHits().getHits().length);
            for (SearchHit hit : response.getHits().getHits()) {
                hits.add(new ClientHit(hit));
            }
            hits = Collections.unmodifiableList(hits);
        }
        long total = response.getHits().getTotalHits().value;
        return new ScrollableHitSource.Response(response.isTimedOut(), failures, total, hits, response.getScrollId());
    }

    private static class ClientHit
    implements ScrollableHitSource.Hit {
        private final SearchHit delegate;
        private final BytesReference source;

        ClientHit(SearchHit delegate) {
            this.delegate = delegate;
            this.source = delegate.hasSource() ? delegate.getSourceRef() : null;
        }

        @Override
        public String getIndex() {
            return this.delegate.getIndex();
        }

        @Override
        public String getId() {
            return this.delegate.getId();
        }

        @Override
        public BytesReference getSource() {
            return this.source;
        }

        @Override
        public XContentType getXContentType() {
            return XContentHelper.xContentType(this.source);
        }

        @Override
        public long getVersion() {
            return this.delegate.getVersion();
        }

        @Override
        public long getSeqNo() {
            return this.delegate.getSeqNo();
        }

        @Override
        public long getPrimaryTerm() {
            return this.delegate.getPrimaryTerm();
        }

        @Override
        public String getRouting() {
            return (String)this.fieldValue("_routing");
        }

        private <T> T fieldValue(String fieldName) {
            DocumentField field = this.delegate.field(fieldName);
            return field == null ? null : (T)field.getValue();
        }
    }
}

