/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.reindex;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.json.JsonXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilders;

public class RemoteInfo
implements Writeable,
ToXContentObject {
    public static final TimeValue DEFAULT_SOCKET_TIMEOUT = TimeValue.timeValueSeconds(30L);
    public static final TimeValue DEFAULT_CONNECT_TIMEOUT = TimeValue.timeValueSeconds(30L);
    public static final XContent QUERY_CONTENT_TYPE = JsonXContent.jsonXContent;
    private final String scheme;
    private final String host;
    private final int port;
    private final String pathPrefix;
    private final BytesReference query;
    private final String username;
    private final String password;
    private final Map<String, String> headers;
    private final TimeValue socketTimeout;
    private final TimeValue connectTimeout;

    public RemoteInfo(String scheme, String host, int port, String pathPrefix, BytesReference query, String username, String password, Map<String, String> headers, TimeValue socketTimeout, TimeValue connectTimeout) {
        assert (RemoteInfo.isQueryJson(query)) : "Query does not appear to be JSON";
        this.scheme = Objects.requireNonNull(scheme, "[scheme] must be specified to reindex from a remote cluster");
        this.host = Objects.requireNonNull(host, "[host] must be specified to reindex from a remote cluster");
        this.port = port;
        this.pathPrefix = pathPrefix;
        this.query = Objects.requireNonNull(query, "[query] must be specified to reindex from a remote cluster");
        this.username = username;
        this.password = password;
        this.headers = Collections.unmodifiableMap(Objects.requireNonNull(headers, "[headers] is required"));
        this.socketTimeout = Objects.requireNonNull(socketTimeout, "[socketTimeout] must be specified");
        this.connectTimeout = Objects.requireNonNull(connectTimeout, "[connectTimeout] must be specified");
    }

    public RemoteInfo(StreamInput in) throws IOException {
        this.scheme = in.readString();
        this.host = in.readString();
        this.port = in.readVInt();
        this.query = in.readBytesReference();
        this.username = in.readOptionalString();
        this.password = in.readOptionalString();
        int headersLength = in.readVInt();
        HashMap<String, String> headers = new HashMap<String, String>(headersLength);
        for (int i = 0; i < headersLength; ++i) {
            headers.put(in.readString(), in.readString());
        }
        this.headers = Collections.unmodifiableMap(headers);
        this.socketTimeout = in.readTimeValue();
        this.connectTimeout = in.readTimeValue();
        this.pathPrefix = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.scheme);
        out.writeString(this.host);
        out.writeVInt(this.port);
        out.writeBytesReference(this.query);
        out.writeOptionalString(this.username);
        out.writeOptionalString(this.password);
        out.writeVInt(this.headers.size());
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            out.writeString(header.getKey());
            out.writeString(header.getValue());
        }
        out.writeTimeValue(this.socketTimeout);
        out.writeTimeValue(this.connectTimeout);
        out.writeOptionalString(this.pathPrefix);
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public BytesReference getQuery() {
        return this.query;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public TimeValue getSocketTimeout() {
        return this.socketTimeout;
    }

    public TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!"http".equals(this.scheme)) {
            b.append("scheme=").append(this.scheme).append(' ');
        }
        b.append("host=").append(this.host).append(" port=").append(this.port);
        if (this.pathPrefix != null) {
            b.append(" pathPrefix=").append(this.pathPrefix);
        }
        b.append(" query=").append(this.query.utf8ToString());
        if (this.username != null) {
            b.append(" username=").append(this.username);
        }
        if (this.password != null) {
            b.append(" password=<<>>");
        }
        return b.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.username != null) {
            builder.field("username", this.username);
        }
        if (this.password != null) {
            builder.field("password", this.password);
        }
        builder.field("host", this.scheme + "://" + this.host + ":" + this.port + (String)(this.pathPrefix == null ? "" : "/" + this.pathPrefix));
        if (this.headers.size() > 0) {
            builder.field("headers", this.headers);
        }
        builder.field("socket_timeout", this.socketTimeout.getStringRep());
        builder.field("connect_timeout", this.connectTimeout.getStringRep());
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteInfo that = (RemoteInfo)o;
        return this.port == that.port && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.pathPrefix, that.pathPrefix) && Objects.equals(this.query, that.query) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.headers, that.headers) && Objects.equals(this.socketTimeout, that.socketTimeout) && Objects.equals(this.connectTimeout, that.connectTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.pathPrefix, this.query, this.username, this.password, this.headers, this.socketTimeout, this.connectTimeout);
    }

    static BytesReference queryForRemote(Map<String, Object> source) throws IOException {
        XContentBuilder builder = XContentBuilder.builder(QUERY_CONTENT_TYPE).prettyPrint();
        Object query = source.remove("query");
        if (query == null) {
            return BytesReference.bytes(QueryBuilders.matchAllQuery().toXContent(builder, ToXContent.EMPTY_PARAMS));
        }
        if (!(query instanceof Map)) {
            throw new IllegalArgumentException("Expected [query] to be an object but was [" + query + "]");
        }
        Map map = (Map)query;
        return BytesReference.bytes(builder.map(map));
    }

    private static boolean isQueryJson(BytesReference bytesReference) {
        boolean bl;
        block8: {
            XContentParser parser = QUERY_CONTENT_TYPE.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, bytesReference.streamInput());
            try {
                Map<String, Object> query = parser.map();
                bl = true;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AssertionError("Could not parse JSON", e);
                }
            }
            parser.close();
        }
        return bl;
    }
}

