/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteRefreshSegmentPressureSettings;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteRefreshSegmentTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexEventListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;

public class RemoteRefreshSegmentPressureService
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(RemoteRefreshSegmentPressureService.class);
    private final Map<ShardId, RemoteRefreshSegmentTracker> trackerMap = ConcurrentCollections.newConcurrentMap();
    private final RemoteRefreshSegmentPressureSettings pressureSettings;
    private final List<LagValidator> lagValidators;

    @Inject
    public RemoteRefreshSegmentPressureService(ClusterService clusterService, Settings settings) {
        this.pressureSettings = new RemoteRefreshSegmentPressureSettings(clusterService, settings, this);
        this.lagValidators = Arrays.asList(new ConsecutiveFailureValidator(this.pressureSettings), new BytesLagValidator(this.pressureSettings), new TimeLagValidator(this.pressureSettings));
    }

    public RemoteRefreshSegmentTracker getRemoteRefreshSegmentTracker(ShardId shardId) {
        return this.trackerMap.get(shardId);
    }

    @Override
    public void afterIndexShardCreated(IndexShard indexShard) {
        if (!indexShard.indexSettings().isRemoteStoreEnabled()) {
            return;
        }
        ShardId shardId = indexShard.shardId();
        this.trackerMap.put(shardId, new RemoteRefreshSegmentTracker(shardId, this.pressureSettings.getUploadBytesMovingAverageWindowSize(), this.pressureSettings.getUploadBytesPerSecMovingAverageWindowSize(), this.pressureSettings.getUploadTimeMovingAverageWindowSize()));
        logger.trace("Created tracker for shardId={}", (Object)shardId);
    }

    @Override
    public void afterIndexShardClosed(ShardId shardId, IndexShard indexShard, Settings indexSettings) {
        RemoteRefreshSegmentTracker remoteRefreshSegmentTracker = this.trackerMap.remove(shardId);
        if (remoteRefreshSegmentTracker != null) {
            logger.trace("Deleted tracker for shardId={}", (Object)shardId);
        }
    }

    public boolean isSegmentsUploadBackpressureEnabled() {
        return this.pressureSettings.isRemoteRefreshSegmentPressureEnabled();
    }

    public void validateSegmentsUploadLag(ShardId shardId) {
        RemoteRefreshSegmentTracker remoteRefreshSegmentTracker = this.getRemoteRefreshSegmentTracker(shardId);
        if (remoteRefreshSegmentTracker == null || remoteRefreshSegmentTracker.getRefreshSeqNoLag() == 0L) {
            return;
        }
        for (LagValidator lagValidator : this.lagValidators) {
            if (lagValidator.validate(remoteRefreshSegmentTracker, shardId)) continue;
            remoteRefreshSegmentTracker.incrementRejectionCount(lagValidator.name());
            throw new OpenSearchRejectedExecutionException(lagValidator.rejectionMessage(remoteRefreshSegmentTracker, shardId));
        }
    }

    void updateUploadBytesMovingAverageWindowSize(int updatedSize) {
        this.updateMovingAverageWindowSize(RemoteRefreshSegmentTracker::updateUploadBytesMovingAverageWindowSize, updatedSize);
    }

    void updateUploadBytesPerSecMovingAverageWindowSize(int updatedSize) {
        this.updateMovingAverageWindowSize(RemoteRefreshSegmentTracker::updateUploadBytesPerSecMovingAverageWindowSize, updatedSize);
    }

    void updateUploadTimeMsMovingAverageWindowSize(int updatedSize) {
        this.updateMovingAverageWindowSize(RemoteRefreshSegmentTracker::updateUploadTimeMsMovingAverageWindowSize, updatedSize);
    }

    void updateMovingAverageWindowSize(BiConsumer<RemoteRefreshSegmentTracker, Integer> biConsumer, int updatedSize) {
        this.trackerMap.values().forEach(tracker -> biConsumer.accept((RemoteRefreshSegmentTracker)tracker, updatedSize));
    }

    private static abstract class LagValidator {
        final RemoteRefreshSegmentPressureSettings pressureSettings;

        private LagValidator(RemoteRefreshSegmentPressureSettings pressureSettings) {
            this.pressureSettings = pressureSettings;
        }

        abstract boolean validate(RemoteRefreshSegmentTracker var1, ShardId var2);

        abstract String name();

        abstract String rejectionMessage(RemoteRefreshSegmentTracker var1, ShardId var2);
    }

    private static class ConsecutiveFailureValidator
    extends LagValidator {
        private static final String NAME = "consecutive_failures_lag";

        private ConsecutiveFailureValidator(RemoteRefreshSegmentPressureSettings pressureSettings) {
            super(pressureSettings);
        }

        @Override
        public boolean validate(RemoteRefreshSegmentTracker pressureTracker, ShardId shardId) {
            int minConsecutiveFailureThreshold;
            int failureStreakCount = pressureTracker.getConsecutiveFailureCount();
            return failureStreakCount <= (minConsecutiveFailureThreshold = this.pressureSettings.getMinConsecutiveFailuresLimit());
        }

        @Override
        public String rejectionMessage(RemoteRefreshSegmentTracker pressureTracker, ShardId shardId) {
            return String.format(Locale.ROOT, "rejected execution on primary shard:%s due to remote segments lagging behind local segments.failure_streak_count:%s min_consecutive_failure_threshold:%s", shardId, pressureTracker.getConsecutiveFailureCount(), this.pressureSettings.getMinConsecutiveFailuresLimit());
        }

        @Override
        String name() {
            return NAME;
        }
    }

    private static class BytesLagValidator
    extends LagValidator {
        private static final String NAME = "bytes_lag";

        private BytesLagValidator(RemoteRefreshSegmentPressureSettings pressureSettings) {
            super(pressureSettings);
        }

        @Override
        public boolean validate(RemoteRefreshSegmentTracker pressureTracker, ShardId shardId) {
            if (pressureTracker.getRefreshSeqNoLag() <= 1L) {
                return true;
            }
            if (!pressureTracker.isUploadBytesAverageReady()) {
                logger.trace("upload bytes moving average is not ready");
                return true;
            }
            double dynamicBytesLagThreshold = pressureTracker.getUploadBytesAverage() * this.pressureSettings.getBytesLagVarianceFactor();
            long bytesLag = pressureTracker.getBytesLag();
            return (double)bytesLag <= dynamicBytesLagThreshold;
        }

        @Override
        public String rejectionMessage(RemoteRefreshSegmentTracker pressureTracker, ShardId shardId) {
            double dynamicBytesLagThreshold = pressureTracker.getUploadBytesAverage() * this.pressureSettings.getBytesLagVarianceFactor();
            return String.format(Locale.ROOT, "rejected execution on primary shard:%s due to remote segments lagging behind local segments.bytes_lag:%s dynamic_bytes_lag_threshold:%s", shardId, pressureTracker.getBytesLag(), dynamicBytesLagThreshold);
        }

        @Override
        String name() {
            return NAME;
        }
    }

    private static class TimeLagValidator
    extends LagValidator {
        private static final String NAME = "time_lag";

        private TimeLagValidator(RemoteRefreshSegmentPressureSettings pressureSettings) {
            super(pressureSettings);
        }

        @Override
        public boolean validate(RemoteRefreshSegmentTracker pressureTracker, ShardId shardId) {
            double dynamicTimeLagThreshold;
            if (pressureTracker.getRefreshSeqNoLag() <= 1L) {
                return true;
            }
            if (!pressureTracker.isUploadTimeMsAverageReady()) {
                logger.trace("upload time moving average is not ready");
                return true;
            }
            long timeLag = pressureTracker.getTimeMsLag();
            return (double)timeLag <= (dynamicTimeLagThreshold = pressureTracker.getUploadTimeMsAverage() * this.pressureSettings.getUploadTimeLagVarianceFactor());
        }

        @Override
        public String rejectionMessage(RemoteRefreshSegmentTracker pressureTracker, ShardId shardId) {
            double dynamicTimeLagThreshold = pressureTracker.getUploadTimeMsAverage() * this.pressureSettings.getUploadTimeLagVarianceFactor();
            return String.format(Locale.ROOT, "rejected execution on primary shard:%s due to remote segments lagging behind local segments.time_lag:%s ms dynamic_time_lag_threshold:%s ms", shardId, pressureTracker.getTimeMsLag(), dynamicTimeLagThreshold);
        }

        @Override
        String name() {
            return NAME;
        }
    }
}

