/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteRefreshSegmentPressureService;

public class RemoteRefreshSegmentPressureSettings {
    public static final Setting<Boolean> REMOTE_REFRESH_SEGMENT_PRESSURE_ENABLED = Setting.boolSetting("remote_store.segment.pressure.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> BYTES_LAG_VARIANCE_FACTOR = Setting.doubleSetting("remote_store.segment.pressure.bytes_lag.variance_factor", 10.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Double> UPLOAD_TIME_LAG_VARIANCE_FACTOR = Setting.doubleSetting("remote_store.segment.pressure.time_lag.variance_factor", 10.0, 1.0, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> MIN_CONSECUTIVE_FAILURES_LIMIT = Setting.intSetting("remote_store.segment.pressure.consecutive_failures.limit", 5, 1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> UPLOAD_BYTES_MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting("remote_store.segment.pressure.upload_bytes_moving_average_window_size", 20, 5, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> UPLOAD_BYTES_PER_SEC_MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting("remote_store.segment.pressure.upload_bytes_per_sec_moving_average_window_size", 20, 5, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> UPLOAD_TIME_MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting("remote_store.segment.pressure.upload_time_moving_average_window_size", 20, 5, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean remoteRefreshSegmentPressureEnabled;
    private volatile long minRefreshSeqNoLagLimit;
    private volatile double bytesLagVarianceFactor;
    private volatile double uploadTimeLagVarianceFactor;
    private volatile int minConsecutiveFailuresLimit;
    private volatile int uploadBytesMovingAverageWindowSize;
    private volatile int uploadBytesPerSecMovingAverageWindowSize;
    private volatile int uploadTimeMovingAverageWindowSize;

    public RemoteRefreshSegmentPressureSettings(ClusterService clusterService, Settings settings, RemoteRefreshSegmentPressureService remoteUploadPressureService) {
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.remoteRefreshSegmentPressureEnabled = REMOTE_REFRESH_SEGMENT_PRESSURE_ENABLED.get(settings);
        clusterSettings.addSettingsUpdateConsumer(REMOTE_REFRESH_SEGMENT_PRESSURE_ENABLED, this::setRemoteRefreshSegmentPressureEnabled);
        this.bytesLagVarianceFactor = BYTES_LAG_VARIANCE_FACTOR.get(settings);
        clusterSettings.addSettingsUpdateConsumer(BYTES_LAG_VARIANCE_FACTOR, this::setBytesLagVarianceFactor);
        this.uploadTimeLagVarianceFactor = UPLOAD_TIME_LAG_VARIANCE_FACTOR.get(settings);
        clusterSettings.addSettingsUpdateConsumer(UPLOAD_TIME_LAG_VARIANCE_FACTOR, this::setUploadTimeLagVarianceFactor);
        this.minConsecutiveFailuresLimit = MIN_CONSECUTIVE_FAILURES_LIMIT.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MIN_CONSECUTIVE_FAILURES_LIMIT, this::setMinConsecutiveFailuresLimit);
        this.uploadBytesMovingAverageWindowSize = UPLOAD_BYTES_MOVING_AVERAGE_WINDOW_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(UPLOAD_BYTES_MOVING_AVERAGE_WINDOW_SIZE, remoteUploadPressureService::updateUploadBytesMovingAverageWindowSize);
        clusterSettings.addSettingsUpdateConsumer(UPLOAD_BYTES_MOVING_AVERAGE_WINDOW_SIZE, this::setUploadBytesMovingAverageWindowSize);
        this.uploadBytesPerSecMovingAverageWindowSize = UPLOAD_BYTES_PER_SEC_MOVING_AVERAGE_WINDOW_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(UPLOAD_BYTES_PER_SEC_MOVING_AVERAGE_WINDOW_SIZE, remoteUploadPressureService::updateUploadBytesPerSecMovingAverageWindowSize);
        clusterSettings.addSettingsUpdateConsumer(UPLOAD_BYTES_PER_SEC_MOVING_AVERAGE_WINDOW_SIZE, this::setUploadBytesPerSecMovingAverageWindowSize);
        this.uploadTimeMovingAverageWindowSize = UPLOAD_TIME_MOVING_AVERAGE_WINDOW_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(UPLOAD_TIME_MOVING_AVERAGE_WINDOW_SIZE, remoteUploadPressureService::updateUploadTimeMsMovingAverageWindowSize);
        clusterSettings.addSettingsUpdateConsumer(UPLOAD_TIME_MOVING_AVERAGE_WINDOW_SIZE, this::setUploadTimeMovingAverageWindowSize);
    }

    public boolean isRemoteRefreshSegmentPressureEnabled() {
        return this.remoteRefreshSegmentPressureEnabled;
    }

    public void setRemoteRefreshSegmentPressureEnabled(boolean remoteRefreshSegmentPressureEnabled) {
        this.remoteRefreshSegmentPressureEnabled = remoteRefreshSegmentPressureEnabled;
    }

    public long getMinRefreshSeqNoLagLimit() {
        return this.minRefreshSeqNoLagLimit;
    }

    public void setMinRefreshSeqNoLagLimit(long minRefreshSeqNoLagLimit) {
        this.minRefreshSeqNoLagLimit = minRefreshSeqNoLagLimit;
    }

    public double getBytesLagVarianceFactor() {
        return this.bytesLagVarianceFactor;
    }

    public void setBytesLagVarianceFactor(double bytesLagVarianceFactor) {
        this.bytesLagVarianceFactor = bytesLagVarianceFactor;
    }

    public double getUploadTimeLagVarianceFactor() {
        return this.uploadTimeLagVarianceFactor;
    }

    public void setUploadTimeLagVarianceFactor(double uploadTimeLagVarianceFactor) {
        this.uploadTimeLagVarianceFactor = uploadTimeLagVarianceFactor;
    }

    public int getMinConsecutiveFailuresLimit() {
        return this.minConsecutiveFailuresLimit;
    }

    public void setMinConsecutiveFailuresLimit(int minConsecutiveFailuresLimit) {
        this.minConsecutiveFailuresLimit = minConsecutiveFailuresLimit;
    }

    public int getUploadBytesMovingAverageWindowSize() {
        return this.uploadBytesMovingAverageWindowSize;
    }

    public void setUploadBytesMovingAverageWindowSize(int uploadBytesMovingAverageWindowSize) {
        this.uploadBytesMovingAverageWindowSize = uploadBytesMovingAverageWindowSize;
    }

    public int getUploadBytesPerSecMovingAverageWindowSize() {
        return this.uploadBytesPerSecMovingAverageWindowSize;
    }

    public void setUploadBytesPerSecMovingAverageWindowSize(int uploadBytesPerSecMovingAverageWindowSize) {
        this.uploadBytesPerSecMovingAverageWindowSize = uploadBytesPerSecMovingAverageWindowSize;
    }

    public int getUploadTimeMovingAverageWindowSize() {
        return this.uploadTimeMovingAverageWindowSize;
    }

    public void setUploadTimeMovingAverageWindowSize(int uploadTimeMovingAverageWindowSize) {
        this.uploadTimeMovingAverageWindowSize = uploadTimeMovingAverageWindowSize;
    }

    private static class Defaults {
        private static final double BYTES_LAG_VARIANCE_FACTOR = 10.0;
        private static final double UPLOAD_TIME_LAG_VARIANCE_FACTOR = 10.0;
        private static final double VARIANCE_FACTOR_MIN_VALUE = 1.0;
        private static final int MIN_CONSECUTIVE_FAILURES_LIMIT = 5;
        private static final int MIN_CONSECUTIVE_FAILURES_LIMIT_MIN_VALUE = 1;
        private static final int UPLOAD_BYTES_MOVING_AVERAGE_WINDOW_SIZE = 20;
        private static final int UPLOAD_BYTES_PER_SEC_MOVING_AVERAGE_WINDOW_SIZE = 20;
        private static final int UPLOAD_TIME_MOVING_AVERAGE_WINDOW_SIZE = 20;
        private static final int MOVING_AVERAGE_WINDOW_SIZE_MIN_VALUE = 5;

        private Defaults() {
        }
    }
}

