/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.MovingAverage;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.Streak;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;

public class RemoteRefreshSegmentTracker {
    private final ShardId shardId;
    private volatile long localRefreshSeqNo;
    private volatile long localRefreshTimeMs;
    private volatile long localRefreshClockTimeMs;
    private volatile long remoteRefreshSeqNo;
    private volatile long remoteRefreshTimeMs;
    private volatile long remoteRefreshClockTimeMs;
    private volatile long refreshSeqNoLag;
    private volatile long timeMsLag;
    private volatile long lastSuccessfulRemoteRefreshBytes;
    private volatile long uploadBytesStarted;
    private volatile long uploadBytesFailed;
    private volatile long uploadBytesSucceeded;
    private volatile long totalUploadsStarted;
    private volatile long totalUploadsFailed;
    private volatile long totalUploadsSucceeded;
    private final AtomicLong rejectionCount = new AtomicLong();
    private final Map<String, AtomicLong> rejectionCountMap = ConcurrentCollections.newConcurrentMap();
    private volatile Map<String, Long> latestLocalFileNameLengthMap;
    private final Set<String> latestUploadedFiles = new HashSet<String>();
    private volatile long bytesLag;
    private final Streak failures = new Streak();
    private final AtomicReference<MovingAverage> uploadBytesMovingAverageReference;
    private final Object uploadBytesMutex = new Object();
    private final AtomicReference<MovingAverage> uploadBytesPerSecMovingAverageReference;
    private final Object uploadBytesPerSecMutex = new Object();
    private final AtomicReference<MovingAverage> uploadTimeMsMovingAverageReference;
    private final Object uploadTimeMsMutex = new Object();

    public RemoteRefreshSegmentTracker(ShardId shardId, int uploadBytesMovingAverageWindowSize, int uploadBytesPerSecMovingAverageWindowSize, int uploadTimeMsMovingAverageWindowSize) {
        long currentTimeMs;
        this.shardId = shardId;
        long currentClockTimeMs = System.currentTimeMillis();
        this.localRefreshTimeMs = currentTimeMs = System.nanoTime() / 1000000L;
        this.remoteRefreshTimeMs = currentTimeMs;
        this.localRefreshClockTimeMs = currentClockTimeMs;
        this.remoteRefreshClockTimeMs = currentClockTimeMs;
        this.uploadBytesMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(uploadBytesMovingAverageWindowSize));
        this.uploadBytesPerSecMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(uploadBytesPerSecMovingAverageWindowSize));
        this.uploadTimeMsMovingAverageReference = new AtomicReference<MovingAverage>(new MovingAverage(uploadTimeMsMovingAverageWindowSize));
        this.latestLocalFileNameLengthMap = new HashMap<String, Long>();
    }

    ShardId getShardId() {
        return this.shardId;
    }

    public long getLocalRefreshSeqNo() {
        return this.localRefreshSeqNo;
    }

    public void updateLocalRefreshSeqNo(long localRefreshSeqNo) {
        assert (localRefreshSeqNo >= this.localRefreshSeqNo) : "newLocalRefreshSeqNo=" + localRefreshSeqNo + " < currentLocalRefreshSeqNo=" + this.localRefreshSeqNo;
        this.localRefreshSeqNo = localRefreshSeqNo;
        this.computeRefreshSeqNoLag();
    }

    public long getLocalRefreshTimeMs() {
        return this.localRefreshTimeMs;
    }

    public long getLocalRefreshClockTimeMs() {
        return this.localRefreshClockTimeMs;
    }

    public void updateLocalRefreshTimeMs(long localRefreshTimeMs) {
        assert (localRefreshTimeMs >= this.localRefreshTimeMs) : "newLocalRefreshTimeMs=" + localRefreshTimeMs + " < currentLocalRefreshTimeMs=" + this.localRefreshTimeMs;
        this.localRefreshTimeMs = localRefreshTimeMs;
        this.computeTimeMsLag();
    }

    public void updateLocalRefreshClockTimeMs(long localRefreshClockTimeMs) {
        this.localRefreshClockTimeMs = localRefreshClockTimeMs;
    }

    long getRemoteRefreshSeqNo() {
        return this.remoteRefreshSeqNo;
    }

    public void updateRemoteRefreshSeqNo(long remoteRefreshSeqNo) {
        assert (remoteRefreshSeqNo >= this.remoteRefreshSeqNo) : "newRemoteRefreshSeqNo=" + remoteRefreshSeqNo + " < currentRemoteRefreshSeqNo=" + this.remoteRefreshSeqNo;
        this.remoteRefreshSeqNo = remoteRefreshSeqNo;
        this.computeRefreshSeqNoLag();
    }

    long getRemoteRefreshTimeMs() {
        return this.remoteRefreshTimeMs;
    }

    long getRemoteRefreshClockTimeMs() {
        return this.remoteRefreshClockTimeMs;
    }

    public void updateRemoteRefreshTimeMs(long remoteRefreshTimeMs) {
        assert (remoteRefreshTimeMs >= this.remoteRefreshTimeMs) : "newRemoteRefreshTimeMs=" + remoteRefreshTimeMs + " < currentRemoteRefreshTimeMs=" + this.remoteRefreshTimeMs;
        this.remoteRefreshTimeMs = remoteRefreshTimeMs;
        this.computeTimeMsLag();
    }

    public void updateRemoteRefreshClockTimeMs(long remoteRefreshClockTimeMs) {
        this.remoteRefreshClockTimeMs = remoteRefreshClockTimeMs;
    }

    private void computeRefreshSeqNoLag() {
        this.refreshSeqNoLag = this.localRefreshSeqNo - this.remoteRefreshSeqNo;
    }

    public long getRefreshSeqNoLag() {
        return this.refreshSeqNoLag;
    }

    private void computeTimeMsLag() {
        this.timeMsLag = this.localRefreshTimeMs - this.remoteRefreshTimeMs;
    }

    public long getTimeMsLag() {
        return this.timeMsLag;
    }

    public long getBytesLag() {
        return this.bytesLag;
    }

    public long getUploadBytesStarted() {
        return this.uploadBytesStarted;
    }

    public void addUploadBytesStarted(long size) {
        this.uploadBytesStarted += size;
    }

    public long getUploadBytesFailed() {
        return this.uploadBytesFailed;
    }

    public void addUploadBytesFailed(long size) {
        this.uploadBytesFailed += size;
    }

    public long getUploadBytesSucceeded() {
        return this.uploadBytesSucceeded;
    }

    public void addUploadBytesSucceeded(long size) {
        this.uploadBytesSucceeded += size;
    }

    public long getInflightUploadBytes() {
        return this.uploadBytesStarted - this.uploadBytesFailed - this.uploadBytesSucceeded;
    }

    public long getTotalUploadsStarted() {
        return this.totalUploadsStarted;
    }

    public void incrementTotalUploadsStarted() {
        ++this.totalUploadsStarted;
    }

    public long getTotalUploadsFailed() {
        return this.totalUploadsFailed;
    }

    public void incrementTotalUploadsFailed() {
        ++this.totalUploadsFailed;
        this.failures.record(true);
    }

    public long getTotalUploadsSucceeded() {
        return this.totalUploadsSucceeded;
    }

    public void incrementTotalUploadsSucceeded() {
        ++this.totalUploadsSucceeded;
        this.failures.record(false);
    }

    public long getInflightUploads() {
        return this.totalUploadsStarted - this.totalUploadsFailed - this.totalUploadsSucceeded;
    }

    public long getRejectionCount() {
        return this.rejectionCount.get();
    }

    void incrementRejectionCount() {
        this.rejectionCount.incrementAndGet();
    }

    void incrementRejectionCount(String rejectionReason) {
        this.rejectionCountMap.computeIfAbsent(rejectionReason, k -> new AtomicLong()).incrementAndGet();
        this.incrementRejectionCount();
    }

    long getRejectionCount(String rejectionReason) {
        return this.rejectionCountMap.get(rejectionReason).get();
    }

    Map<String, Long> getLatestLocalFileNameLengthMap() {
        return this.latestLocalFileNameLengthMap;
    }

    public void setLatestLocalFileNameLengthMap(Map<String, Long> latestLocalFileNameLengthMap) {
        this.latestLocalFileNameLengthMap = latestLocalFileNameLengthMap;
        this.computeBytesLag();
    }

    public void addToLatestUploadedFiles(String file) {
        this.latestUploadedFiles.add(file);
        this.computeBytesLag();
    }

    public void setLatestUploadedFiles(Set<String> files) {
        this.latestUploadedFiles.clear();
        this.latestUploadedFiles.addAll(files);
        this.computeBytesLag();
    }

    private void computeBytesLag() {
        if (this.latestLocalFileNameLengthMap == null || this.latestLocalFileNameLengthMap.isEmpty()) {
            return;
        }
        Set filesNotYetUploaded = this.latestLocalFileNameLengthMap.keySet().stream().filter(f -> !this.latestUploadedFiles.contains(f)).collect(Collectors.toSet());
        this.bytesLag = filesNotYetUploaded.stream().map(this.latestLocalFileNameLengthMap::get).mapToLong(Long::longValue).sum();
    }

    int getConsecutiveFailureCount() {
        return this.failures.length();
    }

    boolean isUploadBytesAverageReady() {
        return this.uploadBytesMovingAverageReference.get().isReady();
    }

    double getUploadBytesAverage() {
        return this.uploadBytesMovingAverageReference.get().getAverage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadBytes(long size) {
        this.lastSuccessfulRemoteRefreshBytes = size;
        Object object = this.uploadBytesMutex;
        synchronized (object) {
            this.uploadBytesMovingAverageReference.get().record(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUploadBytesMovingAverageWindowSize(int updatedSize) {
        Object object = this.uploadBytesMutex;
        synchronized (object) {
            this.uploadBytesMovingAverageReference.set(this.uploadBytesMovingAverageReference.get().copyWithSize(updatedSize));
        }
    }

    boolean isUploadBytesPerSecAverageReady() {
        return this.uploadBytesPerSecMovingAverageReference.get().isReady();
    }

    double getUploadBytesPerSecAverage() {
        return this.uploadBytesPerSecMovingAverageReference.get().getAverage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadBytesPerSec(long bytesPerSec) {
        Object object = this.uploadBytesPerSecMutex;
        synchronized (object) {
            this.uploadBytesPerSecMovingAverageReference.get().record(bytesPerSec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUploadBytesPerSecMovingAverageWindowSize(int updatedSize) {
        Object object = this.uploadBytesPerSecMutex;
        synchronized (object) {
            this.uploadBytesPerSecMovingAverageReference.set(this.uploadBytesPerSecMovingAverageReference.get().copyWithSize(updatedSize));
        }
    }

    boolean isUploadTimeMsAverageReady() {
        return this.uploadTimeMsMovingAverageReference.get().isReady();
    }

    double getUploadTimeMsAverage() {
        return this.uploadTimeMsMovingAverageReference.get().getAverage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadTimeMs(long timeMs) {
        Object object = this.uploadTimeMsMutex;
        synchronized (object) {
            this.uploadTimeMsMovingAverageReference.get().record(timeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUploadTimeMsMovingAverageWindowSize(int updatedSize) {
        Object object = this.uploadTimeMsMutex;
        synchronized (object) {
            this.uploadTimeMsMovingAverageReference.set(this.uploadTimeMsMovingAverageReference.get().copyWithSize(updatedSize));
        }
    }

    public Stats stats() {
        return new Stats(this.shardId, this.localRefreshClockTimeMs, this.remoteRefreshClockTimeMs, this.timeMsLag, this.localRefreshSeqNo, this.remoteRefreshSeqNo, this.uploadBytesStarted, this.uploadBytesSucceeded, this.uploadBytesFailed, this.totalUploadsStarted, this.totalUploadsSucceeded, this.totalUploadsFailed, this.rejectionCount.get(), this.failures.length(), this.lastSuccessfulRemoteRefreshBytes, this.uploadBytesMovingAverageReference.get().getAverage(), this.uploadBytesPerSecMovingAverageReference.get().getAverage(), this.uploadTimeMsMovingAverageReference.get().getAverage(), this.getBytesLag());
    }

    public static class Stats
    implements Writeable {
        public final ShardId shardId;
        public final long localRefreshClockTimeMs;
        public final long remoteRefreshClockTimeMs;
        public final long refreshTimeLagMs;
        public final long localRefreshNumber;
        public final long remoteRefreshNumber;
        public final long uploadBytesStarted;
        public final long uploadBytesFailed;
        public final long uploadBytesSucceeded;
        public final long totalUploadsStarted;
        public final long totalUploadsFailed;
        public final long totalUploadsSucceeded;
        public final long rejectionCount;
        public final long consecutiveFailuresCount;
        public final long lastSuccessfulRemoteRefreshBytes;
        public final double uploadBytesMovingAverage;
        public final double uploadBytesPerSecMovingAverage;
        public final double uploadTimeMovingAverage;
        public final long bytesLag;

        public Stats(ShardId shardId, long localRefreshClockTimeMs, long remoteRefreshClockTimeMs, long refreshTimeLagMs, long localRefreshNumber, long remoteRefreshNumber, long uploadBytesStarted, long uploadBytesSucceeded, long uploadBytesFailed, long totalUploadsStarted, long totalUploadsSucceeded, long totalUploadsFailed, long rejectionCount, long consecutiveFailuresCount, long lastSuccessfulRemoteRefreshBytes, double uploadBytesMovingAverage, double uploadBytesPerSecMovingAverage, double uploadTimeMovingAverage, long bytesLag) {
            this.shardId = shardId;
            this.localRefreshClockTimeMs = localRefreshClockTimeMs;
            this.remoteRefreshClockTimeMs = remoteRefreshClockTimeMs;
            this.refreshTimeLagMs = refreshTimeLagMs;
            this.localRefreshNumber = localRefreshNumber;
            this.remoteRefreshNumber = remoteRefreshNumber;
            this.uploadBytesStarted = uploadBytesStarted;
            this.uploadBytesFailed = uploadBytesFailed;
            this.uploadBytesSucceeded = uploadBytesSucceeded;
            this.totalUploadsStarted = totalUploadsStarted;
            this.totalUploadsFailed = totalUploadsFailed;
            this.totalUploadsSucceeded = totalUploadsSucceeded;
            this.rejectionCount = rejectionCount;
            this.consecutiveFailuresCount = consecutiveFailuresCount;
            this.lastSuccessfulRemoteRefreshBytes = lastSuccessfulRemoteRefreshBytes;
            this.uploadBytesMovingAverage = uploadBytesMovingAverage;
            this.uploadBytesPerSecMovingAverage = uploadBytesPerSecMovingAverage;
            this.uploadTimeMovingAverage = uploadTimeMovingAverage;
            this.bytesLag = bytesLag;
        }

        public Stats(StreamInput in) throws IOException {
            this.shardId = new ShardId(in);
            this.localRefreshClockTimeMs = in.readLong();
            this.remoteRefreshClockTimeMs = in.readLong();
            this.refreshTimeLagMs = in.readLong();
            this.localRefreshNumber = in.readLong();
            this.remoteRefreshNumber = in.readLong();
            this.uploadBytesStarted = in.readLong();
            this.uploadBytesFailed = in.readLong();
            this.uploadBytesSucceeded = in.readLong();
            this.totalUploadsStarted = in.readLong();
            this.totalUploadsFailed = in.readLong();
            this.totalUploadsSucceeded = in.readLong();
            this.rejectionCount = in.readLong();
            this.consecutiveFailuresCount = in.readLong();
            this.lastSuccessfulRemoteRefreshBytes = in.readLong();
            this.uploadBytesMovingAverage = in.readDouble();
            this.uploadBytesPerSecMovingAverage = in.readDouble();
            this.uploadTimeMovingAverage = in.readDouble();
            this.bytesLag = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.shardId.writeTo(out);
            out.writeLong(this.localRefreshClockTimeMs);
            out.writeLong(this.remoteRefreshClockTimeMs);
            out.writeLong(this.refreshTimeLagMs);
            out.writeLong(this.localRefreshNumber);
            out.writeLong(this.remoteRefreshNumber);
            out.writeLong(this.uploadBytesStarted);
            out.writeLong(this.uploadBytesFailed);
            out.writeLong(this.uploadBytesSucceeded);
            out.writeLong(this.totalUploadsStarted);
            out.writeLong(this.totalUploadsFailed);
            out.writeLong(this.totalUploadsSucceeded);
            out.writeLong(this.rejectionCount);
            out.writeLong(this.consecutiveFailuresCount);
            out.writeLong(this.lastSuccessfulRemoteRefreshBytes);
            out.writeDouble(this.uploadBytesMovingAverage);
            out.writeDouble(this.uploadBytesPerSecMovingAverage);
            out.writeDouble(this.uploadTimeMovingAverage);
            out.writeLong(this.bytesLag);
        }
    }
}

