/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.shard;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ReferenceManager;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BackoffPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.concurrent.GatedCloseable;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.Loggers;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ConcurrentCollections;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.EngineException;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.InternalEngine;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteRefreshSegmentTracker;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShardState;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.Translog;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.SegmentReplicationCheckpointPublisher;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.Scheduler;

public final class RemoteStoreRefreshListener
implements ReferenceManager.RefreshListener {
    private final Logger logger;
    private static final int REMOTE_REFRESH_RETRY_BASE_INTERVAL_MILLIS = 1000;
    private static final int REMOTE_REFRESH_RETRY_MAX_INTERVAL_MILLIS = 10000;
    private static final int INVALID_PRIMARY_TERM = -1;
    private static final BackoffPolicy EXPONENTIAL_BACKOFF_POLICY = BackoffPolicy.exponentialEqualJitterBackoff(1000L, 10000L);
    static final Set<String> EXCLUDE_FILES = Set.of("write.lock");
    public static final int LAST_N_METADATA_FILES_TO_KEEP = 10;
    private final IndexShard indexShard;
    private final Directory storeDirectory;
    private final RemoteSegmentStoreDirectory remoteDirectory;
    private final RemoteRefreshSegmentTracker segmentTracker;
    private final Map<String, String> localSegmentChecksumMap;
    private long primaryTerm;
    private final AtomicBoolean retryScheduled = new AtomicBoolean(false);
    private volatile Iterator<TimeValue> backoffDelayIterator;
    private volatile Scheduler.ScheduledCancellable scheduledCancellableRetry;
    private final Map<String, Long> latestFileNameSizeOnLocalMap = ConcurrentCollections.newConcurrentMap();
    private final SegmentReplicationCheckpointPublisher checkpointPublisher;
    private final FileUploader fileUploader;

    public RemoteStoreRefreshListener(IndexShard indexShard, SegmentReplicationCheckpointPublisher checkpointPublisher, final RemoteRefreshSegmentTracker segmentTracker) {
        this.logger = Loggers.getLogger(this.getClass(), indexShard.shardId(), new String[0]);
        this.indexShard = indexShard;
        this.storeDirectory = indexShard.store().directory();
        this.remoteDirectory = (RemoteSegmentStoreDirectory)((FilterDirectory)((FilterDirectory)indexShard.remoteStore().directory()).getDelegate()).getDelegate();
        this.localSegmentChecksumMap = new HashMap<String, String>();
        RemoteSegmentMetadata remoteSegmentMetadata = null;
        if (indexShard.routingEntry().primary()) {
            try {
                remoteSegmentMetadata = this.remoteDirectory.init();
            }
            catch (IOException e) {
                this.logger.error("Exception while initialising RemoteSegmentStoreDirectory", (Throwable)e);
            }
        }
        this.primaryTerm = remoteSegmentMetadata != null ? remoteSegmentMetadata.getPrimaryTerm() : -1L;
        this.segmentTracker = segmentTracker;
        this.resetBackOffDelayIterator();
        this.checkpointPublisher = checkpointPublisher;
        this.fileUploader = new FileUploader(new UploadTracker(){

            @Override
            public void beforeUpload(String file) {
                segmentTracker.addUploadBytesStarted(RemoteStoreRefreshListener.this.latestFileNameSizeOnLocalMap.get(file));
            }

            @Override
            public void onSuccess(String file) {
                segmentTracker.addUploadBytesSucceeded(RemoteStoreRefreshListener.this.latestFileNameSizeOnLocalMap.get(file));
                segmentTracker.addToLatestUploadedFiles(file);
            }

            @Override
            public void onFailure(String file) {
                segmentTracker.addUploadBytesFailed(RemoteStoreRefreshListener.this.latestFileNameSizeOnLocalMap.get(file));
            }
        }, this.remoteDirectory, this.storeDirectory, this::getChecksumOfLocalFile, this.logger);
    }

    @Override
    public void beforeRefresh() throws IOException {
    }

    @Override
    public void afterRefresh(boolean didRefresh) {
        if (this.primaryTerm != this.indexShard.getOperationPrimaryTerm() || didRefresh || this.remoteDirectory.getSegmentsUploadedToRemoteStore().isEmpty()) {
            this.updateLocalRefreshTimeAndSeqNo();
            try {
                this.indexShard.getThreadPool().executor("remote_refresh").submit(() -> this.syncSegments(false)).get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.logger.info("Exception occurred while scheduling syncSegments", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void syncSegments(boolean isRetry) {
        if (!this.indexShard.getReplicationTracker().isPrimaryMode()) {
            this.logger.info("syncSegments is only supported with primaryMode=true, current value is false. Skipping");
            return;
        }
        if (!(this.indexShard.getEngine() instanceof InternalEngine)) {
            this.logger.info("syncSegments is only supported for InternalEngine, called with {}. Skipping", (Object)this.indexShard.getEngine());
            return;
        }
        this.beforeSegmentsSync(isRetry);
        long refreshTimeMs = this.segmentTracker.getLocalRefreshTimeMs();
        long refreshClockTimeMs = this.segmentTracker.getLocalRefreshClockTimeMs();
        long refreshSeqNo = this.segmentTracker.getLocalRefreshSeqNo();
        long bytesBeforeUpload = this.segmentTracker.getUploadBytesSucceeded();
        long startTimeInNS = System.nanoTime();
        boolean shouldRetry = true;
        try {
            if (this.primaryTerm != this.indexShard.getOperationPrimaryTerm()) {
                this.primaryTerm = this.indexShard.getOperationPrimaryTerm();
                this.remoteDirectory.init();
            }
            try {
                if (this.isRefreshAfterCommit()) {
                    this.remoteDirectory.deleteStaleSegmentsAsync(10);
                }
                try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.indexShard.getSegmentInfosSnapshot();){
                    SegmentInfos segmentInfos = segmentInfosGatedCloseable.get();
                    ReplicationCheckpoint checkpoint = this.indexShard.getLatestReplicationCheckpoint();
                    long lastRefreshedCheckpoint = ((InternalEngine)this.indexShard.getEngine()).lastRefreshedCheckpoint();
                    Collection<String> localSegmentsPostRefresh = segmentInfos.files(true);
                    List segmentInfosFiles = localSegmentsPostRefresh.stream().filter(file -> file.startsWith("segments")).collect(Collectors.toList());
                    Optional<String> latestSegmentInfos = segmentInfosFiles.stream().max(Comparator.comparingLong(SegmentInfos::generationFromSegmentsFileName));
                    if (latestSegmentInfos.isPresent()) {
                        localSegmentsPostRefresh.addAll(SegmentInfos.readCommit(this.storeDirectory, latestSegmentInfos.get()).files(true));
                        segmentInfosFiles.stream().filter(file -> !file.equals(latestSegmentInfos.get())).forEach(localSegmentsPostRefresh::remove);
                        this.updateLocalSizeMapAndTracker(localSegmentsPostRefresh);
                        boolean newSegmentsUploadStatus = this.uploadNewSegments(localSegmentsPostRefresh);
                        if (newSegmentsUploadStatus) {
                            this.uploadMetadata(localSegmentsPostRefresh, segmentInfos);
                            this.clearStaleFilesFromLocalSegmentChecksumMap(localSegmentsPostRefresh);
                            this.onSuccessfulSegmentsSync(refreshTimeMs, refreshClockTimeMs, refreshSeqNo, lastRefreshedCheckpoint, checkpoint);
                            shouldRetry = false;
                        }
                    }
                }
                catch (EngineException e) {
                    this.logger.warn("Exception while reading SegmentInfosSnapshot", (Throwable)e);
                }
            }
            catch (IOException e) {
                this.logger.warn("Exception while uploading new segments to the remote segment store", (Throwable)e);
            }
            this.updateFinalUploadStatusInSegmentTracker(!shouldRetry, bytesBeforeUpload, startTimeInNS);
        }
        catch (Throwable t) {
            try {
                this.logger.error("Exception in RemoteStoreRefreshListener.afterRefresh()", t);
                this.updateFinalUploadStatusInSegmentTracker(!shouldRetry, bytesBeforeUpload, startTimeInNS);
            }
            catch (Throwable throwable) {
                this.updateFinalUploadStatusInSegmentTracker(!shouldRetry, bytesBeforeUpload, startTimeInNS);
                throw throwable;
            }
        }
        this.afterSegmentsSync(isRetry, shouldRetry);
    }

    private void clearStaleFilesFromLocalSegmentChecksumMap(Collection<String> localSegmentsPostRefresh) {
        this.localSegmentChecksumMap.keySet().stream().filter(file -> !localSegmentsPostRefresh.contains(file)).collect(Collectors.toSet()).forEach(this.localSegmentChecksumMap::remove);
    }

    private void beforeSegmentsSync(boolean isRetry) {
        if (isRetry) {
            this.logger.info("Retrying to sync the segments to remote store");
        }
        this.segmentTracker.incrementTotalUploadsStarted();
    }

    private void onSuccessfulSegmentsSync(long refreshTimeMs, long refreshClockTimeMs, long refreshSeqNo, long lastRefreshedCheckpoint, ReplicationCheckpoint checkpoint) {
        this.segmentTracker.setLatestUploadedFiles(this.latestFileNameSizeOnLocalMap.keySet());
        this.updateRemoteRefreshTimeAndSeqNo(refreshTimeMs, refreshClockTimeMs, refreshSeqNo);
        this.resetBackOffDelayIterator();
        this.cancelAndResetScheduledCancellableRetry();
        ((InternalEngine)this.indexShard.getEngine()).translogManager().setMinSeqNoToKeep(lastRefreshedCheckpoint + 1L);
        this.checkpointPublisher.publish(this.indexShard, checkpoint);
    }

    private void cancelAndResetScheduledCancellableRetry() {
        if (this.scheduledCancellableRetry != null && this.scheduledCancellableRetry.getDelay(TimeUnit.NANOSECONDS) > 0L) {
            this.scheduledCancellableRetry.cancel();
            this.retryScheduled.set(false);
        }
        this.scheduledCancellableRetry = null;
    }

    private void resetBackOffDelayIterator() {
        this.backoffDelayIterator = EXPONENTIAL_BACKOFF_POLICY.iterator();
    }

    private void afterSegmentsSync(boolean isRetry, boolean shouldRetry) {
        if (isRetry) {
            this.retryScheduled.set(false);
        }
        if (shouldRetry && this.indexShard.state() != IndexShardState.CLOSED && this.retryScheduled.compareAndSet(false, true)) {
            this.scheduledCancellableRetry = this.indexShard.getThreadPool().schedule(() -> this.syncSegments(true), this.backoffDelayIterator.next(), "remote_refresh");
        }
    }

    private boolean isRefreshAfterCommit() throws IOException {
        String lastCommittedLocalSegmentFileName = SegmentInfos.getLastCommitSegmentsFileName(this.storeDirectory);
        return lastCommittedLocalSegmentFileName != null && !this.remoteDirectory.containsFile(lastCommittedLocalSegmentFileName, this.getChecksumOfLocalFile(lastCommittedLocalSegmentFileName));
    }

    void uploadMetadata(Collection<String> localSegmentsPostRefresh, SegmentInfos segmentInfos) throws IOException {
        long maxSeqNo = ((InternalEngine)this.indexShard.getEngine()).currentOngoingRefreshCheckpoint();
        SegmentInfos segmentInfosSnapshot = segmentInfos.clone();
        Map<String, String> userData = segmentInfosSnapshot.getUserData();
        userData.put("local_checkpoint", String.valueOf(maxSeqNo));
        userData.put("max_seq_no", Long.toString(maxSeqNo));
        segmentInfosSnapshot.setUserData(userData, false);
        Translog.TranslogGeneration translogGeneration = ((InternalEngine)this.indexShard.getEngine()).translogManager().getTranslogGeneration();
        if (translogGeneration == null) {
            throw new UnsupportedOperationException("Encountered null TranslogGeneration while uploading metadata to remote segment store");
        }
        long translogFileGeneration = translogGeneration.translogFileGeneration;
        this.remoteDirectory.uploadMetadata(localSegmentsPostRefresh, segmentInfosSnapshot, this.storeDirectory, this.indexShard.getOperationPrimaryTerm(), translogFileGeneration);
    }

    private boolean uploadNewSegments(Collection<String> localSegmentsPostRefresh) throws IOException {
        AtomicBoolean uploadSuccess = new AtomicBoolean(true);
        localSegmentsPostRefresh.forEach(file -> {
            try {
                this.fileUploader.uploadFile((String)file);
            }
            catch (IOException e) {
                uploadSuccess.set(false);
                this.logger.warn(() -> new ParameterizedMessage("Exception while uploading file {} to the remote segment store", file), (Throwable)e);
            }
        });
        return uploadSuccess.get();
    }

    private String getChecksumOfLocalFile(String file) throws IOException {
        if (!this.localSegmentChecksumMap.containsKey(file)) {
            try (IndexInput indexInput = this.storeDirectory.openInput(file, IOContext.DEFAULT);){
                String checksum = Long.toString(CodecUtil.retrieveChecksum(indexInput));
                this.localSegmentChecksumMap.put(file, checksum);
            }
        }
        return this.localSegmentChecksumMap.get(file);
    }

    private void updateLocalRefreshTimeAndSeqNo() {
        this.segmentTracker.updateLocalRefreshClockTimeMs(System.currentTimeMillis());
        this.segmentTracker.updateLocalRefreshTimeMs(System.nanoTime() / 1000000L);
        this.segmentTracker.updateLocalRefreshSeqNo(this.segmentTracker.getLocalRefreshSeqNo() + 1L);
    }

    private void updateRemoteRefreshTimeAndSeqNo(long refreshTimeMs, long refreshClockTimeMs, long refreshSeqNo) {
        this.segmentTracker.updateRemoteRefreshClockTimeMs(refreshClockTimeMs);
        this.segmentTracker.updateRemoteRefreshTimeMs(refreshTimeMs);
        this.segmentTracker.updateRemoteRefreshSeqNo(refreshSeqNo);
    }

    private void updateLocalSizeMapAndTracker(Collection<String> segmentFiles) {
        segmentFiles.stream().filter(file -> !EXCLUDE_FILES.contains(file)).filter(file -> !this.latestFileNameSizeOnLocalMap.containsKey(file) || this.latestFileNameSizeOnLocalMap.get(file) == 0L).forEach(file -> {
            long fileSize = 0L;
            try {
                fileSize = this.storeDirectory.fileLength((String)file);
            }
            catch (IOException e) {
                this.logger.warn((Message)new ParameterizedMessage("Exception while reading the fileLength of file={}", file), (Throwable)e);
            }
            this.latestFileNameSizeOnLocalMap.put((String)file, fileSize);
        });
        HashSet<String> fileSet = new HashSet<String>(segmentFiles);
        this.latestFileNameSizeOnLocalMap.entrySet().removeIf(entry -> !fileSet.contains(entry.getKey()));
        this.segmentTracker.setLatestLocalFileNameLengthMap(this.latestFileNameSizeOnLocalMap);
    }

    private void updateFinalUploadStatusInSegmentTracker(boolean uploadStatus, long bytesBeforeUpload, long startTimeInNS) {
        if (uploadStatus) {
            long bytesUploaded = this.segmentTracker.getUploadBytesSucceeded() - bytesBeforeUpload;
            long timeTakenInMS = (System.nanoTime() - startTimeInNS) / 1000000L;
            this.segmentTracker.incrementTotalUploadsSucceeded();
            this.segmentTracker.addUploadBytes(bytesUploaded);
            this.segmentTracker.addUploadBytesPerSec(bytesUploaded * 1000L / timeTakenInMS);
            this.segmentTracker.addUploadTimeMs(timeTakenInMS);
        } else {
            this.segmentTracker.incrementTotalUploadsFailed();
        }
    }

    private static class FileUploader {
        private final Logger logger;
        private final UploadTracker uploadTracker;
        private final RemoteSegmentStoreDirectory remoteDirectory;
        private final Directory storeDirectory;
        private final CheckedFunction<String, String, IOException> checksumProvider;

        public FileUploader(UploadTracker uploadTracker, RemoteSegmentStoreDirectory remoteDirectory, Directory storeDirectory, CheckedFunction<String, String, IOException> checksumProvider, Logger logger) {
            this.uploadTracker = uploadTracker;
            this.remoteDirectory = remoteDirectory;
            this.storeDirectory = storeDirectory;
            this.checksumProvider = checksumProvider;
            this.logger = logger;
        }

        private void uploadFile(String file) throws IOException {
            if (this.skipUpload(file)) {
                return;
            }
            this.uploadTracker.beforeUpload(file);
            boolean success = false;
            try {
                this.performUpload(file);
                this.uploadTracker.onSuccess(file);
                success = true;
            }
            finally {
                if (!success) {
                    this.uploadTracker.onFailure(file);
                }
            }
        }

        private boolean skipUpload(String file) {
            try {
                return EXCLUDE_FILES.contains(file) || this.remoteDirectory.containsFile(file, this.checksumProvider.apply(file));
            }
            catch (IOException e) {
                this.logger.error("Exception while reading checksum of local segment file: {}, ignoring the exception and re-uploading the file", (Object)file);
                return false;
            }
        }

        private void performUpload(String file) throws IOException {
            this.remoteDirectory.copyFrom(this.storeDirectory, file, file, IOContext.DEFAULT);
        }
    }

    static interface UploadTracker {
        public void beforeUpload(String var1);

        public void onSuccess(String var1);

        public void onFailure(String var1);
    }
}

