/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.OutputStreamIndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobContainer;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.BytesStreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteIndexOutput;

public class RemoteBufferedIndexOutput
extends RemoteIndexOutput {
    private final BytesStreamOutput out;
    private final OutputStreamIndexOutput indexOutputBuffer;
    static final int BUFFER_SIZE = 4096;

    public RemoteBufferedIndexOutput(String name, BlobContainer blobContainer, int bufferSize) {
        super(name, blobContainer);
        this.out = new BytesStreamOutput();
        this.indexOutputBuffer = new OutputStreamIndexOutput(name, name, this.out, bufferSize);
    }

    public RemoteBufferedIndexOutput(String name, BlobContainer blobContainer) {
        this(name, blobContainer, 4096);
    }

    RemoteBufferedIndexOutput(String name, BlobContainer blobContainer, BytesStreamOutput out, OutputStreamIndexOutput indexOutputBuffer) {
        super(name, blobContainer);
        this.out = out;
        this.indexOutputBuffer = indexOutputBuffer;
    }

    @Override
    public void copyBytes(DataInput input, long numBytes) throws IOException {
        this.indexOutputBuffer.copyBytes(input, numBytes);
    }

    @Override
    public void close() throws IOException {
        try (BytesStreamOutput outStream = this.out;
             StreamInput stream = this.out.bytes().streamInput();){
            this.indexOutputBuffer.close();
            this.blobContainer.writeBlob(this.getName(), stream, this.out.bytes().length(), false);
        }
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.indexOutputBuffer.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] byteArray, int offset, int length) throws IOException {
        this.indexOutputBuffer.writeBytes(byteArray, offset, length);
    }

    @Override
    public long getFilePointer() {
        return this.indexOutputBuffer.getFilePointer();
    }

    @Override
    public long getChecksum() throws IOException {
        return this.indexOutputBuffer.getChecksum();
    }
}

