/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersDataOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersIndexOutput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.VersionedCodecStreamWrapper;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.store.ByteArrayIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.remote.RemoteStoreUtils;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.FileLockInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreCommitLevelLockManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreLockManager;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.metadata.RemoteSegmentMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.metadata.RemoteSegmentMetadataHandler;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public final class RemoteSegmentStoreDirectory
extends FilterDirectory
implements RemoteStoreCommitLevelLockManager {
    public static final String SEGMENT_NAME_UUID_SEPARATOR = "__";
    private final RemoteDirectory remoteDataDirectory;
    private final RemoteDirectory remoteMetadataDirectory;
    private final RemoteStoreLockManager mdLockManager;
    private final ThreadPool threadPool;
    private Map<String, UploadedSegmentMetadata> segmentsUploadedToRemoteStore;
    private static final VersionedCodecStreamWrapper<RemoteSegmentMetadata> metadataStreamWrapper = new VersionedCodecStreamWrapper<RemoteSegmentMetadata>(new RemoteSegmentMetadataHandler(), 1, "segment_md");
    private static final Logger logger = LogManager.getLogger(RemoteSegmentStoreDirectory.class);
    protected final AtomicBoolean canDeleteStaleCommits = new AtomicBoolean(true);
    private final AtomicLong metadataUploadCounter = new AtomicLong(0L);

    public RemoteSegmentStoreDirectory(RemoteDirectory remoteDataDirectory, RemoteDirectory remoteMetadataDirectory, RemoteStoreLockManager mdLockManager, ThreadPool threadPool) throws IOException {
        super(remoteDataDirectory);
        this.remoteDataDirectory = remoteDataDirectory;
        this.remoteMetadataDirectory = remoteMetadataDirectory;
        this.mdLockManager = mdLockManager;
        this.threadPool = threadPool;
        this.init();
    }

    public RemoteSegmentMetadata init() throws IOException {
        RemoteSegmentMetadata remoteSegmentMetadata = this.readLatestMetadataFile();
        this.segmentsUploadedToRemoteStore = remoteSegmentMetadata != null ? new ConcurrentHashMap<String, UploadedSegmentMetadata>(remoteSegmentMetadata.getMetadata()) : new ConcurrentHashMap<String, UploadedSegmentMetadata>();
        return remoteSegmentMetadata;
    }

    public RemoteSegmentMetadata initializeToSpecificCommit(long primaryTerm, long commitGeneration) throws IOException {
        String metadataFile = this.getMetadataFileForCommit(primaryTerm, commitGeneration);
        RemoteSegmentMetadata remoteSegmentMetadata = this.readMetadataFile(metadataFile);
        this.segmentsUploadedToRemoteStore = remoteSegmentMetadata != null ? new ConcurrentHashMap<String, UploadedSegmentMetadata>(remoteSegmentMetadata.getMetadata()) : new ConcurrentHashMap<String, UploadedSegmentMetadata>();
        return remoteSegmentMetadata;
    }

    public RemoteSegmentMetadata readLatestMetadataFile() throws IOException {
        RemoteSegmentMetadata remoteSegmentMetadata = null;
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", 1);
        if (!metadataFiles.isEmpty()) {
            String latestMetadataFile = metadataFiles.get(0);
            logger.info("Reading latest Metadata file {}", (Object)latestMetadataFile);
            remoteSegmentMetadata = this.readMetadataFile(latestMetadataFile);
        } else {
            logger.info("No metadata file found, this can happen for new index with no data uploaded to remote segment store");
        }
        return remoteSegmentMetadata;
    }

    private RemoteSegmentMetadata readMetadataFile(String metadataFilename) throws IOException {
        try (IndexInput indexInput = this.remoteMetadataDirectory.openInput(metadataFilename, IOContext.DEFAULT);){
            byte[] metadataBytes = new byte[(int)indexInput.length()];
            indexInput.readBytes(metadataBytes, 0, (int)indexInput.length());
            RemoteSegmentMetadata remoteSegmentMetadata = metadataStreamWrapper.readStream(new ByteArrayIndexInput(metadataFilename, metadataBytes));
            return remoteSegmentMetadata;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        return this.readLatestMetadataFile().getMetadata().keySet().toArray(new String[0]);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        String remoteFilename = this.getExistingRemoteFilename(name);
        if (remoteFilename != null) {
            this.remoteDataDirectory.deleteFile(remoteFilename);
            this.segmentsUploadedToRemoteStore.remove(name);
        }
    }

    @Override
    public long fileLength(String name) throws IOException {
        if (this.segmentsUploadedToRemoteStore.containsKey(name)) {
            return this.segmentsUploadedToRemoteStore.get(name).getLength();
        }
        String remoteFilename = this.getExistingRemoteFilename(name);
        if (remoteFilename != null) {
            return this.remoteDataDirectory.fileLength(remoteFilename);
        }
        throw new NoSuchFileException(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.remoteDataDirectory.createOutput(this.getNewRemoteSegmentFilename(name), context);
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        String remoteFilename = this.getExistingRemoteFilename(name);
        if (remoteFilename != null) {
            return this.remoteDataDirectory.openInput(remoteFilename, context);
        }
        throw new NoSuchFileException(name);
    }

    @Override
    public void acquireLock(long primaryTerm, long generation, String acquirerId) throws IOException {
        String metadataFile = this.getMetadataFileForCommit(primaryTerm, generation);
        this.mdLockManager.acquire(FileLockInfo.getLockInfoBuilder().withFileToLock(metadataFile).withAcquirerId(acquirerId).build());
    }

    @Override
    public void releaseLock(long primaryTerm, long generation, String acquirerId) throws IOException {
        String metadataFile = this.getMetadataFileForCommit(primaryTerm, generation);
        this.mdLockManager.release(FileLockInfo.getLockInfoBuilder().withFileToLock(metadataFile).withAcquirerId(acquirerId).build());
    }

    @Override
    public Boolean isLockAcquired(long primaryTerm, long generation) throws IOException {
        String metadataFile = this.getMetadataFileForCommit(primaryTerm, generation);
        return this.isLockAcquired(metadataFile);
    }

    Boolean isLockAcquired(String metadataFile) throws IOException {
        return this.mdLockManager.isAcquired(FileLockInfo.getLockInfoBuilder().withFileToLock(metadataFile).build());
    }

    String getMetadataFileForCommit(long primaryTerm, long generation) throws IOException {
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder(MetadataFilenameUtils.getMetadataFilePrefixForCommit(primaryTerm, generation), 1);
        if (metadataFiles.isEmpty()) {
            throw new NoSuchFileException("Metadata file is not present for given primary term " + primaryTerm + " and generation " + generation);
        }
        if (metadataFiles.size() != 1) {
            throw new IllegalStateException("there should be only one metadata file for given primary term " + primaryTerm + "and generation " + generation + " but found " + metadataFiles.size());
        }
        return metadataFiles.get(0);
    }

    public void copyFrom(Directory from, String src, String dest, IOContext context, String checksum) throws IOException {
        String remoteFilename = this.getNewRemoteSegmentFilename(dest);
        this.remoteDataDirectory.copyFrom(from, src, remoteFilename, context);
        UploadedSegmentMetadata segmentMetadata = new UploadedSegmentMetadata(src, remoteFilename, checksum, from.fileLength(src));
        this.segmentsUploadedToRemoteStore.put(src, segmentMetadata);
    }

    @Override
    public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
        this.copyFrom(from, src, dest, context, this.getChecksumOfLocalFile(from, src));
    }

    public boolean containsFile(String localFilename, String checksum) {
        return this.segmentsUploadedToRemoteStore.containsKey(localFilename) && this.segmentsUploadedToRemoteStore.get((Object)localFilename).checksum.equals(checksum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadMetadata(Collection<String> segmentFiles, SegmentInfos segmentInfosSnapshot, Directory storeDirectory, long primaryTerm, long translogGeneration) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory = this;
        synchronized (remoteSegmentStoreDirectory) {
            String metadataFilename = MetadataFilenameUtils.getMetadataFilename(primaryTerm, segmentInfosSnapshot.getGeneration(), translogGeneration, this.metadataUploadCounter.incrementAndGet(), 1);
            try {
                try (IndexOutput indexOutput = storeDirectory.createOutput(metadataFilename, IOContext.DEFAULT);){
                    HashMap<String, String> uploadedSegments = new HashMap<String, String>();
                    for (String file : segmentFiles) {
                        if (this.segmentsUploadedToRemoteStore.containsKey(file)) {
                            uploadedSegments.put(file, this.segmentsUploadedToRemoteStore.get(file).toString());
                            continue;
                        }
                        throw new NoSuchFileException(file);
                    }
                    ByteBuffersDataOutput byteBuffersIndexOutput = new ByteBuffersDataOutput();
                    segmentInfosSnapshot.write(new ByteBuffersIndexOutput(byteBuffersIndexOutput, "Snapshot of SegmentInfos", "SegmentInfos"));
                    byte[] segmentInfoSnapshotByteArray = byteBuffersIndexOutput.toArrayCopy();
                    metadataStreamWrapper.writeStream(indexOutput, new RemoteSegmentMetadata(RemoteSegmentMetadata.fromMapOfStrings(uploadedSegments), segmentInfoSnapshotByteArray, primaryTerm, segmentInfosSnapshot.getGeneration()));
                }
                storeDirectory.sync(Collections.singleton(metadataFilename));
                this.remoteMetadataDirectory.copyFrom(storeDirectory, metadataFilename, metadataFilename, IOContext.DEFAULT);
            }
            finally {
                this.tryAndDeleteLocalFile(metadataFilename, storeDirectory);
            }
        }
    }

    private void tryAndDeleteLocalFile(String filename, Directory directory) {
        try {
            logger.trace("Deleting file: " + filename);
            directory.deleteFile(filename);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            logger.trace("Exception while deleting. Missing file : " + filename, (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("Exception while deleting: " + filename, (Throwable)e);
        }
    }

    private String getChecksumOfLocalFile(Directory directory, String file) throws IOException {
        try (IndexInput indexInput = directory.openInput(file, IOContext.DEFAULT);){
            String string = Long.toString(CodecUtil.retrieveChecksum(indexInput));
            return string;
        }
    }

    private String getExistingRemoteFilename(String localFilename) {
        if (this.segmentsUploadedToRemoteStore.containsKey(localFilename)) {
            return this.segmentsUploadedToRemoteStore.get((Object)localFilename).uploadedFilename;
        }
        return null;
    }

    private String getNewRemoteSegmentFilename(String localFilename) {
        return localFilename + SEGMENT_NAME_UUID_SEPARATOR + UUIDs.base64UUID();
    }

    private String getLocalSegmentFilename(String remoteFilename) {
        return remoteFilename.split(SEGMENT_NAME_UUID_SEPARATOR)[0];
    }

    public Map<String, UploadedSegmentMetadata> getSegmentsUploadedToRemoteStore() {
        return Collections.unmodifiableMap(this.segmentsUploadedToRemoteStore);
    }

    public void deleteStaleSegments(int lastNMetadataFilesToKeep) throws IOException {
        List<String> sortedMetadataFileList = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", Integer.MAX_VALUE);
        if (sortedMetadataFileList.size() <= lastNMetadataFilesToKeep) {
            logger.info("Number of commits in remote segment store={}, lastNMetadataFilesToKeep={}", (Object)sortedMetadataFileList.size(), (Object)lastNMetadataFilesToKeep);
            return;
        }
        List<String> metadataFilesEligibleToDelete = sortedMetadataFileList.subList(lastNMetadataFilesToKeep, sortedMetadataFileList.size());
        List metadataFilesToBeDeleted = metadataFilesEligibleToDelete.stream().filter(metadataFile -> {
            try {
                return this.isLockAcquired((String)metadataFile) == false;
            }
            catch (IOException e) {
                logger.error("skipping metadata file (" + metadataFile + ") deletion for this run, as checking lock for metadata is failing with error: " + e);
                return false;
            }
        }).collect(Collectors.toList());
        sortedMetadataFileList.removeAll(metadataFilesToBeDeleted);
        HashMap<String, UploadedSegmentMetadata> activeSegmentFilesMetadataMap = new HashMap<String, UploadedSegmentMetadata>();
        HashSet activeSegmentRemoteFilenames = new HashSet();
        for (String metadataFile2 : sortedMetadataFileList) {
            Map<String, UploadedSegmentMetadata> segmentMetadataMap = this.readMetadataFile(metadataFile2).getMetadata();
            activeSegmentFilesMetadataMap.putAll(segmentMetadataMap);
            activeSegmentRemoteFilenames.addAll(segmentMetadataMap.values().stream().map(metadata -> metadata.uploadedFilename).collect(Collectors.toSet()));
        }
        for (String metadataFile2 : metadataFilesToBeDeleted) {
            Map<String, UploadedSegmentMetadata> staleSegmentFilesMetadataMap = this.readMetadataFile(metadataFile2).getMetadata();
            Set staleSegmentRemoteFilenames = staleSegmentFilesMetadataMap.values().stream().map(metadata -> metadata.uploadedFilename).collect(Collectors.toSet());
            AtomicBoolean deletionSuccessful = new AtomicBoolean(true);
            staleSegmentRemoteFilenames.stream().filter(file -> !activeSegmentRemoteFilenames.contains(file)).forEach(file -> {
                try {
                    this.remoteDataDirectory.deleteFile((String)file);
                    if (!activeSegmentFilesMetadataMap.containsKey(this.getLocalSegmentFilename((String)file))) {
                        this.segmentsUploadedToRemoteStore.remove(this.getLocalSegmentFilename((String)file));
                    }
                }
                catch (NoSuchFileException e) {
                    logger.info("Segment file {} corresponding to metadata file {} does not exist in remote", file, (Object)metadataFile2);
                }
                catch (IOException e) {
                    deletionSuccessful.set(false);
                    logger.info("Exception while deleting segment file {} corresponding to metadata file {}. Deletion will be re-tried", file, (Object)metadataFile2);
                }
            });
            if (!deletionSuccessful.get()) continue;
            logger.info("Deleting stale metadata file {} from remote segment store", (Object)metadataFile2);
            this.remoteMetadataDirectory.deleteFile(metadataFile2);
        }
    }

    public void deleteStaleSegmentsAsync(int lastNMetadataFilesToKeep) {
        if (this.canDeleteStaleCommits.compareAndSet(true, false)) {
            try {
                this.threadPool.executor("remote_purge").execute(() -> {
                    try {
                        this.deleteStaleSegments(lastNMetadataFilesToKeep);
                    }
                    catch (Exception e) {
                        logger.info("Exception while deleting stale commits from remote segment store, will retry delete post next commit", (Throwable)e);
                    }
                    finally {
                        this.canDeleteStaleCommits.set(true);
                    }
                });
            }
            catch (Exception e) {
                logger.info("Exception occurred while scheduling deleteStaleCommits", (Throwable)e);
                this.canDeleteStaleCommits.set(true);
            }
        }
    }

    private boolean deleteIfEmpty() throws IOException {
        List<String> metadataFiles = this.remoteMetadataDirectory.listFilesByPrefixInLexicographicOrder("metadata", 1);
        if (metadataFiles.size() != 0) {
            logger.info("Remote directory still has files , not deleting the path");
            return false;
        }
        try {
            this.remoteDataDirectory.delete();
            this.remoteMetadataDirectory.delete();
            this.mdLockManager.delete();
        }
        catch (Exception e) {
            logger.error("Exception occurred while deleting directory", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.deleteStaleSegmentsAsync(0);
        this.deleteIfEmpty();
    }

    static class MetadataFilenameUtils {
        public static final String SEPARATOR = "__";
        public static final String METADATA_PREFIX = "metadata";

        MetadataFilenameUtils() {
        }

        static String getMetadataFilePrefixForCommit(long primaryTerm, long generation) {
            return String.join((CharSequence)"__", METADATA_PREFIX, RemoteStoreUtils.invertLong(primaryTerm), RemoteStoreUtils.invertLong(generation));
        }

        static String getMetadataFilename(long primaryTerm, long generation, long translogGeneration, long uploadCounter, int metadataVersion) {
            return String.join((CharSequence)"__", METADATA_PREFIX, RemoteStoreUtils.invertLong(primaryTerm), RemoteStoreUtils.invertLong(generation), RemoteStoreUtils.invertLong(translogGeneration), RemoteStoreUtils.invertLong(uploadCounter), RemoteStoreUtils.invertLong(System.currentTimeMillis()), String.valueOf(metadataVersion));
        }

        static long getPrimaryTerm(String[] filenameTokens) {
            return RemoteStoreUtils.invertLong(filenameTokens[1]);
        }

        static long getGeneration(String[] filenameTokens) {
            return RemoteStoreUtils.invertLong(filenameTokens[2]);
        }
    }

    public static class UploadedSegmentMetadata {
        static final String SEPARATOR = "::";
        private final String originalFilename;
        private final String uploadedFilename;
        private final String checksum;
        private final long length;

        UploadedSegmentMetadata(String originalFilename, String uploadedFilename, String checksum, long length) {
            this.originalFilename = originalFilename;
            this.uploadedFilename = uploadedFilename;
            this.checksum = checksum;
            this.length = length;
        }

        public String toString() {
            return String.join((CharSequence)SEPARATOR, this.originalFilename, this.uploadedFilename, this.checksum, String.valueOf(this.length));
        }

        public String getChecksum() {
            return this.checksum;
        }

        public long getLength() {
            return this.length;
        }

        public static UploadedSegmentMetadata fromString(String uploadedFilename) {
            String[] values = uploadedFilename.split(SEPARATOR);
            return new UploadedSegmentMetadata(values[0], values[1], values[2], Long.parseLong(values[3]));
        }

        public String getOriginalFilename() {
            return this.originalFilename;
        }
    }
}

