/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager;

import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.LockInfo;

public class FileLockInfo
implements LockInfo {
    private String fileToLock;
    private String acquirerId;

    public String getAcquirerId() {
        return this.acquirerId;
    }

    public String getFileToLock() {
        return this.fileToLock;
    }

    private void setFileToLock(String fileName) {
        this.fileToLock = fileName;
    }

    private void setAcquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
    }

    @Override
    public String generateLockName() {
        FileLockInfo.validateRequiredParameters(this);
        return LockFileUtils.generateLockName(this.fileToLock, this.acquirerId);
    }

    String getLockPrefix() {
        if (this.fileToLock == null || this.fileToLock.isBlank()) {
            throw new IllegalArgumentException("File to Lock should be provided");
        }
        return this.fileToLock + "___";
    }

    String getLockForAcquirer(String[] lockFiles) throws NoSuchFileException {
        if (this.acquirerId == null || this.acquirerId.isBlank()) {
            throw new IllegalArgumentException("Acquirer ID should be provided");
        }
        List locksForAcquirer = Arrays.stream(lockFiles).filter(lockFile -> this.acquirerId.equals(LockFileUtils.getAcquirerIdFromLock(lockFile))).collect(Collectors.toList());
        if (locksForAcquirer.isEmpty()) {
            throw new NoSuchFileException("No lock file found for the acquirer: " + this.acquirerId);
        }
        if (locksForAcquirer.size() != 1) {
            throw new IllegalStateException("Expected single lock file but found [" + locksForAcquirer.size() + "] lock files");
        }
        return (String)locksForAcquirer.get(0);
    }

    public static LockInfoBuilder getLockInfoBuilder() {
        return new LockInfoBuilder();
    }

    private static void validateRequiredParameters(FileLockInfo fileLockInfo) {
        if (fileLockInfo.getAcquirerId() == null || fileLockInfo.getAcquirerId().isBlank()) {
            throw new IllegalArgumentException("Acquirer ID should be provided");
        }
        if (fileLockInfo.getFileToLock() == null || fileLockInfo.getFileToLock().isBlank()) {
            throw new IllegalArgumentException("File to Lock should be provided");
        }
    }

    static class LockFileUtils {
        LockFileUtils() {
        }

        static String generateLockName(String fileToLock, String acquirerId) {
            return String.join((CharSequence)"___", fileToLock, acquirerId) + ".lock";
        }

        public static String getFileToLockNameFromLock(String lockName) {
            String[] lockNameTokens = lockName.split("___");
            if (lockNameTokens.length != 2) {
                throw new IllegalArgumentException("Provided Lock Name " + lockName + " is not Valid.");
            }
            return lockNameTokens[0];
        }

        public static String getAcquirerIdFromLock(String lockName) {
            String[] lockNameTokens = lockName.split("___");
            if (lockNameTokens.length != 2) {
                throw new IllegalArgumentException("Provided Lock Name " + lockName + " is not Valid.");
            }
            return lockNameTokens[1].replace(".lock", "");
        }
    }

    public static class LockInfoBuilder
    implements LockInfo.LockInfoBuilder {
        private final FileLockInfo lockFileInfo = new FileLockInfo();

        LockInfoBuilder() {
        }

        public LockInfoBuilder withFileToLock(String fileToLock) {
            this.lockFileInfo.setFileToLock(fileToLock);
            return this;
        }

        public LockInfoBuilder withAcquirerId(String acquirerId) {
            this.lockFileInfo.setAcquirerId(acquirerId);
            return this;
        }

        @Override
        public FileLockInfo build() {
            if (this.lockFileInfo.fileToLock == null && this.lockFileInfo.acquirerId == null) {
                throw new IllegalStateException("Either File to Lock or AcquirerId should be provided to instantiate FileLockInfo");
            }
            return this.lockFileInfo;
        }
    }
}

