/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteBufferedOutputDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.FileLockInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.LockInfo;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.lockmanager.RemoteStoreLockManager;

public class RemoteStoreMetadataLockManager
implements RemoteStoreLockManager {
    private static final Logger logger = LogManager.getLogger(RemoteStoreMetadataLockManager.class);
    private final RemoteBufferedOutputDirectory lockDirectory;

    public RemoteStoreMetadataLockManager(RemoteBufferedOutputDirectory lockDirectory) {
        this.lockDirectory = lockDirectory;
    }

    @Override
    public void acquire(LockInfo lockInfo) throws IOException {
        assert (lockInfo instanceof FileLockInfo) : "lockInfo should be instance of FileLockInfo";
        IndexOutput indexOutput = this.lockDirectory.createOutput(lockInfo.generateLockName(), IOContext.DEFAULT);
        indexOutput.close();
    }

    @Override
    public void release(LockInfo lockInfo) throws IOException {
        assert (lockInfo instanceof FileLockInfo) : "lockInfo should be instance of FileLockInfo";
        String[] lockFiles = this.lockDirectory.listAll();
        try {
            String lockToRelease = ((FileLockInfo)lockInfo).getLockForAcquirer(lockFiles);
            this.lockDirectory.deleteFile(lockToRelease);
        }
        catch (NoSuchFileException e) {
            logger.info("No lock file found for acquirerId: {}", (Object)((FileLockInfo)lockInfo).getAcquirerId());
        }
    }

    @Override
    public Boolean isAcquired(LockInfo lockInfo) throws IOException {
        assert (lockInfo instanceof FileLockInfo) : "lockInfo should be instance of FileLockInfo";
        Collection<String> lockFiles = this.lockDirectory.listFilesByPrefix(((FileLockInfo)lockInfo).getLockPrefix());
        return !lockFiles.isEmpty();
    }

    @Override
    public void cloneLock(LockInfo originalLockInfo, LockInfo clonedLockInfo) throws IOException {
        assert (originalLockInfo instanceof FileLockInfo) : "originalLockInfo should be instance of FileLockInfo";
        assert (clonedLockInfo instanceof FileLockInfo) : "clonedLockInfo should be instance of FileLockInfo";
        String originalResourceId = Objects.requireNonNull(((FileLockInfo)originalLockInfo).getAcquirerId());
        String clonedResourceId = Objects.requireNonNull(((FileLockInfo)clonedLockInfo).getAcquirerId());
        assert (originalResourceId != null && clonedResourceId != null) : "provided resourceIds should not be null";
        String[] lockFiles = this.lockDirectory.listAll();
        String lockNameForAcquirer = ((FileLockInfo)originalLockInfo).getLockForAcquirer(lockFiles);
        String fileToLockName = FileLockInfo.LockFileUtils.getFileToLockNameFromLock(lockNameForAcquirer);
        this.acquire(FileLockInfo.getLockInfoBuilder().withFileToLock(fileToLockName).withAcquirerId(clonedResourceId).build());
    }

    @Override
    public void delete() throws IOException {
        this.lockDirectory.delete();
    }
}

