/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache;

import java.nio.file.Files;
import java.nio.file.Path;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.common.breaker.CircuitBreaker;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalReason;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.CachedIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.filecache.FileCache;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.utils.cache.SegmentedCache;

public class FileCacheFactory {
    public static FileCache createConcurrentLRUFileCache(long capacity, CircuitBreaker circuitBreaker) {
        return new FileCache(FileCacheFactory.createDefaultBuilder().capacity(capacity).build(), circuitBreaker);
    }

    public static FileCache createConcurrentLRUFileCache(long capacity, int concurrencyLevel, CircuitBreaker circuitBreaker) {
        return new FileCache(FileCacheFactory.createDefaultBuilder().capacity(capacity).concurrencyLevel(concurrencyLevel).build(), circuitBreaker);
    }

    private static SegmentedCache.Builder<Path, CachedIndexInput> createDefaultBuilder() {
        return SegmentedCache.builder().weigher(CachedIndexInput::length).listener(removalNotification -> {
            RemovalReason removalReason = removalNotification.getRemovalReason();
            CachedIndexInput value = (CachedIndexInput)removalNotification.getValue();
            Path key = (Path)removalNotification.getKey();
            if (removalReason != RemovalReason.REPLACED) {
                ExceptionsHelper.catchAsRuntimeException(value::close);
                ExceptionsHelper.catchAsRuntimeException(() -> Files.deleteIfExists(key));
            }
        });
    }
}

