/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.store.remote.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteSegmentStoreDirectory;

public class RemoteSegmentMetadata {
    public static final int CURRENT_VERSION = 1;
    public static final String METADATA_CODEC = "segment_md";
    private final Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> metadata;
    private final byte[] segmentInfosBytes;
    private final long primaryTerm;
    private final long generation;

    public RemoteSegmentMetadata(Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> metadata, byte[] segmentInfosBytes, long primaryTerm, long generation) {
        this.metadata = metadata;
        this.segmentInfosBytes = segmentInfosBytes;
        this.generation = generation;
        this.primaryTerm = primaryTerm;
    }

    public Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> getMetadata() {
        return this.metadata;
    }

    public byte[] getSegmentInfosBytes() {
        return this.segmentInfosBytes;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public Map<String, String> toMapOfStrings() {
        return this.metadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)entry.getValue()).toString()));
    }

    public static Map<String, RemoteSegmentStoreDirectory.UploadedSegmentMetadata> fromMapOfStrings(Map<String, String> segmentMetadata) {
        return segmentMetadata.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> RemoteSegmentStoreDirectory.UploadedSegmentMetadata.fromString((String)entry.getValue())));
    }

    public void write(IndexOutput out) throws IOException {
        out.writeMapOfStrings(this.toMapOfStrings());
        out.writeLong(this.generation);
        out.writeLong(this.primaryTerm);
        out.writeLong(this.segmentInfosBytes.length);
        out.writeBytes(this.segmentInfosBytes, this.segmentInfosBytes.length);
    }

    public static RemoteSegmentMetadata read(IndexInput indexInput) throws IOException {
        Map<String, String> metadata = indexInput.readMapOfStrings();
        long generation = indexInput.readLong();
        long primaryTerm = indexInput.readLong();
        int byteArraySize = (int)indexInput.readLong();
        byte[] segmentInfosBytes = new byte[byteArraySize];
        indexInput.readBytes(segmentInfosBytes, 0, byteArraySize);
        return new RemoteSegmentMetadata(RemoteSegmentMetadata.fromMapOfStrings(metadata), segmentInfosBytes, primaryTerm, generation);
    }
}

