/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.FileSnapshot;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.listener.FileTransferListener;

public class FileTransferTracker
implements FileTransferListener {
    private final ConcurrentHashMap<String, TransferState> fileTransferTracker;
    private final ShardId shardId;

    public FileTransferTracker(ShardId shardId) {
        this.shardId = shardId;
        this.fileTransferTracker = new ConcurrentHashMap();
    }

    @Override
    public void onSuccess(FileSnapshot.TransferFileSnapshot fileSnapshot) {
        this.add(fileSnapshot.getName(), TransferState.SUCCESS);
    }

    void add(String file, boolean success) {
        TransferState targetState = success ? TransferState.SUCCESS : TransferState.FAILED;
        this.add(file, targetState);
    }

    private void add(String file, TransferState targetState) {
        this.fileTransferTracker.compute(file, (k, v) -> {
            if (v == null || v.validateNextState(targetState)) {
                return targetState;
            }
            throw new IllegalStateException("Unexpected transfer state " + v + "while setting target to" + targetState);
        });
    }

    @Override
    public void onFailure(FileSnapshot.TransferFileSnapshot fileSnapshot, Exception e) {
        this.add(fileSnapshot.getName(), TransferState.FAILED);
    }

    public void delete(List<String> names) {
        for (String name : names) {
            this.fileTransferTracker.remove(name);
        }
    }

    public boolean uploaded(String file) {
        return this.fileTransferTracker.get(file) == TransferState.SUCCESS;
    }

    public Set<FileSnapshot.TransferFileSnapshot> exclusionFilter(Set<FileSnapshot.TransferFileSnapshot> original) {
        return original.stream().filter(fileSnapshot -> this.fileTransferTracker.get(fileSnapshot.getName()) != TransferState.SUCCESS).collect(Collectors.toSet());
    }

    public Set<String> allUploaded() {
        HashSet<String> successFileTransferTracker = new HashSet<String>();
        this.fileTransferTracker.forEach((k, v) -> {
            if (v == TransferState.SUCCESS) {
                successFileTransferTracker.add((String)k);
            }
        });
        return successFileTransferTracker;
    }

    private static enum TransferState {
        SUCCESS,
        FAILED;


        public boolean validateNextState(TransferState target) {
            switch (this) {
                case FAILED: {
                    return true;
                }
                case SUCCESS: {
                    return Objects.equals((Object)SUCCESS, (Object)target);
                }
            }
            return false;
        }
    }
}

