/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.FilterDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.RemoteSegmentStoreDirectory;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.CheckpointInfoResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.PrimaryShardReplicationSource;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationSource;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;

public class RemoteStoreReplicationSource
implements SegmentReplicationSource {
    private static final Logger logger = LogManager.getLogger(PrimaryShardReplicationSource.class);
    private final IndexShard indexShard;

    public RemoteStoreReplicationSource(IndexShard indexShard) {
        this.indexShard = indexShard;
    }

    @Override
    public void getCheckpointMetadata(long replicationId, ReplicationCheckpoint checkpoint, ActionListener<CheckpointInfoResponse> listener) {
        FilterDirectory remoteStoreDirectory = (FilterDirectory)this.indexShard.remoteStore().directory();
        FilterDirectory byteSizeCachingStoreDirectory = (FilterDirectory)remoteStoreDirectory.getDelegate();
        RemoteSegmentStoreDirectory remoteDirectory = (RemoteSegmentStoreDirectory)byteSizeCachingStoreDirectory.getDelegate();
        Version version = this.indexShard.getSegmentInfosSnapshot().get().getCommitLuceneVersion();
        try {
            Map<String, StoreFileMetadata> metadataMap = remoteDirectory.readLatestMetadataFile().getMetadata().entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new StoreFileMetadata(((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getOriginalFilename(), ((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getLength(), Store.digestToString(Long.valueOf(((RemoteSegmentStoreDirectory.UploadedSegmentMetadata)e.getValue()).getChecksum())), version, null)));
            listener.onResponse(new CheckpointInfoResponse(checkpoint, metadataMap, null));
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }

    @Override
    public void getSegmentFiles(long replicationId, ReplicationCheckpoint checkpoint, List<StoreFileMetadata> filesToFetch, IndexShard indexShard, ActionListener<GetSegmentFilesResponse> listener) {
        try {
            indexShard.syncSegmentsFromRemoteSegmentStore(false, true, false);
            listener.onResponse(new GetSegmentFilesResponse(Collections.emptyList()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public String getDescription() {
        return "remote store";
    }
}

