/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFormatTooNewException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFormatTooOldException;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.BufferedChecksumIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersDataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ByteBuffersIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ChecksumIndexInput;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchCorruptionException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.StepListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.Lucene;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.CancellableThreads;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.Store;
import org.graylog.shaded.opensearch2.org.opensearch.index.store.StoreFileMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.indices.recovery.MultiFileWriter;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.CheckpointInfoResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.GetSegmentFilesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.RemoteStoreReplicationSource;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationSource;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.SegmentReplicationState;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationListener;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.ReplicationTarget;

public class SegmentReplicationTarget
extends ReplicationTarget {
    private final ReplicationCheckpoint checkpoint;
    private final SegmentReplicationSource source;
    private final SegmentReplicationState state;
    protected final MultiFileWriter multiFileWriter;
    public static final String REPLICATION_PREFIX = "replication.";

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public SegmentReplicationTarget(IndexShard indexShard, SegmentReplicationSource source, ReplicationListener listener) {
        super("replication_target", indexShard, new ReplicationLuceneIndex(), listener);
        this.checkpoint = indexShard.getLatestReplicationCheckpoint();
        this.source = source;
        this.state = new SegmentReplicationState(indexShard.routingEntry(), this.stateIndex, this.getId(), source.getDescription(), indexShard.recoveryState().getTargetNode());
        this.multiFileWriter = new MultiFileWriter(indexShard.store(), this.stateIndex, this.getPrefix(), this.logger, () -> this.ensureRefCount());
    }

    @Override
    protected void closeInternal() {
        try {
            this.multiFileWriter.close();
        }
        finally {
            super.closeInternal();
        }
    }

    @Override
    protected String getPrefix() {
        return REPLICATION_PREFIX + UUIDs.randomBase64UUID() + ".";
    }

    @Override
    protected void onDone() {
        this.state.setStage(SegmentReplicationState.Stage.DONE);
    }

    @Override
    public SegmentReplicationState state() {
        return this.state;
    }

    @Override
    public SegmentReplicationTarget retryCopy() {
        return new SegmentReplicationTarget(this.indexShard, this.source, this.listener);
    }

    @Override
    public String description() {
        return String.format(Locale.ROOT, "Id:[%d] Shard:[%s] Source:[%s]", this.getId(), this.shardId(), this.source.getDescription());
    }

    @Override
    public void notifyListener(ReplicationFailedException e, boolean sendShardFailure) {
        this.listener.onFailure(this.state(), e, sendShardFailure);
    }

    @Override
    public boolean reset(CancellableThreads newTargetCancellableThreads) throws IOException {
        return false;
    }

    @Override
    public void writeFileChunk(StoreFileMetadata metadata, long position, BytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        try {
            this.multiFileWriter.writeFileChunk(metadata, position, content, lastChunk);
            listener.onResponse(null);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void startReplication(ActionListener<Void> listener) {
        this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
            throw new CancellableThreads.ExecutionCancelledException("replication was canceled reason [" + reason + "]");
        });
        this.state.setStage(SegmentReplicationState.Stage.REPLICATING);
        StepListener<CheckpointInfoResponse> checkpointInfoListener = new StepListener<CheckpointInfoResponse>();
        StepListener<GetSegmentFilesResponse> getFilesListener = new StepListener<GetSegmentFilesResponse>();
        this.logger.trace((Message)new ParameterizedMessage("Starting Replication Target: {}", (Object)this.description()));
        this.state.setStage(SegmentReplicationState.Stage.GET_CHECKPOINT_INFO);
        this.cancellableThreads.checkForCancel();
        this.source.getCheckpointMetadata(this.getId(), this.checkpoint, checkpointInfoListener);
        checkpointInfoListener.whenComplete(checkpointInfo -> {
            List<StoreFileMetadata> filesToFetch = this.getFiles((CheckpointInfoResponse)checkpointInfo);
            this.state.setStage(SegmentReplicationState.Stage.GET_FILES);
            this.cancellableThreads.checkForCancel();
            this.source.getSegmentFiles(this.getId(), checkpointInfo.getCheckpoint(), filesToFetch, this.indexShard, getFilesListener);
        }, listener::onFailure);
        getFilesListener.whenComplete(response -> {
            this.finalizeReplication((CheckpointInfoResponse)checkpointInfoListener.result());
            listener.onResponse(null);
        }, listener::onFailure);
    }

    private List<StoreFileMetadata> getFiles(CheckpointInfoResponse checkpointInfo) throws IOException {
        this.cancellableThreads.checkForCancel();
        this.state.setStage(SegmentReplicationState.Stage.FILE_DIFF);
        Store.RecoveryDiff diff = Store.segmentReplicationDiff(checkpointInfo.getMetadataMap(), this.indexShard.getSegmentMetadataMap());
        this.logger.trace(() -> new ParameterizedMessage("Replication diff for checkpoint {} {}", (Object)checkpointInfo.getCheckpoint(), (Object)diff));
        if (!diff.different.isEmpty()) {
            throw new OpenSearchCorruptionException(new ParameterizedMessage("Shard {} has local copies of segments that differ from the primary {}", (Object)this.indexShard.shardId(), diff.different).getFormattedMessage());
        }
        for (StoreFileMetadata file : diff.missing) {
            this.state.getIndex().addFileDetail(file.name(), file.length(), false);
        }
        return diff.missing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeReplication(CheckpointInfoResponse checkpointInfoResponse) throws OpenSearchCorruptionException {
        if (this.source instanceof RemoteStoreReplicationSource) {
            this.state.setStage(SegmentReplicationState.Stage.FINALIZE_REPLICATION);
            return;
        }
        this.cancellableThreads.checkForCancel();
        this.state.setStage(SegmentReplicationState.Stage.FINALIZE_REPLICATION);
        Store store = null;
        try {
            store = this.store();
            store.incRef();
            store.buildInfosFromBytes(this.multiFileWriter.getTempFileNames(), checkpointInfoResponse.getInfosBytes(), checkpointInfoResponse.getCheckpoint().getSegmentsGen(), this.indexShard::finalizeReplication);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            try {
                try {
                    store.removeCorruptionMarker();
                }
                finally {
                    Lucene.cleanLuceneIndex(store.directory());
                }
            }
            catch (Exception e) {
                this.logger.debug("Failed to clean lucene index", (Throwable)e);
                ex.addSuppressed(e);
            }
            throw new OpenSearchCorruptionException(ex);
        }
        catch (AlreadyClosedException ex) {
            this.logger.warn("Shard is already closed, closing replication");
        }
        catch (OpenSearchException ex) {
            assert (this.cancellableThreads.isCancelled()) : "Replication target closed but segment replication not cancelled";
        }
        catch (Exception ex) {
            throw new OpenSearchCorruptionException(ex);
        }
        finally {
            if (store != null) {
                store.decRef();
            }
        }
    }

    private ChecksumIndexInput toIndexInput(byte[] input) {
        return new BufferedChecksumIndexInput(new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(ByteBuffer.wrap(input))), "SegmentInfos"));
    }

    @Override
    public void cancel(String reason) {
        if (!this.finished.get()) {
            this.logger.trace((Message)new ParameterizedMessage("Cancelling replication for target {}", (Object)this.description()));
            this.cancellableThreads.cancel(reason);
            this.source.cancel();
        }
    }
}

