/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.indices.replication;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.checkpoint.ReplicationCheckpoint;
import org.graylog.shaded.opensearch2.org.opensearch.indices.replication.common.SegmentReplicationTransportRequest;

public class UpdateVisibleCheckpointRequest
extends SegmentReplicationTransportRequest {
    private final ReplicationCheckpoint checkpoint;
    private final ShardId primaryShardId;

    public UpdateVisibleCheckpointRequest(StreamInput in) throws IOException {
        super(in);
        this.checkpoint = new ReplicationCheckpoint(in);
        this.primaryShardId = new ShardId(in);
    }

    public UpdateVisibleCheckpointRequest(long replicationId, String targetAllocationId, ShardId primaryShardId, DiscoveryNode targetNode, ReplicationCheckpoint checkpoint) {
        super(replicationId, targetAllocationId, targetNode);
        this.checkpoint = checkpoint;
        this.primaryShardId = primaryShardId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.checkpoint.writeTo(out);
        this.primaryShardId.writeTo(out);
    }

    public ReplicationCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public ShardId getPrimaryShardId() {
        return this.primaryShardId;
    }
}

