/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.OperationMetrics;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.OperationStats;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class IngestStats
implements Writeable,
ToXContentFragment {
    private final OperationStats totalStats;
    private final List<PipelineStat> pipelineStats;
    private final Map<String, List<ProcessorStat>> processorStats;

    public IngestStats(OperationStats totalStats, List<PipelineStat> pipelineStats, Map<String, List<ProcessorStat>> processorStats) {
        this.totalStats = totalStats;
        this.pipelineStats = pipelineStats;
        this.processorStats = processorStats;
    }

    public IngestStats(StreamInput in) throws IOException {
        this.totalStats = new OperationStats(in);
        int size = in.readVInt();
        this.pipelineStats = new ArrayList<PipelineStat>(size);
        this.processorStats = new HashMap<String, List<ProcessorStat>>(size);
        for (int i = 0; i < size; ++i) {
            String pipelineId = in.readString();
            OperationStats pipelineStat = new OperationStats(in);
            this.pipelineStats.add(new PipelineStat(pipelineId, pipelineStat));
            int processorsSize = in.readVInt();
            ArrayList<ProcessorStat> processorStatsPerPipeline = new ArrayList<ProcessorStat>(processorsSize);
            for (int j = 0; j < processorsSize; ++j) {
                String processorName = in.readString();
                String processorType = "_NOT_AVAILABLE";
                if (in.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
                    processorType = in.readString();
                }
                OperationStats processorStat = new OperationStats(in);
                processorStatsPerPipeline.add(new ProcessorStat(processorName, processorType, processorStat));
            }
            this.processorStats.put(pipelineId, processorStatsPerPipeline);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        out.writeVInt(this.pipelineStats.size());
        for (PipelineStat pipelineStat : this.pipelineStats) {
            out.writeString(pipelineStat.getPipelineId());
            pipelineStat.getStats().writeTo(out);
            List<ProcessorStat> processorStatsForPipeline = this.processorStats.get(pipelineStat.getPipelineId());
            if (processorStatsForPipeline == null) {
                out.writeVInt(0);
                continue;
            }
            out.writeVInt(processorStatsForPipeline.size());
            for (ProcessorStat processorStat : processorStatsForPipeline) {
                out.writeString(processorStat.getName());
                if (out.getVersion().onOrAfter(LegacyESVersion.V_7_6_0)) {
                    out.writeString(processorStat.getType());
                }
                processorStat.getStats().writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("ingest");
        builder.startObject("total");
        this.totalStats.toXContent(builder, params);
        builder.endObject();
        builder.startObject("pipelines");
        for (PipelineStat pipelineStat : this.pipelineStats) {
            builder.startObject(pipelineStat.getPipelineId());
            pipelineStat.getStats().toXContent(builder, params);
            List<ProcessorStat> processorStatsForPipeline = this.processorStats.get(pipelineStat.getPipelineId());
            builder.startArray("processors");
            if (processorStatsForPipeline != null) {
                for (ProcessorStat processorStat : processorStatsForPipeline) {
                    builder.startObject();
                    builder.startObject(processorStat.getName());
                    builder.field("type", processorStat.getType());
                    builder.startObject("stats");
                    processorStat.getStats().toXContent(builder, params);
                    builder.endObject();
                    builder.endObject();
                    builder.endObject();
                }
            }
            builder.endArray();
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public OperationStats getTotalStats() {
        return this.totalStats;
    }

    public List<PipelineStat> getPipelineStats() {
        return this.pipelineStats;
    }

    public Map<String, List<ProcessorStat>> getProcessorStats() {
        return this.processorStats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestStats that = (IngestStats)o;
        return Objects.equals(this.totalStats, that.totalStats) && Objects.equals(this.pipelineStats, that.pipelineStats) && Objects.equals(this.processorStats, that.processorStats);
    }

    public int hashCode() {
        return Objects.hash(this.totalStats, this.pipelineStats, this.processorStats);
    }

    public static class PipelineStat {
        private final String pipelineId;
        private final OperationStats stats;

        public PipelineStat(String pipelineId, OperationStats stats) {
            this.pipelineId = pipelineId;
            this.stats = stats;
        }

        public String getPipelineId() {
            return this.pipelineId;
        }

        public OperationStats getStats() {
            return this.stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PipelineStat that = (PipelineStat)o;
            return Objects.equals(this.pipelineId, that.pipelineId) && Objects.equals(this.stats, that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.pipelineId, this.stats);
        }
    }

    public static class ProcessorStat {
        private final String name;
        private final String type;
        private final OperationStats stats;

        public ProcessorStat(String name, String type, OperationStats stats) {
            this.name = name;
            this.type = type;
            this.stats = stats;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public OperationStats getStats() {
            return this.stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProcessorStat that = (ProcessorStat)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.stats, that.stats);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.stats);
        }
    }

    static class Builder {
        private OperationStats totalStats;
        private List<PipelineStat> pipelineStats = new ArrayList<PipelineStat>();
        private Map<String, List<ProcessorStat>> processorStats = new HashMap<String, List<ProcessorStat>>();

        Builder() {
        }

        Builder addTotalMetrics(OperationMetrics totalMetric) {
            this.totalStats = totalMetric.createStats();
            return this;
        }

        Builder addPipelineMetrics(String pipelineId, OperationMetrics pipelineMetric) {
            this.pipelineStats.add(new PipelineStat(pipelineId, pipelineMetric.createStats()));
            return this;
        }

        Builder addProcessorMetrics(String pipelineId, String processorName, String processorType, OperationMetrics metric) {
            this.processorStats.computeIfAbsent(pipelineId, k -> new ArrayList()).add(new ProcessorStat(processorName, processorType, metric.createStats()));
            return this;
        }

        IngestStats build() {
            return new IngestStats(this.totalStats, Collections.unmodifiableList(this.pipelineStats), Collections.unmodifiableMap(this.processorStats));
        }
    }
}

