/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest;

import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;

public class NamedRoute
extends RestHandler.Route {
    private static final String VALID_ACTION_NAME_PATTERN = "^[a-zA-Z0-9:/*_]*$";
    static final int MAX_LENGTH_OF_ACTION_NAME = 250;
    private final String name;

    public boolean isValidRouteName(String routeName) {
        if (routeName == null || routeName.isBlank() || routeName.length() > 250) {
            return false;
        }
        return routeName.matches(VALID_ACTION_NAME_PATTERN);
    }

    public NamedRoute(RestRequest.Method method, String path, String name) {
        super(method, path);
        if (!this.isValidRouteName(name)) {
            throw new OpenSearchException("Invalid route name specified. The route name may include the following characters 'a-z', 'A-Z', '0-9', ':', '/', '*', '_' and be less than 250 characters", new Object[0]);
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public String toString() {
        return "NamedRoute [method=" + this.method + ", path=" + this.path + ", name=" + this.name + "]";
    }
}

