/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.ShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;

public enum RestStatus {
    CONTINUE(100),
    SWITCHING_PROTOCOLS(101),
    OK(200),
    CREATED(201),
    ACCEPTED(202),
    NON_AUTHORITATIVE_INFORMATION(203),
    NO_CONTENT(204),
    RESET_CONTENT(205),
    PARTIAL_CONTENT(206),
    MULTI_STATUS(207),
    MULTIPLE_CHOICES(300),
    MOVED_PERMANENTLY(301),
    FOUND(302),
    SEE_OTHER(303),
    NOT_MODIFIED(304),
    USE_PROXY(305),
    TEMPORARY_REDIRECT(307),
    BAD_REQUEST(400),
    UNAUTHORIZED(401),
    PAYMENT_REQUIRED(402),
    FORBIDDEN(403),
    NOT_FOUND(404),
    METHOD_NOT_ALLOWED(405),
    NOT_ACCEPTABLE(406),
    PROXY_AUTHENTICATION(407),
    REQUEST_TIMEOUT(408),
    CONFLICT(409),
    GONE(410),
    LENGTH_REQUIRED(411),
    PRECONDITION_FAILED(412),
    REQUEST_ENTITY_TOO_LARGE(413),
    REQUEST_URI_TOO_LONG(414),
    UNSUPPORTED_MEDIA_TYPE(415),
    REQUESTED_RANGE_NOT_SATISFIED(416),
    EXPECTATION_FAILED(417),
    MISDIRECTED_REQUEST(421),
    UNPROCESSABLE_ENTITY(422),
    LOCKED(423),
    FAILED_DEPENDENCY(424),
    TOO_MANY_REQUESTS(429),
    INTERNAL_SERVER_ERROR(500),
    NOT_IMPLEMENTED(501),
    BAD_GATEWAY(502),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504),
    HTTP_VERSION_NOT_SUPPORTED(505),
    INSUFFICIENT_STORAGE(507);

    private static final Map<Integer, RestStatus> CODE_TO_STATUS;
    private int status;

    private RestStatus(int status) {
        this.status = (short)status;
    }

    public int getStatus() {
        return this.status;
    }

    public static RestStatus readFrom(StreamInput in) throws IOException {
        return RestStatus.valueOf(in.readString());
    }

    public static void writeTo(StreamOutput out, RestStatus status) throws IOException {
        out.writeString(status.name());
    }

    public static RestStatus status(int successfulShards, int totalShards, ShardOperationFailedException ... failures) {
        if (failures.length == 0) {
            if (successfulShards == 0 && totalShards > 0) {
                return SERVICE_UNAVAILABLE;
            }
            return OK;
        }
        RestStatus status = OK;
        if (successfulShards == 0 && totalShards > 0) {
            for (ShardOperationFailedException failure : failures) {
                RestStatus shardStatus = failure.status();
                if (shardStatus.getStatus() < status.getStatus()) continue;
                status = failure.status();
            }
            return status;
        }
        return status;
    }

    public static RestStatus fromCode(int code) {
        return CODE_TO_STATUS.get(code);
    }

    static {
        RestStatus[] values = RestStatus.values();
        HashMap<Integer, RestStatus> codeToStatus = new HashMap<Integer, RestStatus>(values.length);
        for (RestStatus value : values) {
            codeToStatus.put(value.status, value);
        }
        CODE_TO_STATUS = Collections.unmodifiableMap(codeToStatus);
    }
}

