/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.BroadcastResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.CollectionUtils;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.AbstractQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.Operator;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryStringQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BytesRestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestBuilderListener;

public class RestActions {
    public static final ParseField _SHARDS_FIELD = new ParseField("_shards", new String[0]);
    public static final ParseField TOTAL_FIELD = new ParseField("total", new String[0]);
    public static final ParseField SUCCESSFUL_FIELD = new ParseField("successful", new String[0]);
    public static final ParseField SKIPPED_FIELD = new ParseField("skipped", new String[0]);
    public static final ParseField FAILED_FIELD = new ParseField("failed", new String[0]);
    public static final ParseField FAILURES_FIELD = new ParseField("failures", new String[0]);

    public static long parseVersion(RestRequest request) {
        if (request.hasParam("version")) {
            return request.paramAsLong("version", -3L);
        }
        String ifMatch = request.header("If-Match");
        if (ifMatch != null) {
            return Long.parseLong(ifMatch);
        }
        return -3L;
    }

    public static long parseVersion(RestRequest request, long defaultVersion) {
        long version = RestActions.parseVersion(request);
        return version == -3L ? defaultVersion : version;
    }

    public static void buildBroadcastShardsHeader(XContentBuilder builder, ToXContent.Params params, BroadcastResponse response) throws IOException {
        RestActions.buildBroadcastShardsHeader(builder, params, response.getTotalShards(), response.getSuccessfulShards(), -1, response.getFailedShards(), response.getShardFailures());
    }

    public static void buildBroadcastShardsHeader(XContentBuilder builder, ToXContent.Params params, int total, int successful, int skipped, int failed, ShardOperationFailedException[] shardFailures) throws IOException {
        builder.startObject(_SHARDS_FIELD.getPreferredName());
        builder.field(TOTAL_FIELD.getPreferredName(), total);
        builder.field(SUCCESSFUL_FIELD.getPreferredName(), successful);
        if (skipped >= 0) {
            builder.field(SKIPPED_FIELD.getPreferredName(), skipped);
        }
        builder.field(FAILED_FIELD.getPreferredName(), failed);
        if (!CollectionUtils.isEmpty(shardFailures)) {
            builder.startArray(FAILURES_FIELD.getPreferredName());
            for (ShardOperationFailedException shardFailure : ExceptionsHelper.groupBy(shardFailures)) {
                shardFailure.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static <NodeResponse extends BaseNodeResponse> void buildNodesHeader(XContentBuilder builder, ToXContent.Params params, BaseNodesResponse<NodeResponse> response) throws IOException {
        int successful = response.getNodes().size();
        int failed = response.failures().size();
        RestActions.buildNodesHeader(builder, params, successful + failed, successful, failed, response.failures());
    }

    public static void buildNodesHeader(XContentBuilder builder, ToXContent.Params params, int total, int successful, int failed, List<FailedNodeException> failures) throws IOException {
        builder.startObject("_nodes");
        builder.field("total", total);
        builder.field("successful", successful);
        builder.field("failed", failed);
        if (!failures.isEmpty()) {
            builder.startArray("failures");
            for (FailedNodeException failure : failures) {
                builder.startObject();
                failure.toXContent(builder, params);
                builder.endObject();
            }
            builder.endArray();
        }
        builder.endObject();
    }

    public static <NodesResponse extends BaseNodesResponse> BytesRestResponse nodesResponse(XContentBuilder builder, ToXContent.Params params, NodesResponse response) throws IOException {
        builder.startObject();
        RestActions.buildNodesHeader(builder, params, response);
        builder.field("cluster_name", response.getClusterName().value());
        ((ToXContent)((Object)response)).toXContent(builder, params);
        builder.endObject();
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    public static QueryBuilder urlParamsToQueryBuilder(RestRequest request) {
        String queryString = request.param("q");
        if (queryString == null) {
            return null;
        }
        QueryStringQueryBuilder queryBuilder = QueryBuilders.queryStringQuery(queryString);
        queryBuilder.defaultField(request.param("df"));
        queryBuilder.analyzer(request.param("analyzer"));
        queryBuilder.analyzeWildcard(request.paramAsBoolean("analyze_wildcard", false));
        queryBuilder.lenient(request.paramAsBoolean("lenient", null));
        String defaultOperator = request.param("default_operator");
        if (defaultOperator != null) {
            queryBuilder.defaultOperator(Operator.fromString(defaultOperator));
        }
        return queryBuilder;
    }

    public static QueryBuilder getQueryContent(XContentParser requestParser) {
        return RestActions.parseTopLevelQueryBuilder("query", requestParser);
    }

    public static QueryBuilder getQueryContent(String fieldName, XContentParser requestParser) {
        return RestActions.parseTopLevelQueryBuilder(fieldName, requestParser);
    }

    private static QueryBuilder parseTopLevelQueryBuilder(String fieldName, XContentParser parser) {
        try {
            QueryBuilder queryBuilder = null;
            XContentParser.Token first = parser.nextToken();
            if (first == null) {
                return null;
            }
            if (first != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "Expected [" + XContentParser.Token.START_OBJECT + "] but found [" + first + "]", parser.getTokenLocation());
            }
            XContentParser.Token token = parser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String currentName = parser.currentName();
                    if (fieldName.equals(currentName)) {
                        queryBuilder = AbstractQueryBuilder.parseInnerQueryBuilder(parser);
                    } else {
                        throw new ParsingException(parser.getTokenLocation(), "request does not support [" + parser.currentName() + "]", new Object[0]);
                    }
                }
                token = parser.nextToken();
            }
            return queryBuilder;
        }
        catch (ParsingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParsingException(parser == null ? null : parser.getTokenLocation(), "Failed to parse", e, new Object[0]);
        }
    }

    public static class NodesResponseRestListener<NodesResponse extends BaseNodesResponse>
    extends RestBuilderListener<NodesResponse> {
        public NodesResponseRestListener(RestChannel channel) {
            super(channel);
        }

        @Override
        public RestResponse buildResponse(NodesResponse response, XContentBuilder builder) throws Exception {
            return RestActions.nodesResponse(builder, this.channel.request(), response);
        }
    }
}

