/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestActions;

public class RestNodesStatsAction
extends BaseRestHandler {
    static final Map<String, Consumer<NodesStatsRequest>> METRICS;
    static final Map<String, Consumer<CommonStatsFlags>> FLAGS;
    private final Set<String> RESPONSE_PARAMS = Collections.singleton("level");

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_nodes/stats"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/stats"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/stats/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/stats/{metric}/{index_metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_nodes/{nodeId}/stats/{metric}/{index_metric}")));
    }

    @Override
    public String getName() {
        return "nodes_stats_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        Set<String> metrics = Strings.tokenizeByCommaToSet(request.param("metric", "_all"));
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest(nodesIds);
        nodesStatsRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            if (request.hasParam("index_metric")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains index metrics [%s] but all stats requested", request.path(), request.param("index_metric")));
            }
            nodesStatsRequest.all();
            nodesStatsRequest.indices(CommonStatsFlags.ALL);
        } else {
            if (metrics.contains("_all")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains _all and individual metrics [%s]", request.path(), request.param("metric")));
            }
            nodesStatsRequest.clear();
            TreeSet<String> invalidMetrics = new TreeSet<String>();
            for (String metric : metrics) {
                Consumer<NodesStatsRequest> handler = METRICS.get(metric);
                if (handler != null) {
                    handler.accept(nodesStatsRequest);
                    continue;
                }
                invalidMetrics.add(metric);
            }
            if (!invalidMetrics.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidMetrics, METRICS.keySet(), "metric"));
            }
            if (metrics.contains("indices")) {
                Set<String> indexMetrics = Strings.tokenizeByCommaToSet(request.param("index_metric", "_all"));
                if (indexMetrics.size() == 1 && indexMetrics.contains("_all")) {
                    nodesStatsRequest.indices(CommonStatsFlags.ALL);
                } else {
                    CommonStatsFlags flags = new CommonStatsFlags(new CommonStatsFlags.Flag[0]);
                    flags.clear();
                    TreeSet<String> invalidIndexMetrics = new TreeSet<String>();
                    for (String indexMetric : indexMetrics) {
                        Consumer<CommonStatsFlags> handler = FLAGS.get(indexMetric);
                        if (handler != null) {
                            handler.accept(flags);
                            continue;
                        }
                        invalidIndexMetrics.add(indexMetric);
                    }
                    if (!invalidIndexMetrics.isEmpty()) {
                        throw new IllegalArgumentException(this.unrecognized(request, invalidIndexMetrics, FLAGS.keySet(), "index metric"));
                    }
                    nodesStatsRequest.indices(flags);
                }
            } else if (request.hasParam("index_metric")) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "request [%s] contains index metrics [%s] but indices stats not requested", request.path(), request.param("index_metric")));
            }
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.FieldData) && (request.hasParam("fields") || request.hasParam("fielddata_fields"))) {
            nodesStatsRequest.indices().fieldDataFields(request.paramAsStringArray("fielddata_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Completion) && (request.hasParam("fields") || request.hasParam("completion_fields"))) {
            nodesStatsRequest.indices().completionDataFields(request.paramAsStringArray("completion_fields", request.paramAsStringArray("fields", null)));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Search) && request.hasParam("groups")) {
            nodesStatsRequest.indices().groups(request.paramAsStringArray("groups", null));
        }
        if (nodesStatsRequest.indices().isSet(CommonStatsFlags.Flag.Segments)) {
            nodesStatsRequest.indices().includeSegmentFileSizes(request.paramAsBoolean("include_segment_file_sizes", false));
        }
        if (request.hasParam("include_all")) {
            nodesStatsRequest.indices().includeAllShardIndexingPressureTrackers(request.paramAsBoolean("include_all", false));
        }
        if (request.hasParam("top")) {
            nodesStatsRequest.indices().includeOnlyTopIndexingPressureMetrics(request.paramAsBoolean("top", false));
        }
        return channel -> client.admin().cluster().nodesStats(nodesStatsRequest, new RestActions.NodesResponseRestListener<NodesStatsResponse>((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return this.RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    private static /* synthetic */ void lambda$static$2(CommonStatsFlags.Flag flag, CommonStatsFlags f) {
        f.set(flag, true);
    }

    static {
        HashMap<String, Consumer<NodesStatsRequest>> map = new HashMap<String, Consumer<NodesStatsRequest>>();
        for (NodesStatsRequest.Metric metric : NodesStatsRequest.Metric.values()) {
            map.put(metric.metricName(), request -> request.addMetric(metric.metricName()));
        }
        map.put("indices", request -> request.indices(true));
        METRICS = Collections.unmodifiableMap(map);
        HashMap<String, Consumer<CommonStatsFlags>> flags = new HashMap<String, Consumer<CommonStatsFlags>>();
        for (Enum enum_ : CommonStatsFlags.Flag.values()) {
            flags.put(((CommonStatsFlags.Flag)enum_).getRestName(), arg_0 -> RestNodesStatsAction.lambda$static$2((CommonStatsFlags.Flag)enum_, arg_0));
        }
        FLAGS = Collections.unmodifiableMap(flags);
    }
}

