/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchTimeoutException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BytesRestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestBuilderListener;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RestGetMappingAction
extends BaseRestHandler {
    private final ThreadPool threadPool;

    public RestGetMappingAction(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/_mappings"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mapping"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_mappings")));
    }

    @Override
    public String getName() {
        return "get_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        GetMappingsRequest getMappingsRequest = new GetMappingsRequest();
        getMappingsRequest.indices(indices);
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        TimeValue clusterManagerTimeout = request.paramAsTime("cluster_manager_timeout", getMappingsRequest.clusterManagerNodeTimeout());
        if (request.hasParam("master_timeout")) {
            if (request.hasParam("cluster_manager_timeout")) {
                throw new OpenSearchParseException("Please only use one of the request parameters [master_timeout, cluster_manager_timeout].", new Object[0]);
            }
            clusterManagerTimeout = request.paramAsTime("master_timeout", getMappingsRequest.clusterManagerNodeTimeout());
        }
        final TimeValue timeout = clusterManagerTimeout;
        getMappingsRequest.clusterManagerNodeTimeout(timeout);
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getMappings(getMappingsRequest, (ActionListener<GetMappingsResponse>)new RestActionListener<GetMappingsResponse>(channel){

            @Override
            protected void processResponse(GetMappingsResponse getMappingsResponse) {
                final long startTimeMs = RestGetMappingAction.this.threadPool.relativeTimeInMillis();
                RestGetMappingAction.this.threadPool.executor("management").execute(ActionRunnable.wrap(this, (ActionListener<T> l) -> new RestBuilderListener<GetMappingsResponse>(this.channel){

                    @Override
                    public RestResponse buildResponse(GetMappingsResponse response, XContentBuilder builder) throws Exception {
                        if (RestGetMappingAction.this.threadPool.relativeTimeInMillis() - startTimeMs > timeout.millis()) {
                            throw new OpenSearchTimeoutException("Timed out getting mappings", new Object[0]);
                        }
                        builder.startObject();
                        response.toXContent(builder, request);
                        builder.endObject();
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                }.onResponse(getMappingsResponse)));
            }
        });
    }
}

