/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.Requests;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.MapperService;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestChannel;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestToXContentListener;

public class RestPutMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutMappingAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mapping/"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mappings/"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mappings/")));
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray(request.param("index")));
        Map<String, Object> sourceAsMap = XContentHelper.convertToMap(request.requiredContent(), false, request.getXContentType()).v2();
        if (MapperService.isMappingSourceTyped("_doc", sourceAsMap)) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests");
        }
        putMappingRequest.source(sourceAsMap);
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", putMappingRequest.clusterManagerNodeTimeout()));
        RestPutMappingAction.parseDeprecatedMasterTimeoutParameter(putMappingRequest, request);
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        putMappingRequest.writeIndexOnly(request.paramAsBoolean("write_index_only", false));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

