/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.ObjectLongCursor;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.common.Table;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestResponseListener;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.AbstractCatAction;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.RestTable;

public class RestFielddataAction
extends AbstractCatAction {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/fielddata"), new RestHandler.Route(RestRequest.Method.GET, "/_cat/fielddata/{fields}")));
    }

    @Override
    public String getName() {
        return "cat_fielddata_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        String[] stringArray;
        NodesStatsRequest nodesStatsRequest = new NodesStatsRequest("data:true");
        nodesStatsRequest.clear();
        nodesStatsRequest.indices(true);
        String[] fields = request.paramAsStringArray("fields", null);
        CommonStatsFlags commonStatsFlags = nodesStatsRequest.indices();
        if (fields == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "*";
        } else {
            stringArray = fields;
        }
        commonStatsFlags.fieldDataFields(stringArray);
        return channel -> client.admin().cluster().nodesStats(nodesStatsRequest, (ActionListener<NodesStatsResponse>)new RestResponseListener<NodesStatsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesStatsResponse nodeStatses) throws Exception {
                return RestTable.buildResponse(RestFielddataAction.this.buildTable(request, nodeStatses), this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/fielddata\n");
        sb.append("/_cat/fielddata/{fields}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders().addCell("id", "desc:node id").addCell("host", "alias:h;desc:host name").addCell("ip", "desc:ip address").addCell("node", "alias:n;desc:node name").addCell("field", "alias:f;desc:field name").addCell("size", "text-align:right;alias:s;desc:field data usage").endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, NodesStatsResponse nodeStatses) {
        Table table = this.getTableWithHeader(request);
        for (NodeStats nodeStats : nodeStatses.getNodes()) {
            if (nodeStats.getIndices().getFieldData().getFields() == null) continue;
            for (ObjectLongCursor<String> cursor : nodeStats.getIndices().getFieldData().getFields()) {
                table.startRow();
                table.addCell(nodeStats.getNode().getId());
                table.addCell(nodeStats.getNode().getHostName());
                table.addCell(nodeStats.getNode().getHostAddress());
                table.addCell(nodeStats.getNode().getName());
                table.addCell(cursor.key);
                table.addCell(new ByteSizeValue(cursor.value));
                table.endRow();
            }
        }
        return table;
    }
}

