/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat;

import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.node.NodeClient;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.RepositoryMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.Table;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.rest.BaseRestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestRequest;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestResponse;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.RestResponseListener;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.AbstractCatAction;
import org.graylog.shaded.opensearch2.org.opensearch.rest.action.cat.RestTable;

public class RestRepositoriesAction
extends AbstractCatAction {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestRepositoriesAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.GET, "/_cat/repositories"));
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        GetRepositoriesRequest getRepositoriesRequest = new GetRepositoriesRequest();
        getRepositoriesRequest.local(request.paramAsBoolean("local", getRepositoriesRequest.local()));
        getRepositoriesRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", getRepositoriesRequest.clusterManagerNodeTimeout()));
        RestRepositoriesAction.parseDeprecatedMasterTimeoutParameter(getRepositoriesRequest, request);
        return channel -> client.admin().cluster().getRepositories(getRepositoriesRequest, (ActionListener<GetRepositoriesResponse>)new RestResponseListener<GetRepositoriesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetRepositoriesResponse getRepositoriesResponse) throws Exception {
                return RestTable.buildResponse(RestRepositoriesAction.this.buildTable(request, getRepositoriesResponse), this.channel);
            }
        });
    }

    @Override
    public String getName() {
        return "cat_repositories_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/repositories\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        return new Table().startHeaders().addCell("id", "alias:id,repoId;desc:unique repository id").addCell("type", "alias:t,type;text-align:right;desc:repository type").endHeaders();
    }

    private Table buildTable(RestRequest req, GetRepositoriesResponse getRepositoriesResponse) {
        Table table = this.getTableWithHeader(req);
        for (RepositoryMetadata repositoryMetadata : getRepositoriesResponse.repositories()) {
            table.startRow();
            table.addCell(repositoryMetadata.name());
            table.addCell(repositoryMetadata.type());
            table.endRow();
        }
        return table;
    }
}

