/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.ResourceNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diff;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.DiffableUtils;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.NamedDiff;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Metadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.script.StoredScriptSource;

public final class ScriptMetadata
implements Metadata.Custom,
Writeable,
ToXContentFragment {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ScriptMetadata.class);
    public static final String TYPE = "stored_scripts";
    private final Map<String, StoredScriptSource> scripts;

    static ScriptMetadata putStoredScript(ScriptMetadata previous, String id, StoredScriptSource source) {
        Builder builder = new Builder(previous);
        builder.storeScript(id, source);
        return builder.build();
    }

    static ScriptMetadata deleteStoredScript(ScriptMetadata previous, String id) {
        Builder builder = new Builder(previous);
        builder.deleteScript(id);
        return builder.build();
    }

    public static ScriptMetadata fromXContent(XContentParser parser) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        String id = null;
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{]", new Object[0]);
        }
        token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    id = parser.currentName();
                    break;
                }
                case VALUE_STRING: {
                    StoredScriptSource exists;
                    if (id == null) {
                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [<id>, <code>, {]", new Object[0]);
                    }
                    int split = id.indexOf(35);
                    if (split == -1) {
                        throw new IllegalArgumentException("illegal stored script id [" + id + "], does not contain lang");
                    }
                    String lang = id.substring(0, split);
                    id = id.substring(split + 1);
                    StoredScriptSource source = new StoredScriptSource(lang, parser.text(), Collections.emptyMap());
                    if (source.getSource().isEmpty()) {
                        if (source.getLang().equals("mustache")) {
                            deprecationLogger.deprecate("empty_templates", "empty templates should no longer be used", new Object[0]);
                        } else {
                            deprecationLogger.deprecate("empty_scripts", "empty scripts should no longer be used", new Object[0]);
                        }
                    }
                    if ((exists = (StoredScriptSource)scripts.get(id)) == null) {
                        scripts.put(id, source);
                    } else if (!exists.getLang().equals(lang)) {
                        throw new IllegalArgumentException("illegal stored script, id [" + id + "] used for multiple scripts with different languages [" + exists.getLang() + "] and [" + lang + "]; scripts using the old namespace of [lang#id] as a stored script id will have to be updated to use only the new namespace of [id]");
                    }
                    id = null;
                    break;
                }
                case START_OBJECT: {
                    if (id == null) {
                        throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [<id>, <code>, {]", new Object[0]);
                    }
                    StoredScriptSource exists = (StoredScriptSource)scripts.get(id);
                    StoredScriptSource source = StoredScriptSource.fromXContent(parser, true);
                    if (exists == null) {
                        if (!id.contains("#")) {
                            scripts.put(id, source);
                        }
                    } else if (!exists.getLang().equals(source.getLang())) {
                        throw new IllegalArgumentException("illegal stored script, id [" + id + "] used for multiple scripts with different languages [" + exists.getLang() + "] and [" + source.getLang() + "]; scripts using the old namespace of [lang#id] as a stored script id will have to be updated to use only the new namespace of [id]");
                    }
                    id = null;
                    break;
                }
                default: {
                    throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [<id>, <code>, {]", new Object[0]);
                }
            }
            token = parser.nextToken();
        }
        return new ScriptMetadata(scripts);
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new ScriptMetadataDiff(in);
    }

    ScriptMetadata(Map<String, StoredScriptSource> scripts) {
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    public ScriptMetadata(StreamInput in) throws IOException {
        HashMap<String, StoredScriptSource> scripts = new HashMap<String, StoredScriptSource>();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String id = in.readString();
            StoredScriptSource source = new StoredScriptSource(in);
            scripts.put(id, source);
        }
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.scripts.size());
        for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, StoredScriptSource> entry : this.scripts.entrySet()) {
            builder.field(entry.getKey());
            entry.getValue().toXContent(builder, params);
        }
        return builder;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom before) {
        return new ScriptMetadataDiff((ScriptMetadata)before, this);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    Map<String, StoredScriptSource> getStoredScripts() {
        return this.scripts;
    }

    StoredScriptSource getStoredScript(String id) {
        return this.scripts.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptMetadata that = (ScriptMetadata)o;
        return this.scripts.equals(that.scripts);
    }

    public int hashCode() {
        return this.scripts.hashCode();
    }

    public String toString() {
        return "ScriptMetadata{scripts=" + this.scripts + "}";
    }

    public static final class Builder {
        private final Map<String, StoredScriptSource> scripts;

        public Builder(ScriptMetadata previous) {
            this.scripts = previous == null ? new HashMap<String, StoredScriptSource>() : new HashMap<String, StoredScriptSource>(previous.scripts);
        }

        public Builder storeScript(String id, StoredScriptSource source) {
            this.scripts.put(id, source);
            return this;
        }

        public Builder deleteScript(String id) {
            StoredScriptSource deleted = this.scripts.remove(id);
            if (deleted == null) {
                throw new ResourceNotFoundException("stored script [" + id + "] does not exist and cannot be deleted", new Object[0]);
            }
            return this;
        }

        public ScriptMetadata build() {
            return new ScriptMetadata(this.scripts);
        }
    }

    static final class ScriptMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, StoredScriptSource>> pipelines;

        ScriptMetadataDiff(ScriptMetadata before, ScriptMetadata after) {
            this.pipelines = DiffableUtils.diff(before.scripts, after.scripts, DiffableUtils.getStringKeySerializer());
        }

        ScriptMetadataDiff(StreamInput in) throws IOException {
            this.pipelines = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), StoredScriptSource::new, StoredScriptSource::readDiffFrom);
        }

        @Override
        public String getWriteableName() {
            return ScriptMetadata.TYPE;
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new ScriptMetadata(this.pipelines.apply(((ScriptMetadata)part).scripts));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.pipelines.writeTo(out);
        }
    }
}

