/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.script;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AbstractDiffable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diff;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParsingException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

public class StoredScriptSource
extends AbstractDiffable<StoredScriptSource>
implements Writeable,
ToXContentObject {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(StoredScriptSource.class);
    public static final ParseField SCRIPT_PARSE_FIELD = new ParseField("script", new String[0]);
    public static final ParseField LANG_PARSE_FIELD = new ParseField("lang", new String[0]);
    public static final ParseField SOURCE_PARSE_FIELD = new ParseField("source", "code");
    public static final ParseField OPTIONS_PARSE_FIELD = new ParseField("options", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("stored script source", true, () -> new Builder());
    private final String lang;
    private final String source;
    private final Map<String, String> options;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StoredScriptSource parse(BytesReference content, XContentType xContentType) {
        try (StreamInput stream = content.streamInput();
             XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, stream);){
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{]", new Object[0]);
            }
            token = parser.nextToken();
            if (token == XContentParser.Token.END_OBJECT) {
                deprecationLogger.deprecate("empty_templates", "empty templates should no longer be used", new Object[0]);
                StoredScriptSource storedScriptSource = new StoredScriptSource("mustache", "", Collections.emptyMap());
                return storedScriptSource;
            }
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + ", expected [" + SCRIPT_PARSE_FIELD.getPreferredName() + "]", new Object[0]);
            }
            String name = parser.currentName();
            if (!SCRIPT_PARSE_FIELD.getPreferredName().equals(name)) throw new ParsingException(parser.getTokenLocation(), "unexpected field [" + name + "], expected [" + SCRIPT_PARSE_FIELD.getPreferredName() + "]", new Object[0]);
            token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) throw new ParsingException(parser.getTokenLocation(), "unexpected token [" + token + "], expected [{, <source>]", new Object[0]);
            StoredScriptSource storedScriptSource = PARSER.apply(parser, null).build(false);
            return storedScriptSource;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public static StoredScriptSource fromXContent(XContentParser parser, boolean ignoreEmpty) {
        return PARSER.apply(parser, null).build(ignoreEmpty);
    }

    public static Diff<StoredScriptSource> readDiffFrom(StreamInput in) throws IOException {
        return StoredScriptSource.readDiffFrom(StoredScriptSource::new, in);
    }

    public StoredScriptSource(String lang, String source, Map<String, String> options) {
        this.lang = Objects.requireNonNull(lang);
        this.source = Objects.requireNonNull(source);
        this.options = Collections.unmodifiableMap(Objects.requireNonNull(options));
    }

    public StoredScriptSource(StreamInput in) throws IOException {
        this.lang = in.readString();
        this.source = in.readString();
        Map<String, Object> options = in.readMap();
        this.options = options;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.lang);
        out.writeString(this.source);
        Map<String, Object> options = this.options;
        out.writeMap(options);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(LANG_PARSE_FIELD.getPreferredName(), this.lang);
        builder.field(SOURCE_PARSE_FIELD.getPreferredName(), this.source);
        if (!this.options.isEmpty()) {
            builder.field(OPTIONS_PARSE_FIELD.getPreferredName(), this.options);
        }
        builder.endObject();
        return builder;
    }

    public String getLang() {
        return this.lang;
    }

    public String getSource() {
        return this.source;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredScriptSource that = (StoredScriptSource)o;
        if (this.lang != null ? !this.lang.equals(that.lang) : that.lang != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return this.options != null ? this.options.equals(that.options) : that.options == null;
    }

    public int hashCode() {
        int result = this.lang != null ? this.lang.hashCode() : 0;
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StoredScriptSource{lang='" + this.lang + "', source='" + this.source + "', options=" + this.options + "}";
    }

    static {
        PARSER.declareString((rec$, x$0) -> ((Builder)rec$).setLang((String)x$0), LANG_PARSE_FIELD);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setSource((XContentParser)x$0), parser -> parser, SOURCE_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField((rec$, x$0) -> ((Builder)rec$).setOptions((Map<String, String>)x$0), XContentParser::mapStrings, OPTIONS_PARSE_FIELD, ObjectParser.ValueType.OBJECT);
    }

    private static final class Builder {
        private String lang;
        private String source;
        private Map<String, String> options = new HashMap<String, String>();

        private Builder() {
        }

        private void setLang(String lang) {
            this.lang = lang;
        }

        private void setSource(XContentParser parser) {
            try {
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    this.source = Strings.toString(builder.copyCurrentStructure(parser));
                    this.options.put("content_type", XContentType.JSON.mediaType());
                } else {
                    this.source = parser.text();
                }
            }
            catch (IOException exception) {
                throw new UncheckedIOException(exception);
            }
        }

        private void setOptions(Map<String, String> options) {
            this.options.putAll(options);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private StoredScriptSource build(boolean ignoreEmpty) {
            if (this.lang == null) {
                throw new IllegalArgumentException("must specify lang for stored script");
            }
            if (this.lang.isEmpty()) {
                throw new IllegalArgumentException("lang cannot be empty");
            }
            if (this.source == null) {
                if (!ignoreEmpty && !"mustache".equals(this.lang)) throw new IllegalArgumentException("must specify source for stored script");
                if ("mustache".equals(this.lang)) {
                    deprecationLogger.deprecate("empty_templates", "empty templates should no longer be used", new Object[0]);
                } else {
                    deprecationLogger.deprecate("empty_scripts", "empty scripts should no longer be used", new Object[0]);
                }
            } else if (this.source.isEmpty()) {
                if (!ignoreEmpty && !"mustache".equals(this.lang)) throw new IllegalArgumentException("source cannot be empty");
                if ("mustache".equals(this.lang)) {
                    deprecationLogger.deprecate("empty_templates", "empty templates should no longer be used", new Object[0]);
                } else {
                    deprecationLogger.deprecate("empty_scripts", "empty scripts should no longer be used", new Object[0]);
                }
            }
            if (this.options.size() <= 1 && (this.options.size() != 1 || this.options.get("content_type") != null)) return new StoredScriptSource(this.lang, this.source, this.options);
            throw new IllegalArgumentException("illegal compiler options [" + this.options + "] specified");
        }
    }
}

