/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchContextId;

public class SearchContextMissingException
extends OpenSearchException {
    private final ShardSearchContextId contextId;

    public SearchContextMissingException(ShardSearchContextId contextId) {
        super("No search context found for id [" + contextId.getId() + "]", new Object[0]);
        this.contextId = contextId;
    }

    public ShardSearchContextId contextId() {
        return this.contextId;
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    public SearchContextMissingException(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.contextId.writeTo(out);
    }
}

