/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.BooleanQuery;
import org.graylog.shaded.opensearch2.org.opensearch.common.CheckedFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.NamedRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeType;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.ShapesAvailability;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.FeatureFlags;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ParseFieldRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ContextParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.BoostingQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.CommonTermsQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.DisMaxQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.DistanceFeatureQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.ExistsQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.FieldMaskingSpanQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.FuzzyQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.GeoBoundingBoxQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.GeoDistanceQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.GeoPolygonQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.GeoShapeQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.IdsQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.IntervalQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.IntervalsSourceProvider;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchBoolPrefixQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchNoneQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchPhrasePrefixQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchPhraseQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MoreLikeThisQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MultiMatchQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.NestedQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.PrefixQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryStringQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.RangeQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.RegexpQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.ScriptQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SimpleQueryStringBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanContainingQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanFirstQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanMultiTermQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanNearQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanNotQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanOrQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanTermQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.SpanWithinQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.TermQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.TermsQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.TermsSetQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.WildcardQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.WrapperQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.ExponentialDecayFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.FieldValueFactorFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.GaussDecayFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.LinearDecayFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.RandomScoreFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.ScoreFunctionParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.ScriptScoreQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.functionscore.WeightBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.SearchPlugin;
import org.graylog.shaded.opensearch2.org.opensearch.search.DocValueFormat;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchExtBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.BaseAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.InternalAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.adjacency.AdjacencyMatrixAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.adjacency.InternalAdjacencyMatrix;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.composite.InternalComposite;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter.InternalFilter;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter.InternalFilters;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.global.GlobalAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.global.InternalGlobal;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.InternalVariableWidthHistogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.missing.InternalMissing;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.missing.MissingAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.nested.InternalNested;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.nested.InternalReverseNested;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.nested.NestedAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.nested.ReverseNestedAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.GeoDistanceAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.InternalBinaryRange;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.InternalDateRange;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.InternalGeoDistance;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.InternalRange;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.IpRangeAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.range.RangeAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.InternalSampler;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.SamplerAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.DoubleTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.InternalMultiTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.LongRareTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.LongTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.MultiTermsAggregationFactory;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.RareTermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.SignificantLongTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.SignificantTermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.SignificantTextAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.StringRareTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.UnmappedRareTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.UnmappedSignificantTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.UnsignedLongTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.ChiSquare;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.GND;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.JLHScore;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.MutualInformation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.PercentageScore;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.ScriptHeuristic;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.ExtendedStatsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.GeoCentroidAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalAvg;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalCardinality;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalExtendedStats;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalGeoCentroid;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalHDRPercentileRanks;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalHDRPercentiles;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalMax;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalMedianAbsoluteDeviation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalMin;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalScriptedMetric;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalStats;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalSum;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalTDigestPercentileRanks;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalTopHits;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalValueCount;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.InternalWeightedAvg;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.PercentileRanksAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.PercentilesAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.ScriptedMetricAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.StatsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.WeightedAvgAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.AvgBucketPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.AvgBucketPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.BucketScriptPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.BucketScriptPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.BucketSelectorPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.BucketSelectorPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.BucketSortPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.BucketSortPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.CumulativeSumPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.CumulativeSumPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.DerivativePipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.DerivativePipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.EwmaModel;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.ExtendedStatsBucketParser;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.ExtendedStatsBucketPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.ExtendedStatsBucketPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.HoltLinearModel;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.HoltWintersModel;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.InternalBucketMetricValue;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.InternalDerivative;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.InternalExtendedStatsBucket;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.InternalPercentilesBucket;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.InternalSimpleValue;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.InternalStatsBucket;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.LinearModel;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MaxBucketPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MaxBucketPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MinBucketPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MinBucketPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MovAvgModel;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MovAvgPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MovAvgPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MovFnPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.MovFnPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.PercentilesBucketPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.PercentilesBucketPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.PipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.SerialDiffPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.SerialDiffPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.SimpleModel;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.StatsBucketPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.StatsBucketPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.SumBucketPipelineAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.pipeline.SumBucketPipelineAggregator;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.ExplainPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchDocValuesPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchFieldsPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchScorePhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchSourcePhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.FetchVersionPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.MatchedQueriesPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.ScriptFieldsPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.SeqNoPrimaryTermPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.FastVectorHighlighter;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.HighlightPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.Highlighter;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.PlainHighlighter;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.UnifiedHighlighter;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryPhaseSearcher;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryPhaseSearcherWrapper;
import org.graylog.shaded.opensearch2.org.opensearch.search.rescore.QueryRescorerBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.rescore.RescorerBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.GeoDistanceSortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.ScoreSortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.ScriptSortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortParser;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortValue;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.Suggest;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.SuggestionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.completion.CompletionSuggestion;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.completion.CompletionSuggestionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.phrase.Laplace;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.phrase.LinearInterpolation;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.phrase.PhraseSuggestion;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.phrase.PhraseSuggestionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.phrase.SmoothingModel;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.phrase.StupidBackoff;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.term.TermSuggestion;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.term.TermSuggestionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class SearchModule {
    public static final Setting<Integer> INDICES_MAX_CLAUSE_COUNT_SETTING = Setting.intSetting("indices.query.bool.max_clause_count", 1024, 1, Integer.MAX_VALUE, Setting.Property.NodeScope);
    private final Map<String, Highlighter> highlighters;
    private final ParseFieldRegistry<MovAvgModel.AbstractModelParser> movingAverageModelParserRegistry = new ParseFieldRegistry("moving_avg_model");
    private final List<FetchSubPhase> fetchSubPhases = new ArrayList<FetchSubPhase>();
    private final Settings settings;
    private final List<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
    private final List<NamedXContentRegistry.Entry> namedXContents = new ArrayList<NamedXContentRegistry.Entry>();
    private final ValuesSourceRegistry valuesSourceRegistry;
    private final QueryPhaseSearcher queryPhaseSearcher;
    private final SearchPlugin.ExecutorServiceProvider indexSearcherExecutorProvider;

    public SearchModule(Settings settings, List<SearchPlugin> plugins) {
        this.settings = settings;
        this.registerSuggesters(plugins);
        this.highlighters = this.setupHighlighters(settings, plugins);
        this.registerScoreFunctions(plugins);
        this.registerQueryParsers(plugins);
        this.registerRescorers(plugins);
        this.registerSortParsers(plugins);
        this.registerValueFormats();
        this.registerSignificanceHeuristics(plugins);
        this.valuesSourceRegistry = this.registerAggregations(plugins);
        this.registerMovingAverageModels(plugins);
        this.registerPipelineAggregations(plugins);
        this.registerFetchSubPhases(plugins);
        this.registerSearchExts(plugins);
        this.registerShapes();
        this.registerIntervalsSourceProviders();
        this.queryPhaseSearcher = this.registerQueryPhaseSearcher(plugins);
        this.indexSearcherExecutorProvider = this.registerIndexSearcherExecutorProvider(plugins);
        this.namedWriteables.addAll(SortValue.namedWriteables());
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return this.namedWriteables;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContents() {
        return this.namedXContents;
    }

    public ValuesSourceRegistry getValuesSourceRegistry() {
        return this.valuesSourceRegistry;
    }

    public Map<String, Highlighter> getHighlighters() {
        return this.highlighters;
    }

    public ParseFieldRegistry<MovAvgModel.AbstractModelParser> getMovingAverageModelParserRegistry() {
        return this.movingAverageModelParserRegistry;
    }

    private ValuesSourceRegistry registerAggregations(List<SearchPlugin> plugins) {
        ValuesSourceRegistry.Builder builder = new ValuesSourceRegistry.Builder();
        this.registerAggregation(new SearchPlugin.AggregationSpec("avg", AvgAggregationBuilder::new, AvgAggregationBuilder.PARSER).addResultReader(InternalAvg::new).setAggregatorRegistrar(AvgAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("weighted_avg", WeightedAvgAggregationBuilder::new, WeightedAvgAggregationBuilder.PARSER).addResultReader(InternalWeightedAvg::new).setAggregatorRegistrar(WeightedAvgAggregationBuilder::registerUsage), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("sum", SumAggregationBuilder::new, SumAggregationBuilder.PARSER).addResultReader(InternalSum::new).setAggregatorRegistrar(SumAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("min", MinAggregationBuilder::new, MinAggregationBuilder.PARSER).addResultReader(InternalMin::new).setAggregatorRegistrar(MinAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("max", MaxAggregationBuilder::new, MaxAggregationBuilder.PARSER).addResultReader(InternalMax::new).setAggregatorRegistrar(MaxAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("stats", StatsAggregationBuilder::new, StatsAggregationBuilder.PARSER).addResultReader(InternalStats::new).setAggregatorRegistrar(StatsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("extended_stats", ExtendedStatsAggregationBuilder::new, ExtendedStatsAggregationBuilder.PARSER).addResultReader(InternalExtendedStats::new).setAggregatorRegistrar(ExtendedStatsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("value_count", ValueCountAggregationBuilder::new, ValueCountAggregationBuilder.PARSER).addResultReader(InternalValueCount::new).setAggregatorRegistrar(ValueCountAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentiles", PercentilesAggregationBuilder::new, PercentilesAggregationBuilder::parse).addResultReader("tdigest_percentiles", InternalTDigestPercentiles::new).addResultReader("hdr_percentiles", InternalHDRPercentiles::new).setAggregatorRegistrar(PercentilesAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("percentile_ranks", PercentileRanksAggregationBuilder::new, PercentileRanksAggregationBuilder::parse).addResultReader("tdigest_percentile_ranks", InternalTDigestPercentileRanks::new).addResultReader("hdr_percentile_ranks", InternalHDRPercentileRanks::new).setAggregatorRegistrar(PercentileRanksAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("median_absolute_deviation", MedianAbsoluteDeviationAggregationBuilder::new, MedianAbsoluteDeviationAggregationBuilder.PARSER).addResultReader(InternalMedianAbsoluteDeviation::new).setAggregatorRegistrar(MedianAbsoluteDeviationAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("cardinality", CardinalityAggregationBuilder::new, CardinalityAggregationBuilder.PARSER).addResultReader(InternalCardinality::new).setAggregatorRegistrar(CardinalityAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("global", GlobalAggregationBuilder::new, GlobalAggregationBuilder::parse).addResultReader(InternalGlobal::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("missing", MissingAggregationBuilder::new, MissingAggregationBuilder.PARSER).addResultReader(InternalMissing::new).setAggregatorRegistrar(MissingAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("filter", FilterAggregationBuilder::new, FilterAggregationBuilder::parse).addResultReader(InternalFilter::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("filters", FiltersAggregationBuilder::new, FiltersAggregationBuilder::parse).addResultReader(InternalFilters::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("adjacency_matrix", AdjacencyMatrixAggregationBuilder::new, AdjacencyMatrixAggregationBuilder::parse).addResultReader(InternalAdjacencyMatrix::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("sampler", SamplerAggregationBuilder::new, SamplerAggregationBuilder::parse).addResultReader("mapped_sampler", InternalSampler::new).addResultReader("unmapped_sampler", UnmappedSampler::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("diversified_sampler", DiversifiedAggregationBuilder::new, DiversifiedAggregationBuilder.PARSER).setAggregatorRegistrar(DiversifiedAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("terms", TermsAggregationBuilder::new, TermsAggregationBuilder.PARSER).addResultReader("sterms", StringTerms::new).addResultReader("umterms", UnmappedTerms::new).addResultReader("lterms", LongTerms::new).addResultReader("dterms", DoubleTerms::new).addResultReader("ulterms", UnsignedLongTerms::new).setAggregatorRegistrar(TermsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("rare_terms", RareTermsAggregationBuilder::new, RareTermsAggregationBuilder.PARSER).addResultReader("srareterms", StringRareTerms::new).addResultReader("umrareterms", UnmappedRareTerms::new).addResultReader("lrareterms", LongRareTerms::new).setAggregatorRegistrar(RareTermsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("significant_terms", SignificantTermsAggregationBuilder::new, SignificantTermsAggregationBuilder::parse).addResultReader("sigsterms", SignificantStringTerms::new).addResultReader("siglterms", SignificantLongTerms::new).addResultReader("umsigterms", UnmappedSignificantTerms::new).setAggregatorRegistrar(SignificantTermsAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("significant_text", SignificantTextAggregationBuilder::new, SignificantTextAggregationBuilder::parse), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("range", RangeAggregationBuilder::new, RangeAggregationBuilder.PARSER).addResultReader(InternalRange::new).setAggregatorRegistrar(RangeAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_range", DateRangeAggregationBuilder::new, DateRangeAggregationBuilder.PARSER).addResultReader(InternalDateRange::new).setAggregatorRegistrar(DateRangeAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("ip_range", IpRangeAggregationBuilder::new, IpRangeAggregationBuilder.PARSER).addResultReader(InternalBinaryRange::new).setAggregatorRegistrar(IpRangeAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("histogram", HistogramAggregationBuilder::new, HistogramAggregationBuilder.PARSER).addResultReader(InternalHistogram::new).setAggregatorRegistrar(HistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("date_histogram", DateHistogramAggregationBuilder::new, DateHistogramAggregationBuilder.PARSER).addResultReader(InternalDateHistogram::new).setAggregatorRegistrar(DateHistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("auto_date_histogram", AutoDateHistogramAggregationBuilder::new, AutoDateHistogramAggregationBuilder.PARSER).addResultReader(InternalAutoDateHistogram::new).setAggregatorRegistrar(AutoDateHistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("variable_width_histogram", VariableWidthHistogramAggregationBuilder::new, VariableWidthHistogramAggregationBuilder.PARSER).addResultReader(InternalVariableWidthHistogram::new).setAggregatorRegistrar(VariableWidthHistogramAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_distance", GeoDistanceAggregationBuilder::new, GeoDistanceAggregationBuilder::parse).addResultReader(InternalGeoDistance::new).setAggregatorRegistrar(GeoDistanceAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("nested", NestedAggregationBuilder::new, NestedAggregationBuilder::parse).addResultReader(InternalNested::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("reverse_nested", ReverseNestedAggregationBuilder::new, ReverseNestedAggregationBuilder::parse).addResultReader(InternalReverseNested::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("top_hits", TopHitsAggregationBuilder::new, TopHitsAggregationBuilder::parse).addResultReader(InternalTopHits::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("geo_centroid", GeoCentroidAggregationBuilder::new, GeoCentroidAggregationBuilder.PARSER).addResultReader(InternalGeoCentroid::new).setAggregatorRegistrar(GeoCentroidAggregationBuilder::registerAggregators), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("scripted_metric", ScriptedMetricAggregationBuilder::new, ScriptedMetricAggregationBuilder.PARSER).addResultReader(InternalScriptedMetric::new), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("composite", CompositeAggregationBuilder::new, CompositeAggregationBuilder.PARSER).addResultReader(InternalComposite::new).setAggregatorRegistrar(reg -> CompositeAggregationBuilder.registerAggregators(reg, plugins)), builder);
        this.registerAggregation(new SearchPlugin.AggregationSpec("multi_terms", MultiTermsAggregationBuilder::new, MultiTermsAggregationBuilder.PARSER).addResultReader(InternalMultiTerms::new).setAggregatorRegistrar(MultiTermsAggregationFactory::registerAggregators), builder);
        this.registerFromPlugin(plugins, SearchPlugin::getAggregations, agg -> this.registerAggregation((SearchPlugin.AggregationSpec)agg, builder));
        this.registerFromPlugin(plugins, SearchPlugin::getAggregationExtentions, registrar -> {
            if (registrar != null) {
                registrar.accept(builder);
            }
        });
        return builder.build();
    }

    private void registerAggregation(SearchPlugin.AggregationSpec spec, ValuesSourceRegistry.Builder builder) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> {
            String name = (String)c;
            return (BaseAggregationBuilder)((ContextParser)spec.getParser()).parse(p, name);
        }));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(AggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> t : spec.getResultReaders().entrySet()) {
            String writeableName = t.getKey();
            Writeable.Reader<? extends InternalAggregation> internalReader = t.getValue();
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, writeableName, internalReader));
        }
        Consumer<ValuesSourceRegistry.Builder> register = spec.getAggregatorRegistrar();
        if (register != null) {
            register.accept(builder);
        } else {
            builder.registerUsage(spec.getName().getPreferredName());
        }
    }

    private void registerPipelineAggregations(List<SearchPlugin> plugins) {
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("derivative", DerivativePipelineAggregationBuilder::new, DerivativePipelineAggregator::new, DerivativePipelineAggregationBuilder::parse).addResultReader(InternalDerivative::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("max_bucket", MaxBucketPipelineAggregationBuilder::new, MaxBucketPipelineAggregator::new, MaxBucketPipelineAggregationBuilder.PARSER).addResultReader("bucket_metric_value", InternalBucketMetricValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("min_bucket", MinBucketPipelineAggregationBuilder::new, MinBucketPipelineAggregator::new, MinBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("avg_bucket", AvgBucketPipelineAggregationBuilder::new, AvgBucketPipelineAggregator::new, AvgBucketPipelineAggregationBuilder.PARSER).addResultReader("simple_value", InternalSimpleValue::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("sum_bucket", SumBucketPipelineAggregationBuilder::new, SumBucketPipelineAggregator::new, SumBucketPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("stats_bucket", StatsBucketPipelineAggregationBuilder::new, StatsBucketPipelineAggregator::new, StatsBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("extended_stats_bucket", ExtendedStatsBucketPipelineAggregationBuilder::new, ExtendedStatsBucketPipelineAggregator::new, (PipelineAggregator.Parser)new ExtendedStatsBucketParser()).addResultReader(InternalExtendedStatsBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("percentiles_bucket", PercentilesBucketPipelineAggregationBuilder::new, PercentilesBucketPipelineAggregator::new, PercentilesBucketPipelineAggregationBuilder.PARSER).addResultReader(InternalPercentilesBucket::new));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("moving_avg", MovAvgPipelineAggregationBuilder::new, MovAvgPipelineAggregator::new, (parser, name) -> MovAvgPipelineAggregationBuilder.parse(this.movingAverageModelParserRegistry, name, parser)));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("cumulative_sum", CumulativeSumPipelineAggregationBuilder::new, CumulativeSumPipelineAggregator::new, CumulativeSumPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_script", BucketScriptPipelineAggregationBuilder::new, BucketScriptPipelineAggregator::new, BucketScriptPipelineAggregationBuilder.PARSER));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_selector", BucketSelectorPipelineAggregationBuilder::new, BucketSelectorPipelineAggregator::new, BucketSelectorPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("bucket_sort", BucketSortPipelineAggregationBuilder::new, BucketSortPipelineAggregator::new, BucketSortPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("serial_diff", SerialDiffPipelineAggregationBuilder::new, SerialDiffPipelineAggregator::new, SerialDiffPipelineAggregationBuilder::parse));
        this.registerPipelineAggregation(new SearchPlugin.PipelineAggregationSpec("moving_fn", MovFnPipelineAggregationBuilder::new, MovFnPipelineAggregator::new, MovFnPipelineAggregationBuilder.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getPipelineAggregations, this::registerPipelineAggregation);
    }

    private void registerPipelineAggregation(SearchPlugin.PipelineAggregationSpec spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(BaseAggregationBuilder.class, spec.getName(), (p, c) -> (BaseAggregationBuilder)((ContextParser)spec.getParser()).parse(p, (String)c)));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregationBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        if (spec.getAggregatorReader() != null) {
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(PipelineAggregator.class, spec.getName().getPreferredName(), spec.getAggregatorReader()));
        }
        for (Map.Entry<String, Writeable.Reader<? extends InternalAggregation>> resultReader : spec.getResultReaders().entrySet()) {
            this.namedWriteables.add(new NamedWriteableRegistry.Entry(InternalAggregation.class, resultReader.getKey(), resultReader.getValue()));
        }
    }

    private void registerShapes() {
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.namedWriteables.addAll(GeoShapeType.getShapeWriteables());
        }
    }

    private void registerRescorers(List<SearchPlugin> plugins) {
        this.registerRescorer(new SearchPlugin.RescorerSpec<QueryRescorerBuilder>("query", QueryRescorerBuilder::new, QueryRescorerBuilder::fromXContent));
        this.registerFromPlugin(plugins, SearchPlugin::getRescorers, this::registerRescorer);
    }

    private void registerRescorer(SearchPlugin.RescorerSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(RescorerBuilder.class, spec.getName(), (p, c) -> (RescorerBuilder)((CheckedFunction)spec.getParser()).apply(p)));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(RescorerBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private <T> void registerFromPlugin(List<SearchPlugin> plugins, Function<SearchPlugin, List<T>> producer, Consumer<T> consumer) {
        for (SearchPlugin plugin : plugins) {
            for (T t : producer.apply(plugin)) {
                consumer.accept(t);
            }
        }
    }

    public static void registerSmoothingModels(List<NamedWriteableRegistry.Entry> namedWriteables) {
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "laplace", Laplace::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "linear", LinearInterpolation::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(SmoothingModel.class, "stupid_backoff", StupidBackoff::new));
    }

    private void registerSuggesters(List<SearchPlugin> plugins) {
        SearchModule.registerSmoothingModels(this.namedWriteables);
        this.registerSuggester(new SearchPlugin.SuggesterSpec<TermSuggestionBuilder>("term", TermSuggestionBuilder::new, TermSuggestionBuilder::fromXContent, TermSuggestion::new));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<PhraseSuggestionBuilder>("phrase", PhraseSuggestionBuilder::new, PhraseSuggestionBuilder::fromXContent, PhraseSuggestion::new));
        this.registerSuggester(new SearchPlugin.SuggesterSpec<CompletionSuggestionBuilder>("completion", CompletionSuggestionBuilder::new, CompletionSuggestionBuilder::fromXContent, CompletionSuggestion::new));
        this.registerFromPlugin(plugins, SearchPlugin::getSuggesters, this::registerSuggester);
    }

    private void registerSuggester(SearchPlugin.SuggesterSpec<?> suggester) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SuggestionBuilder.class, suggester.getName().getPreferredName(), suggester.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(SuggestionBuilder.class, suggester.getName(), (CheckedFunction)suggester.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(Suggest.Suggestion.class, suggester.getName().getPreferredName(), suggester.getSuggestionReader()));
    }

    private Map<String, Highlighter> setupHighlighters(Settings settings, List<SearchPlugin> plugins) {
        NamedRegistry<Highlighter> highlighters = new NamedRegistry<Highlighter>("highlighter");
        highlighters.register("fvh", new FastVectorHighlighter(settings));
        highlighters.register("plain", new PlainHighlighter());
        highlighters.register("unified", new UnifiedHighlighter());
        highlighters.extractAndRegister(plugins, SearchPlugin::getHighlighters);
        return Collections.unmodifiableMap(highlighters.getRegistry());
    }

    private void registerScoreFunctions(List<SearchPlugin> plugins) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScriptScoreFunctionBuilder.class, "script_score", ScriptScoreFunctionBuilder::new));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ScriptScoreFunctionBuilder>("script_score", ScriptScoreFunctionBuilder::new, ScriptScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<GaussDecayFunctionBuilder>("gauss", GaussDecayFunctionBuilder::new, GaussDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<LinearDecayFunctionBuilder>("linear", LinearDecayFunctionBuilder::new, LinearDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<ExponentialDecayFunctionBuilder>("exp", ExponentialDecayFunctionBuilder::new, ExponentialDecayFunctionBuilder.PARSER));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<RandomScoreFunctionBuilder>("random_score", RandomScoreFunctionBuilder::new, RandomScoreFunctionBuilder::fromXContent));
        this.registerScoreFunction(new SearchPlugin.ScoreFunctionSpec<FieldValueFactorFunctionBuilder>("field_value_factor", FieldValueFactorFunctionBuilder::new, FieldValueFactorFunctionBuilder::fromXContent));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, "weight", WeightBuilder::new));
        this.registerFromPlugin(plugins, SearchPlugin::getScoreFunctions, this::registerScoreFunction);
    }

    private void registerScoreFunction(SearchPlugin.ScoreFunctionSpec<?> scoreFunction) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName().getPreferredName(), scoreFunction.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(ScoreFunctionBuilder.class, scoreFunction.getName(), (p, c) -> ((ScoreFunctionParser)scoreFunction.getParser()).fromXContent(p)));
    }

    private void registerValueFormats() {
        this.registerValueFormat(DocValueFormat.BOOLEAN.getWriteableName(), in -> DocValueFormat.BOOLEAN);
        this.registerValueFormat("date_time", DocValueFormat.DateTime::new);
        this.registerValueFormat("decimal", DocValueFormat.Decimal::new);
        this.registerValueFormat(DocValueFormat.GEOHASH.getWriteableName(), in -> DocValueFormat.GEOHASH);
        this.registerValueFormat(DocValueFormat.GEOTILE.getWriteableName(), in -> DocValueFormat.GEOTILE);
        this.registerValueFormat(DocValueFormat.IP.getWriteableName(), in -> DocValueFormat.IP);
        this.registerValueFormat(DocValueFormat.RAW.getWriteableName(), in -> DocValueFormat.RAW);
        this.registerValueFormat(DocValueFormat.BINARY.getWriteableName(), in -> DocValueFormat.BINARY);
        this.registerValueFormat(DocValueFormat.UNSIGNED_LONG_SHIFTED.getWriteableName(), in -> DocValueFormat.UNSIGNED_LONG_SHIFTED);
        this.registerValueFormat(DocValueFormat.UNSIGNED_LONG.getWriteableName(), in -> DocValueFormat.UNSIGNED_LONG);
    }

    private void registerValueFormat(String name, Writeable.Reader<? extends DocValueFormat> reader) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(DocValueFormat.class, name, reader));
    }

    private void registerSignificanceHeuristics(List<SearchPlugin> plugins) {
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<ChiSquare>("chi_square", ChiSquare::new, (BiFunction<XContentParser, Void, ChiSquare>)ChiSquare.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<GND>("gnd", GND::new, (BiFunction<XContentParser, Void, GND>)GND.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<JLHScore>("jlh", JLHScore::new, (BiFunction<XContentParser, Void, JLHScore>)JLHScore.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<MutualInformation>("mutual_information", MutualInformation::new, (BiFunction<XContentParser, Void, MutualInformation>)MutualInformation.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<PercentageScore>("percentage", PercentageScore::new, (BiFunction<XContentParser, Void, PercentageScore>)PercentageScore.PARSER));
        this.registerSignificanceHeuristic(new SearchPlugin.SignificanceHeuristicSpec<ScriptHeuristic>("script_heuristic", ScriptHeuristic::new, (BiFunction<XContentParser, Void, ScriptHeuristic>)ScriptHeuristic.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getSignificanceHeuristics, this::registerSignificanceHeuristic);
    }

    private <T extends SignificanceHeuristic> void registerSignificanceHeuristic(SearchPlugin.SignificanceHeuristicSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SignificanceHeuristic.class, spec.getName(), p -> (SignificanceHeuristic)((BiFunction)spec.getParser()).apply(p, null)));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SignificanceHeuristic.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerMovingAverageModels(List<SearchPlugin> plugins) {
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("simple", SimpleModel::new, SimpleModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("linear", LinearModel::new, LinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("ewma", EwmaModel::new, EwmaModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt", HoltLinearModel::new, HoltLinearModel.PARSER));
        this.registerMovingAverageModel(new SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser>("holt_winters", HoltWintersModel::new, HoltWintersModel.PARSER));
        this.registerFromPlugin(plugins, SearchPlugin::getMovingAverageModels, this::registerMovingAverageModel);
    }

    private void registerMovingAverageModel(SearchPlugin.SearchExtensionSpec<MovAvgModel, MovAvgModel.AbstractModelParser> movAvgModel) {
        this.movingAverageModelParserRegistry.register(movAvgModel.getParser(), movAvgModel.getName());
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(MovAvgModel.class, movAvgModel.getName().getPreferredName(), movAvgModel.getReader()));
    }

    private void registerFetchSubPhases(List<SearchPlugin> plugins) {
        this.registerFetchSubPhase(new ExplainPhase());
        this.registerFetchSubPhase(new FetchDocValuesPhase());
        this.registerFetchSubPhase(new ScriptFieldsPhase());
        this.registerFetchSubPhase(new FetchSourcePhase());
        this.registerFetchSubPhase(new FetchFieldsPhase());
        this.registerFetchSubPhase(new FetchVersionPhase());
        this.registerFetchSubPhase(new SeqNoPrimaryTermPhase());
        this.registerFetchSubPhase(new MatchedQueriesPhase());
        this.registerFetchSubPhase(new HighlightPhase(this.highlighters));
        this.registerFetchSubPhase(new FetchScorePhase());
        SearchPlugin.FetchPhaseConstructionContext context = new SearchPlugin.FetchPhaseConstructionContext(this.highlighters);
        this.registerFromPlugin(plugins, p -> p.getFetchSubPhases(context), this::registerFetchSubPhase);
    }

    private void registerSearchExts(List<SearchPlugin> plugins) {
        this.registerFromPlugin(plugins, SearchPlugin::getSearchExts, this::registerSearchExt);
    }

    private void registerSearchExt(SearchPlugin.SearchExtSpec<?> spec) {
        this.namedXContents.add(new NamedXContentRegistry.Entry(SearchExtBuilder.class, spec.getName(), (CheckedFunction)spec.getParser()));
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SearchExtBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
    }

    private void registerFetchSubPhase(FetchSubPhase subPhase) {
        Class<?> subPhaseClass = subPhase.getClass();
        if (this.fetchSubPhases.stream().anyMatch(p -> p.getClass().equals(subPhaseClass))) {
            throw new IllegalArgumentException("FetchSubPhase [" + subPhaseClass + "] already registered");
        }
        this.fetchSubPhases.add(Objects.requireNonNull(subPhase, "FetchSubPhase must not be null"));
    }

    private void registerQueryParsers(List<SearchPlugin> plugins) {
        this.registerQuery(new SearchPlugin.QuerySpec<MatchQueryBuilder>("match", MatchQueryBuilder::new, MatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhraseQueryBuilder>("match_phrase", MatchPhraseQueryBuilder::new, MatchPhraseQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchPhrasePrefixQueryBuilder>("match_phrase_prefix", MatchPhrasePrefixQueryBuilder::new, MatchPhrasePrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MultiMatchQueryBuilder>("multi_match", MultiMatchQueryBuilder::new, MultiMatchQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<NestedQueryBuilder>("nested", NestedQueryBuilder::new, NestedQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DisMaxQueryBuilder>("dis_max", DisMaxQueryBuilder::new, DisMaxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IdsQueryBuilder>("ids", IdsQueryBuilder::new, IdsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchAllQueryBuilder>("match_all", MatchAllQueryBuilder::new, MatchAllQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<QueryStringQueryBuilder>("query_string", QueryStringQueryBuilder::new, QueryStringQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<BoostingQueryBuilder>("boosting", BoostingQueryBuilder::new, BoostingQueryBuilder::fromXContent));
        BooleanQuery.setMaxClauseCount(INDICES_MAX_CLAUSE_COUNT_SETTING.get(this.settings));
        this.registerQuery(new SearchPlugin.QuerySpec<BoolQueryBuilder>("bool", BoolQueryBuilder::new, BoolQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermQueryBuilder>("term", TermQueryBuilder::new, TermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsQueryBuilder>("terms", TermsQueryBuilder::new, TermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FuzzyQueryBuilder>("fuzzy", FuzzyQueryBuilder::new, FuzzyQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RegexpQueryBuilder>("regexp", RegexpQueryBuilder::new, RegexpQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<RangeQueryBuilder>("range", RangeQueryBuilder::new, RangeQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<PrefixQueryBuilder>("prefix", PrefixQueryBuilder::new, PrefixQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WildcardQueryBuilder>("wildcard", WildcardQueryBuilder::new, WildcardQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ConstantScoreQueryBuilder>("constant_score", ConstantScoreQueryBuilder::new, ConstantScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanTermQueryBuilder>("span_term", SpanTermQueryBuilder::new, SpanTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNotQueryBuilder>("span_not", SpanNotQueryBuilder::new, SpanNotQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanWithinQueryBuilder>("span_within", SpanWithinQueryBuilder::new, SpanWithinQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanContainingQueryBuilder>("span_containing", SpanContainingQueryBuilder::new, SpanContainingQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FieldMaskingSpanQueryBuilder>(FieldMaskingSpanQueryBuilder.SPAN_FIELD_MASKING_FIELD, FieldMaskingSpanQueryBuilder::new, FieldMaskingSpanQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanFirstQueryBuilder>("span_first", SpanFirstQueryBuilder::new, SpanFirstQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder>("span_near", SpanNearQueryBuilder::new, SpanNearQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanNearQueryBuilder.SpanGapQueryBuilder>("span_gap", SpanNearQueryBuilder.SpanGapQueryBuilder::new, SpanNearQueryBuilder.SpanGapQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanOrQueryBuilder>("span_or", SpanOrQueryBuilder::new, SpanOrQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MoreLikeThisQueryBuilder>("more_like_this", MoreLikeThisQueryBuilder::new, MoreLikeThisQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<WrapperQueryBuilder>("wrapper", WrapperQueryBuilder::new, WrapperQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<CommonTermsQueryBuilder>(new ParseField("common", new String[0]).withAllDeprecated("[match] query which can efficiently skip blocks of documents if the total number of hits is not tracked"), CommonTermsQueryBuilder::new, CommonTermsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SpanMultiTermQueryBuilder>("span_multi", SpanMultiTermQueryBuilder::new, SpanMultiTermQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<FunctionScoreQueryBuilder>("function_score", FunctionScoreQueryBuilder::new, FunctionScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptScoreQueryBuilder>("script_score", ScriptScoreQueryBuilder::new, ScriptScoreQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<SimpleQueryStringBuilder>("simple_query_string", SimpleQueryStringBuilder::new, SimpleQueryStringBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ScriptQueryBuilder>("script", ScriptQueryBuilder::new, ScriptQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoDistanceQueryBuilder>("geo_distance", GeoDistanceQueryBuilder::new, GeoDistanceQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoBoundingBoxQueryBuilder>("geo_bounding_box", GeoBoundingBoxQueryBuilder::new, GeoBoundingBoxQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<GeoPolygonQueryBuilder>("geo_polygon", GeoPolygonQueryBuilder::new, GeoPolygonQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<ExistsQueryBuilder>("exists", ExistsQueryBuilder::new, ExistsQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchNoneQueryBuilder>("match_none", MatchNoneQueryBuilder::new, MatchNoneQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<TermsSetQueryBuilder>("terms_set", TermsSetQueryBuilder::new, TermsSetQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<IntervalQueryBuilder>("intervals", IntervalQueryBuilder::new, IntervalQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<DistanceFeatureQueryBuilder>("distance_feature", DistanceFeatureQueryBuilder::new, DistanceFeatureQueryBuilder::fromXContent));
        this.registerQuery(new SearchPlugin.QuerySpec<MatchBoolPrefixQueryBuilder>("match_bool_prefix", MatchBoolPrefixQueryBuilder::new, MatchBoolPrefixQueryBuilder::fromXContent));
        if (ShapesAvailability.JTS_AVAILABLE && ShapesAvailability.SPATIAL4J_AVAILABLE) {
            this.registerQuery(new SearchPlugin.QuerySpec<GeoShapeQueryBuilder>("geo_shape", GeoShapeQueryBuilder::new, GeoShapeQueryBuilder::fromXContent));
        }
        this.registerFromPlugin(plugins, SearchPlugin::getQueries, this::registerQuery);
    }

    private void registerSortParsers(List<SearchPlugin> plugins) {
        this.registerSort(new SearchPlugin.SortSpec<FieldSortBuilder>("field_sort", FieldSortBuilder::new, FieldSortBuilder::fromXContentObject));
        this.registerSort(new SearchPlugin.SortSpec<ScriptSortBuilder>("_script", ScriptSortBuilder::new, ScriptSortBuilder::fromXContent));
        this.registerSort(new SearchPlugin.SortSpec<GeoDistanceSortBuilder>(new ParseField("_geo_distance", "_geoDistance"), GeoDistanceSortBuilder::new, GeoDistanceSortBuilder::fromXContent));
        this.registerSort(new SearchPlugin.SortSpec<ScoreSortBuilder>("_score", ScoreSortBuilder::new, ScoreSortBuilder::fromXContent));
        this.registerFromPlugin(plugins, SearchPlugin::getSorts, this::registerSort);
    }

    private void registerIntervalsSourceProviders() {
        this.namedWriteables.addAll(SearchModule.getIntervalsSourceProviderNamedWritables());
    }

    public static List<NamedWriteableRegistry.Entry> getIntervalsSourceProviderNamedWritables() {
        return Collections.unmodifiableList(Arrays.asList(new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "match", IntervalsSourceProvider.Match::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "all_of", IntervalsSourceProvider.Combine::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "any_of", IntervalsSourceProvider.Disjunction::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "prefix", IntervalsSourceProvider.Prefix::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "wildcard", IntervalsSourceProvider.Wildcard::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "regexp", IntervalsSourceProvider.Regexp::new), new NamedWriteableRegistry.Entry(IntervalsSourceProvider.class, "fuzzy", IntervalsSourceProvider.Fuzzy::new)));
    }

    private void registerQuery(SearchPlugin.QuerySpec<?> spec) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(QueryBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(QueryBuilder.class, spec.getName(), (p, c) -> ((QueryParser)spec.getParser()).fromXContent(p)));
    }

    private void registerSort(SearchPlugin.SortSpec<?> spec) {
        this.namedWriteables.add(new NamedWriteableRegistry.Entry(SortBuilder.class, spec.getName().getPreferredName(), spec.getReader()));
        this.namedXContents.add(new NamedXContentRegistry.Entry(SortBuilder.class, spec.getName(), (p, c) -> ((SortParser)spec.getParser()).fromXContent(p, spec.getName().getPreferredName())));
    }

    private QueryPhaseSearcher registerQueryPhaseSearcher(List<SearchPlugin> plugins) {
        QueryPhaseSearcher searcher = null;
        for (SearchPlugin plugin : plugins) {
            Optional<QueryPhaseSearcher> searcherOpt = plugin.getQueryPhaseSearcher();
            if (searcher == null) {
                searcher = searcherOpt.orElse(null);
                continue;
            }
            if (!searcherOpt.isPresent()) continue;
            throw new IllegalStateException("Only one QueryPhaseSearcher is allowed, but more than one are provided by the plugins");
        }
        if (searcher == null) {
            searcher = new QueryPhaseSearcherWrapper();
        }
        return searcher;
    }

    private SearchPlugin.ExecutorServiceProvider registerIndexSearcherExecutorProvider(List<SearchPlugin> plugins) {
        SearchPlugin.ExecutorServiceProvider provider = null;
        for (SearchPlugin plugin : plugins) {
            Optional<SearchPlugin.ExecutorServiceProvider> providerOpt = plugin.getIndexSearcherExecutorProvider();
            if (provider == null) {
                provider = providerOpt.orElse(null);
                continue;
            }
            if (!providerOpt.isPresent()) continue;
            throw new IllegalStateException("The index searcher executor is already assigned but more than one are provided by the plugins");
        }
        if (provider == null && FeatureFlags.isEnabled("opensearch.experimental.feature.concurrent_segment_search.enabled")) {
            provider = threadPool -> threadPool.executor("index_searcher");
        }
        return provider;
    }

    public FetchPhase getFetchPhase() {
        return new FetchPhase(this.fetchSubPhases);
    }

    public QueryPhase getQueryPhase() {
        return new QueryPhase(this.queryPhaseSearcher);
    }

    @Nullable
    public ExecutorService getIndexSearcherExecutor(ThreadPool pool) {
        return this.indexSearcherExecutorProvider != null ? this.indexSearcherExecutorProvider.getExecutor(pool) : null;
    }
}

