/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.aggregations;

import java.io.IOException;
import java.util.Collections;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.opensearch.common.lucene.search.Queries;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationInitializationException;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.DefaultAggregationProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.GlobalAggCollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.NonGlobalAggCollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.SearchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.InternalProfileCollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QueryPhaseExecutionException;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ReduceableSearchResult;

public class ConcurrentAggregationProcessor
extends DefaultAggregationProcessor {
    @Override
    public void preProcess(SearchContext context) {
        try {
            if (context.aggregations() != null) {
                if (context.aggregations().factories().hasNonGlobalAggregator()) {
                    context.queryCollectorManagers().put(NonGlobalAggCollectorManager.class, new NonGlobalAggCollectorManager(context));
                }
                if (context.aggregations().factories().hasGlobalAggregator()) {
                    context.queryCollectorManagers().put(GlobalAggCollectorManager.class, new GlobalAggCollectorManager(context));
                }
            }
        }
        catch (IOException ex) {
            throw new AggregationInitializationException("Could not initialize aggregators", ex);
        }
    }

    @Override
    public void postProcess(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        InternalProfileCollectorManager globalCollectorManager = context.queryCollectorManagers().get(GlobalAggCollectorManager.class);
        try {
            if (globalCollectorManager != null) {
                Query query = context.buildFilteredQuery(Queries.newMatchAllQuery());
                globalCollectorManager = new InternalProfileCollectorManager(globalCollectorManager, "aggregation_global", Collections.emptyList());
                if (context.getProfilers() != null) {
                    context.getProfilers().addQueryProfiler().setCollector(globalCollectorManager);
                }
                ReduceableSearchResult result = context.searcher().search(query, globalCollectorManager);
                result.reduce(context.queryResult());
            }
        }
        catch (Exception e) {
            throw new QueryPhaseExecutionException(context.shardTarget(), "Failed to execute global aggregators", e);
        }
        context.aggregations(null);
        context.queryCollectorManagers().remove(NonGlobalAggCollectorManager.class);
        context.queryCollectorManagers().remove(GlobalAggCollectorManager.class);
    }
}

